/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.markers.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapWorld;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.impl.MarkerAPIImpl;
import org.dynmap.markers.impl.MarkerIconImpl;
import org.dynmap.markers.impl.MarkerSetImpl;

class MarkerImpl
implements Marker {
    private String markerid;
    private String label;
    private boolean markup;
    private String desc;
    private MarkerSetImpl markerset;
    private double x;
    private double y;
    private double z;
    private String world;
    private String normalized_world;
    private MarkerIconImpl icon;
    private boolean ispersistent;
    private int minzoom;
    private int maxzoom;

    MarkerImpl(String id, String lbl, boolean markup, String world, double x, double y, double z, MarkerIconImpl icon, boolean persistent, MarkerSetImpl set) {
        this.markerid = id;
        this.label = lbl != null ? lbl : id;
        this.markup = markup;
        this.x = x;
        this.y = y;
        this.z = z;
        this.world = world;
        this.normalized_world = DynmapWorld.normalizeWorldName(world);
        this.icon = icon;
        this.desc = null;
        this.ispersistent = persistent;
        this.markerset = set;
        this.minzoom = -1;
        this.maxzoom = -1;
    }

    MarkerImpl(String id, MarkerSetImpl set) {
        this.markerid = id;
        this.markerset = set;
        this.label = id;
        this.markup = false;
        this.desc = null;
        this.z = 0.0;
        this.x = 0.0;
        this.y = 64.0;
        this.normalized_world = "world";
        this.world = "world";
        this.icon = MarkerAPIImpl.getMarkerIconImpl("default");
        this.minzoom = -1;
        this.maxzoom = -1;
    }

    boolean loadPersistentData(ConfigurationNode node) {
        this.label = node.getString("label", this.markerid);
        this.markup = node.getBoolean("markup", false);
        this.x = node.getDouble("x", 0.0);
        this.y = node.getDouble("y", 64.0);
        this.z = node.getDouble("z", 0.0);
        this.world = node.getString("world", "world");
        this.normalized_world = DynmapWorld.normalizeWorldName(this.world);
        this.desc = node.getString("desc", null);
        this.minzoom = node.getInteger("minzoom", -1);
        this.maxzoom = node.getInteger("maxzoom", -1);
        this.icon = MarkerAPIImpl.getMarkerIconImpl(node.getString("icon", "default"));
        if (this.icon == null) {
            this.icon = MarkerAPIImpl.getMarkerIconImpl("default");
        }
        this.ispersistent = true;
        return true;
    }

    void cleanup() {
        this.icon = null;
        this.markerset = null;
    }

    @Override
    public String getUniqueMarkerID() {
        if (this.markerset != null) {
            return this.markerset + ":marker:" + this.markerid;
        }
        return null;
    }

    @Override
    public String getMarkerID() {
        return this.markerid;
    }

    @Override
    public MarkerSet getMarkerSet() {
        return this.markerset;
    }

    @Override
    public void deleteMarker() {
        if (this.markerset == null) {
            return;
        }
        this.markerset.removeMarker(this);
        this.cleanup();
    }

    @Override
    public MarkerIcon getMarkerIcon() {
        return this.icon;
    }

    @Override
    public boolean setMarkerIcon(MarkerIcon icon) {
        if (this.markerset == null) {
            return false;
        }
        if (!(icon instanceof MarkerIconImpl)) {
            return false;
        }
        Set<MarkerIcon> icns = this.markerset.getAllowedMarkerIcons();
        if (icns != null && !icns.contains(icon)) {
            return false;
        }
        this.icon = (MarkerIconImpl)icon;
        MarkerAPIImpl.markerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
        return true;
    }

    @Override
    public boolean isPersistentMarker() {
        return this.ispersistent;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String lbl) {
        this.setLabel(lbl, false);
    }

    @Override
    public void setLabel(String lbl, boolean markup) {
        if (this.markerset == null) {
            return;
        }
        this.label = lbl;
        this.markup = markup;
        MarkerAPIImpl.markerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    Map<String, Object> getPersistentData() {
        if (!this.ispersistent) {
            return null;
        }
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("label", this.label);
        node.put("markup", this.markup);
        node.put("x", this.x);
        node.put("y", this.y);
        node.put("z", this.z);
        node.put("world", this.world);
        node.put("icon", this.icon.getMarkerIconID());
        if (this.minzoom >= 0) {
            node.put("minzoom", this.minzoom);
        }
        if (this.maxzoom >= 0) {
            node.put("maxzoom", this.maxzoom);
        }
        if (this.desc != null) {
            node.put("desc", this.desc);
        }
        return node;
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    @Override
    public String getNormalizedWorld() {
        return this.normalized_world;
    }

    @Override
    public double getX() {
        return this.x;
    }

    @Override
    public double getY() {
        return this.y;
    }

    @Override
    public double getZ() {
        return this.z;
    }

    @Override
    public void setLocation(String worldid, double x, double y, double z) {
        if (this.markerset == null) {
            return;
        }
        this.world = worldid;
        this.x = x;
        this.y = y;
        this.z = z;
        MarkerAPIImpl.markerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public boolean isLabelMarkup() {
        return this.markup;
    }

    @Override
    public void setDescription(String desc) {
        if (this.markerset == null) {
            return;
        }
        if (this.desc == null || !this.desc.equals(desc)) {
            this.desc = desc;
            MarkerAPIImpl.markerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public void setMarkerSet(MarkerSet newset) {
        if (this.markerset != null) {
            this.markerset.removeMarker(this);
        }
        this.markerset = (MarkerSetImpl)newset;
        this.markerset.insertMarker(this);
    }

    static boolean testPointInPolygon(double x, double y, double[] polyx, double[] polyy) {
        int nvert = polyx.length;
        boolean c = false;
        int i = 0;
        int j = nvert - 1;
        while (i < nvert) {
            if (polyy[i] > y != polyy[j] > y && x < (polyx[j] - polyx[i]) * (y - polyy[i]) / (polyy[j] - polyy[i]) + polyx[i]) {
                c = !c;
            }
            j = i++;
        }
        return c;
    }

    @Override
    public int getMinZoom() {
        return this.minzoom;
    }

    @Override
    public void setMinZoom(int zoom) {
        if (zoom < 0) {
            zoom = -1;
        }
        if (this.minzoom == zoom) {
            return;
        }
        this.minzoom = zoom;
        MarkerAPIImpl.markerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public int getMaxZoom() {
        return this.maxzoom;
    }

    @Override
    public void setMaxZoom(int zoom) {
        if (zoom < 0) {
            zoom = -1;
        }
        if (this.maxzoom == zoom) {
            return;
        }
        this.maxzoom = zoom;
        MarkerAPIImpl.markerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }
}

