/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.jetty.server.session;

import org.dynmap.jetty.server.session.AbstractSessionCacheFactory;
import org.dynmap.jetty.server.session.NullSessionCache;
import org.dynmap.jetty.server.session.SessionCache;
import org.dynmap.jetty.server.session.SessionHandler;
import org.dynmap.jetty.util.log.Log;
import org.dynmap.jetty.util.log.Logger;

public class NullSessionCacheFactory
extends AbstractSessionCacheFactory {
    private static final Logger LOG = Log.getLogger("org.dynmap.jetty.server.session");

    @Override
    public int getEvictionPolicy() {
        return 0;
    }

    @Override
    public void setEvictionPolicy(int evictionPolicy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring eviction policy setting for NullSessionCaches", new Object[0]);
        }
    }

    @Override
    public boolean isSaveOnInactiveEvict() {
        return false;
    }

    @Override
    public void setSaveOnInactiveEvict(boolean saveOnInactiveEvict) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Ignoring eviction policy setting for NullSessionCaches", new Object[0]);
        }
    }

    @Override
    public SessionCache getSessionCache(SessionHandler handler) {
        NullSessionCache cache = new NullSessionCache(handler);
        cache.setSaveOnCreate(this.isSaveOnCreate());
        cache.setRemoveUnloadableSessions(this.isRemoveUnloadableSessions());
        cache.setFlushOnResponseCommit(this.isFlushOnResponseCommit());
        return cache;
    }
}

