/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import org.dynmap.hdmap.CustomBlockModel;
import org.dynmap.hdmap.HDBlockModel;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.hdmap.HDBlockPatchModel;
import org.dynmap.hdmap.HDBlockVolumetricModel;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.utils.PatchDefinition;

public class HDScaledBlockModels {
    private short[][] modelvectors;
    private PatchDefinition[][] patches;
    private CustomBlockModel[] custom;

    public HDScaledBlockModels(int scale) {
        short[][] blockmodels = new short[DynmapBlockState.getGlobalIndexMax()][];
        PatchDefinition[][] patches = new PatchDefinition[DynmapBlockState.getGlobalIndexMax()][];
        CustomBlockModel[] custom = new CustomBlockModel[DynmapBlockState.getGlobalIndexMax()];
        for (Integer gidx : HDBlockModels.models_by_id_data.keySet()) {
            CustomBlockModel cbm;
            HDBlockModel m = HDBlockModels.models_by_id_data.get(gidx);
            if (m instanceof HDBlockVolumetricModel) {
                HDBlockVolumetricModel vm = (HDBlockVolumetricModel)m;
                short[] smod = vm.getScaledMap(scale);
                if (smod == null) continue;
                boolean keep = false;
                for (int i = 0; !keep && i < smod.length; ++i) {
                    if (smod[i] != 0) continue;
                    keep = true;
                }
                if (keep) {
                    blockmodels[gidx.intValue()] = smod;
                    continue;
                }
                blockmodels[gidx.intValue()] = null;
                continue;
            }
            if (m instanceof HDBlockPatchModel) {
                HDBlockPatchModel pm = (HDBlockPatchModel)m;
                patches[gidx.intValue()] = pm.getPatches();
                continue;
            }
            if (!(m instanceof CustomBlockModel)) continue;
            custom[gidx.intValue()] = cbm = (CustomBlockModel)m;
        }
        this.modelvectors = blockmodels;
        this.patches = patches;
        this.custom = custom;
    }

    public final short[] getScaledModel(DynmapBlockState blk) {
        short[] m = null;
        try {
            m = this.modelvectors[blk.globalStateIndex];
        }
        catch (ArrayIndexOutOfBoundsException aioobx) {
            short[][] newmodels = new short[blk.globalStateIndex + 1][];
            System.arraycopy(this.modelvectors, 0, newmodels, 0, this.modelvectors.length);
            this.modelvectors = newmodels;
        }
        return m;
    }

    public PatchDefinition[] getPatchModel(DynmapBlockState blk) {
        PatchDefinition[] p = null;
        try {
            p = this.patches[blk.globalStateIndex];
        }
        catch (ArrayIndexOutOfBoundsException aioobx) {
            PatchDefinition[][] newpatches = new PatchDefinition[blk.globalStateIndex + 1][];
            System.arraycopy(this.patches, 0, newpatches, 0, this.patches.length);
            this.patches = newpatches;
        }
        return p;
    }

    public CustomBlockModel getCustomBlockModel(DynmapBlockState blk) {
        CustomBlockModel m = null;
        try {
            m = this.custom[blk.globalStateIndex];
        }
        catch (ArrayIndexOutOfBoundsException aioobx) {
            CustomBlockModel[] newcustom = new CustomBlockModel[blk.globalStateIndex + 1];
            System.arraycopy(this.custom, 0, newcustom, 0, this.custom.length);
            this.custom = newcustom;
        }
        return m;
    }
}

