/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap;

import java.util.BitSet;
import java.util.Map;
import org.dynmap.Log;
import org.dynmap.hdmap.HDBlockModel;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.DynmapBlockState;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;

public class CustomBlockModel
extends HDBlockModel {
    public CustomRenderer render;
    private static final RenderPatch[] empty_list = new RenderPatch[0];

    public CustomBlockModel(DynmapBlockState bstate, BitSet databits, String classname, Map<String, String> classparm, String blockset) {
        super(bstate, databits, blockset);
        try {
            Class<?> cls = Class.forName(classname);
            this.render = (CustomRenderer)cls.newInstance();
            if (!this.render.initializeRenderer(HDBlockModels.pdf, bstate.blockName, databits, classparm)) {
                Log.severe("Error loading custom renderer - " + classname);
                this.render = null;
            } else if (this.render.getTileEntityFieldsNeeded() != null) {
                DynmapBlockState bbs = bstate.baseState;
                for (int i = 0; i < bbs.getStateCount(); ++i) {
                    if (!databits.isEmpty() && !databits.get(i)) continue;
                    DynmapBlockState bs = bbs.getState(i);
                    HDBlockModels.customModelsRequestingTileData.set(bs.globalStateIndex);
                }
            }
        }
        catch (Exception x) {
            Log.severe("Error loading custom renderer - " + classname, x);
            this.render = null;
        }
    }

    @Override
    public int getTextureCount() {
        return this.render.getMaximumTextureCount(HDBlockModels.pdf);
    }

    public RenderPatch[] getMeshForBlock(MapDataContext ctx) {
        if (this.render != null) {
            return this.render.getRenderPatchList(ctx);
        }
        return empty_list;
    }

    @Override
    public void removed(DynmapBlockState blk) {
        super.removed(blk);
        HDBlockModels.customModelsRequestingTileData.clear(blk.globalStateIndex);
    }
}

