/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.common;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Map;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.common.DynmapPlayer;

public class DynmapListenerManager {
    private DynmapCore core;
    private Map<EventType, ArrayList<EventListener>> listeners = new EnumMap<EventType, ArrayList<EventListener>>(EventType.class);

    public DynmapListenerManager(DynmapCore core) {
        this.core = core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(EventType type, EventListener listener) {
        Map<EventType, ArrayList<EventListener>> map = this.listeners;
        synchronized (map) {
            ArrayList<EventListener> lst = this.listeners.get((Object)type);
            if (lst == null) {
                lst = new ArrayList();
                this.listeners.put(type, lst);
                this.core.getServer().requestEventNotification(type);
            }
            lst.add(listener);
        }
    }

    public void processWorldEvent(EventType type, DynmapWorld w) {
        ArrayList<EventListener> lst = this.listeners.get((Object)type);
        if (lst == null) {
            return;
        }
        int sz = lst.size();
        for (int i = 0; i < sz; ++i) {
            EventListener el = lst.get(i);
            if (!(el instanceof WorldEventListener)) continue;
            try {
                ((WorldEventListener)el).worldEvent(w);
                continue;
            }
            catch (Throwable t) {
                Log.warning("processWorldEvent(" + (Object)((Object)type) + "," + w + ") - exception", t);
            }
        }
    }

    public void processPlayerEvent(EventType type, DynmapPlayer p) {
        ArrayList<EventListener> lst = this.listeners.get((Object)type);
        if (lst == null) {
            return;
        }
        int sz = lst.size();
        for (int i = 0; i < sz; ++i) {
            EventListener el = lst.get(i);
            if (!(el instanceof PlayerEventListener)) continue;
            try {
                ((PlayerEventListener)el).playerEvent(p);
                continue;
            }
            catch (Throwable t) {
                Log.warning("processPlayerEvent(" + (Object)((Object)type) + "," + p + ") - exception", t);
            }
        }
    }

    public void processChatEvent(EventType type, DynmapPlayer p, String msg) {
        ArrayList<EventListener> lst = this.listeners.get((Object)type);
        if (lst == null) {
            return;
        }
        int sz = lst.size();
        for (int i = 0; i < sz; ++i) {
            EventListener el = lst.get(i);
            if (!(el instanceof ChatEventListener)) continue;
            try {
                ((ChatEventListener)el).chatEvent(p, msg);
                continue;
            }
            catch (Throwable t) {
                Log.warning("processChatEvent(" + (Object)((Object)type) + "," + msg + ") - exception", t);
            }
        }
    }

    public void processBlockEvent(EventType type, String material, String world, int x, int y, int z) {
        ArrayList<EventListener> lst = this.listeners.get((Object)type);
        if (lst == null) {
            return;
        }
        int sz = lst.size();
        for (int i = 0; i < sz; ++i) {
            EventListener el = lst.get(i);
            if (!(el instanceof BlockEventListener)) continue;
            try {
                ((BlockEventListener)el).blockEvent(material, world, x, y, z);
                continue;
            }
            catch (Throwable t) {
                Log.warning("processBlockEvent(" + (Object)((Object)type) + "," + material + "," + world + "," + x + "," + y + "," + z + ") - exception", t);
            }
        }
    }

    public void processSignChangeEvent(EventType type, String material, String world, int x, int y, int z, String[] lines, DynmapPlayer p) {
        ArrayList<EventListener> lst = this.listeners.get((Object)type);
        if (lst == null) {
            return;
        }
        int sz = lst.size();
        for (int i = 0; i < sz; ++i) {
            EventListener el = lst.get(i);
            if (!(el instanceof SignChangeEventListener)) continue;
            try {
                ((SignChangeEventListener)el).signChangeEvent(material, world, x, y, z, lines, p);
                continue;
            }
            catch (Throwable t) {
                Log.warning("processSignChangeEvent(" + (Object)((Object)type) + "," + material + "," + world + "," + x + "," + y + "," + z + ") - exception", t);
            }
        }
    }

    public void cleanup() {
        for (ArrayList<EventListener> l : this.listeners.values()) {
            l.clear();
        }
        this.listeners.clear();
    }

    public static enum EventType {
        WORLD_LOAD,
        WORLD_UNLOAD,
        WORLD_SPAWN_CHANGE,
        PLAYER_JOIN,
        PLAYER_QUIT,
        PLAYER_BED_LEAVE,
        PLAYER_CHAT,
        BLOCK_BREAK,
        SIGN_CHANGE;

    }

    public static interface SignChangeEventListener
    extends EventListener {
        public void signChangeEvent(String var1, String var2, int var3, int var4, int var5, String[] var6, DynmapPlayer var7);
    }

    public static interface BlockEventListener
    extends EventListener {
        public void blockEvent(String var1, String var2, int var3, int var4, int var5);
    }

    public static interface ChatEventListener
    extends EventListener {
        public void chatEvent(DynmapPlayer var1, String var2);
    }

    public static interface PlayerEventListener
    extends EventListener {
        public void playerEvent(DynmapPlayer var1);
    }

    public static interface WorldEventListener
    extends EventListener {
        public void worldEvent(DynmapWorld var1);
    }

    public static interface EventListener {
    }
}

