/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.tileentity;

import com.google.common.collect.ImmutableSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import twilightforest.TFConfig;
import twilightforest.block.BlockTFTowerTranslucent;
import twilightforest.block.TFBlocks;
import twilightforest.enums.TowerTranslucentVariant;

public class TileEntityTFAntibuilder
extends TileEntity
implements ITickable {
    private static final int REVERT_CHANCE = 10;
    private final int radius = 4;
    private final int diameter = 9;
    private final double requiredPlayerRange = 16.0;
    private final Random rand = new Random();
    private int tickCount;
    private boolean slowScan;
    private int ticksSinceChange;
    private IBlockState[] blockData;

    public void func_73660_a() {
        if (this.anyPlayerInRange()) {
            ++this.tickCount;
            if (this.field_145850_b.field_72995_K) {
                double x = (float)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextFloat();
                double y = (float)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextFloat();
                double z = (float)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextFloat();
                this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, x, y, z, 0.0, 0.0, 0.0, new int[0]);
                if (this.rand.nextInt(10) == 0) {
                    this.makeRandomOutline();
                    this.makeRandomOutline();
                    this.makeRandomOutline();
                }
            } else {
                if (this.blockData == null && this.field_145850_b.func_175697_a(this.field_174879_c, this.radius)) {
                    this.captureBlockData();
                    this.slowScan = true;
                }
                if (!(this.blockData == null || this.slowScan && this.tickCount % 20 != 0)) {
                    if (this.scanAndRevertChanges()) {
                        this.slowScan = false;
                        this.ticksSinceChange = 0;
                    } else {
                        ++this.ticksSinceChange;
                        if (this.ticksSinceChange > 20) {
                            this.slowScan = true;
                        }
                    }
                }
            }
        } else {
            this.blockData = null;
            this.tickCount = 0;
        }
    }

    private void makeRandomOutline() {
        this.makeOutline(this.rand.nextInt(12));
    }

    private void makeOutline(int outline) {
        double sx = this.field_174879_c.func_177958_n();
        double sy = this.field_174879_c.func_177956_o();
        double sz = this.field_174879_c.func_177952_p();
        double dx = this.field_174879_c.func_177958_n();
        double dy = this.field_174879_c.func_177956_o();
        double dz = this.field_174879_c.func_177952_p();
        switch (outline) {
            case 0: 
            case 8: {
                sx -= 4.0;
                dx += 5.0;
                sz -= 4.0;
                dz -= 4.0;
                break;
            }
            case 1: 
            case 9: {
                sx -= 4.0;
                dx -= 4.0;
                sz -= 4.0;
                dz += 5.0;
                break;
            }
            case 2: 
            case 10: {
                sx -= 4.0;
                dx += 5.0;
                sz += 5.0;
                dz += 5.0;
                break;
            }
            case 3: 
            case 11: {
                sx += 5.0;
                dx += 5.0;
                sz -= 4.0;
                dz += 5.0;
                break;
            }
            case 4: {
                sx -= 4.0;
                dx -= 4.0;
                sz -= 4.0;
                dz -= 4.0;
                break;
            }
            case 5: {
                sx += 5.0;
                dx += 5.0;
                sz -= 4.0;
                dz -= 4.0;
                break;
            }
            case 6: {
                sx += 5.0;
                dx += 5.0;
                sz += 5.0;
                dz += 5.0;
                break;
            }
            case 7: {
                sx -= 4.0;
                dx -= 4.0;
                sz += 5.0;
                dz += 5.0;
            }
        }
        switch (outline) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                sy += 5.0;
                dy += 5.0;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                sy -= 4.0;
                dy += 5.0;
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                sy -= 4.0;
                dy -= 4.0;
            }
        }
        if (this.rand.nextBoolean()) {
            this.drawParticleLine((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, dx, dy, dz);
        } else {
            this.drawParticleLine(sx, sy, sz, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
        }
        this.drawParticleLine(sx, sy, sz, dx, dy, dz);
    }

    private void drawParticleLine(double srcX, double srcY, double srcZ, double destX, double destY, double destZ) {
        int particles = 16;
        for (int i = 0; i < particles; ++i) {
            double trailFactor = (double)i / ((double)particles - 1.0);
            double tx = srcX + (destX - srcX) * trailFactor + (double)this.rand.nextFloat() * 0.005;
            double ty = srcY + (destY - srcY) * trailFactor + (double)this.rand.nextFloat() * 0.005;
            double tz = srcZ + (destZ - srcZ) * trailFactor + (double)this.rand.nextFloat() * 0.005;
            this.field_145850_b.func_175688_a(EnumParticleTypes.REDSTONE, tx, ty, tz, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    private boolean scanAndRevertChanges() {
        int index = 0;
        boolean reverted = false;
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    IBlockState stateThere = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(x, y, z));
                    if (this.blockData[index].func_177230_c() != stateThere.func_177230_c()) {
                        if (this.revertBlock(this.field_174879_c.func_177982_a(x, y, z), stateThere, this.blockData[index])) {
                            reverted = true;
                        } else {
                            this.blockData[index] = stateThere;
                        }
                    }
                    ++index;
                }
            }
        }
        return reverted;
    }

    private boolean revertBlock(BlockPos pos, IBlockState stateThere, IBlockState replaceWith) {
        if (stateThere.func_177230_c() == Blocks.field_150350_a && !replaceWith.func_185904_a().func_76230_c()) {
            return false;
        }
        if (stateThere.func_185887_b(this.field_145850_b, pos) < 0.0f || this.isUnrevertable(stateThere, replaceWith)) {
            return false;
        }
        if (this.rand.nextInt(10) == 0) {
            if (replaceWith.func_177230_c() != Blocks.field_150350_a) {
                replaceWith = TFBlocks.tower_translucent.func_176223_P().func_177226_a(BlockTFTowerTranslucent.VARIANT, (Comparable)((Object)TowerTranslucentVariant.REVERTER_REPLACEMENT));
            }
            this.field_145850_b.func_180501_a(pos, replaceWith, 2);
            if (stateThere.func_177230_c() == Blocks.field_150350_a) {
                this.field_145850_b.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)replaceWith));
            } else if (replaceWith.func_177230_c() == Blocks.field_150350_a) {
                this.field_145850_b.func_175718_b(2001, pos, Block.func_176210_f((IBlockState)stateThere));
                stateThere.func_177230_c().func_176226_b(this.field_145850_b, pos, stateThere, 0);
            }
        }
        return true;
    }

    private boolean isUnrevertable(IBlockState stateThere, IBlockState replaceWith) {
        if (stateThere.func_177230_c() == TFBlocks.tower_device || replaceWith.func_177230_c() == TFBlocks.tower_device) {
            return true;
        }
        if (stateThere.func_177230_c() == TFBlocks.tower_translucent && stateThere.func_177229_b(BlockTFTowerTranslucent.VARIANT) != TowerTranslucentVariant.REVERTER_REPLACEMENT || replaceWith.func_177230_c() == TFBlocks.tower_translucent && replaceWith.func_177229_b(BlockTFTowerTranslucent.VARIANT) != TowerTranslucentVariant.REVERTER_REPLACEMENT) {
            return true;
        }
        if (stateThere.func_177230_c() == Blocks.field_150379_bu && replaceWith.func_177230_c() == Blocks.field_150374_bv) {
            return true;
        }
        if (stateThere.func_177230_c() == Blocks.field_150374_bv && replaceWith.func_177230_c() == Blocks.field_150379_bu) {
            return true;
        }
        if (stateThere.func_177230_c() == Blocks.field_150355_j || replaceWith.func_177230_c() == Blocks.field_150358_i) {
            return true;
        }
        if (stateThere.func_177230_c() == Blocks.field_150358_i || replaceWith.func_177230_c() == Blocks.field_150355_j) {
            return true;
        }
        if (replaceWith.func_177230_c() == Blocks.field_150335_W) {
            return true;
        }
        ImmutableSet<IBlockState> blacklist = TFConfig.getDisallowedBlocks();
        return blacklist.contains((Object)stateThere) || blacklist.contains((Object)replaceWith);
    }

    private void captureBlockData() {
        this.blockData = new IBlockState[729];
        int index = 0;
        for (int x = -4; x <= 4; ++x) {
            for (int y = -4; y <= 4; ++y) {
                for (int z = -4; z <= 4; ++z) {
                    this.blockData[index] = this.field_145850_b.func_180495_p(this.field_174879_c.func_177982_a(x, y, z));
                    ++index;
                }
            }
        }
    }

    private boolean anyPlayerInRange() {
        return this.field_145850_b.func_175636_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.requiredPlayerRange);
    }
}

