/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.structures.darktower;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.BlockLadder;
import net.minecraft.block.BlockLever;
import net.minecraft.block.BlockLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockRedstoneRepeater;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.StructureComponent;
import net.minecraft.world.gen.structure.template.TemplateManager;
import twilightforest.TFFeature;
import twilightforest.block.BlockTFLog;
import twilightforest.block.BlockTFTowerDevice;
import twilightforest.block.TFBlocks;
import twilightforest.enums.TowerDeviceVariant;
import twilightforest.enums.WoodVariant;
import twilightforest.loot.TFTreasure;
import twilightforest.structures.StructureTFComponentOld;
import twilightforest.structures.StructureTFDecorator;
import twilightforest.structures.darktower.ComponentTFDarkTowerBalcony;
import twilightforest.structures.darktower.ComponentTFDarkTowerBeard;
import twilightforest.structures.darktower.ComponentTFDarkTowerBridge;
import twilightforest.structures.darktower.ComponentTFDarkTowerRoof;
import twilightforest.structures.darktower.ComponentTFDarkTowerRoofAntenna;
import twilightforest.structures.darktower.ComponentTFDarkTowerRoofCactus;
import twilightforest.structures.darktower.ComponentTFDarkTowerRoofFourPost;
import twilightforest.structures.darktower.ComponentTFDarkTowerRoofRings;
import twilightforest.structures.darktower.EnumDarkTowerDoor;
import twilightforest.structures.darktower.StructureDecoratorDarkTower;
import twilightforest.structures.lichtower.ComponentTFTowerRoof;
import twilightforest.structures.lichtower.ComponentTFTowerRoofAttachedSlab;
import twilightforest.structures.lichtower.ComponentTFTowerRoofFence;
import twilightforest.structures.lichtower.ComponentTFTowerRoofGableForwards;
import twilightforest.structures.lichtower.ComponentTFTowerRoofSlabForwards;
import twilightforest.structures.lichtower.ComponentTFTowerWing;
import twilightforest.util.RotationUtil;
import twilightforest.util.TFEntityNames;

public class ComponentTFDarkTowerWing
extends ComponentTFTowerWing {
    protected boolean keyTower = false;
    protected ArrayList<EnumDarkTowerDoor> openingTypes = new ArrayList();

    public ComponentTFDarkTowerWing() {
    }

    protected ComponentTFDarkTowerWing(TFFeature feature, int i, int x, int y, int z, int pSize, int pHeight, EnumFacing direction) {
        super(feature, i, x, y, z, pSize, pHeight, direction);
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        tagCompound.func_74757_a("keyTower", this.keyTower);
        tagCompound.func_74783_a("doorTypeInts", this.getDoorsTypesAsIntArray());
    }

    private int[] getDoorsTypesAsIntArray() {
        int[] ret = new int[this.openingTypes.size()];
        int idx = 0;
        for (EnumDarkTowerDoor doorType : this.openingTypes) {
            ret[idx++] = doorType.ordinal();
        }
        return ret;
    }

    @Override
    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager templateManager) {
        super.func_143011_b(tagCompound, templateManager);
        this.keyTower = tagCompound.func_74767_n("keyTower");
        this.readDoorsTypesFromArray(tagCompound.func_74759_k("doorTypeInts"));
    }

    private void readDoorsTypesFromArray(int[] intArray) {
        for (int typeInt : intArray) {
            this.openingTypes.add(EnumDarkTowerDoor.values()[typeInt]);
        }
    }

    @Override
    public void func_74861_a(StructureComponent parent, List<StructureComponent> list, Random rand) {
        if (parent != null && parent instanceof StructureTFComponentOld) {
            this.deco = ((StructureTFComponentOld)parent).deco;
        }
        this.addOpening(0, 1, this.size / 2, Rotation.CLOCKWISE_180);
        this.makeARoof(parent, list, rand);
        this.makeABeard(parent, list, rand);
        if (this.size > 10) {
            for (Rotation direction : RotationUtil.ROTATIONS) {
                int[] dest = this.getValidOpening(rand, direction);
                int childSize = this.size - 2;
                int childHeight = this.validateChildHeight(this.height - 4 + rand.nextInt(10) - rand.nextInt(10), childSize);
                boolean madeWing = this.makeTowerWing(list, rand, this.func_74877_c(), dest[0], dest[1], dest[2], this.size - 2, childHeight, direction);
                if (madeWing || direction != Rotation.CLOCKWISE_180 && !rand.nextBoolean()) continue;
                this.makeTowerBalcony(list, rand, this.func_74877_c(), dest[0], dest[1], dest[2], direction);
            }
        } else if (rand.nextInt(4) == 0) {
            Rotation direction = RotationUtil.ROTATIONS[rand.nextInt(4)];
            int[] dest = this.getValidOpening(rand, direction);
            this.makeTowerBalcony(list, rand, this.func_74877_c(), dest[0], dest[1], dest[2], direction);
        }
    }

    protected int validateChildHeight(int childHeight, int childSize) {
        return childHeight / 4 * 4 + 1;
    }

    @Override
    public void makeARoof(StructureComponent parent, List<StructureComponent> list, Random rand) {
        ComponentTFDarkTowerRoof roof;
        int index = this.func_74877_c();
        switch (rand.nextInt(5)) {
            default: {
                roof = new ComponentTFDarkTowerRoofAntenna(this.getFeatureType(), index, this);
                break;
            }
            case 2: {
                roof = new ComponentTFDarkTowerRoofCactus(this.getFeatureType(), index, this);
                break;
            }
            case 3: {
                roof = new ComponentTFDarkTowerRoofRings(this.getFeatureType(), index, this);
                break;
            }
            case 4: {
                roof = new ComponentTFDarkTowerRoofFourPost(this.getFeatureType(), index, this);
            }
        }
        list.add(roof);
        roof.func_74861_a(this, list, rand);
        this.roofType = ((Object)((Object)roof)).getClass();
    }

    @Override
    protected void makeAttachedRoof(List<StructureComponent> list, Random rand) {
        ComponentTFTowerRoof roof;
        int index = this.func_74877_c();
        if (this.roofType == null && rand.nextInt(32) != 0) {
            this.tryToFitRoof(list, rand, new ComponentTFTowerRoofGableForwards(this.getFeatureType(), index + 1, this));
        }
        if (this.roofType == null && rand.nextInt(8) != 0) {
            this.tryToFitRoof(list, rand, new ComponentTFTowerRoofSlabForwards(this.getFeatureType(), index + 1, this));
        }
        if (this.roofType == null && rand.nextInt(32) != 0) {
            roof = new ComponentTFTowerRoofAttachedSlab(this.getFeatureType(), index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
        if (this.roofType == null) {
            roof = new ComponentTFTowerRoofFence(this.getFeatureType(), index + 1, this);
            this.tryToFitRoof(list, rand, roof);
        }
    }

    @Override
    public void makeABeard(StructureComponent parent, List<StructureComponent> list, Random rand) {
        ComponentTFDarkTowerBeard beard = new ComponentTFDarkTowerBeard(this.getFeatureType(), this.func_74877_c() + 1, this);
        list.add(beard);
        beard.func_74861_a(this, list, rand);
    }

    @Override
    public boolean makeTowerWing(List<StructureComponent> list, Random rand, int index, int x, int y, int z, int wingSize, int wingHeight, Rotation rotation) {
        if (wingHeight < 8) {
            return false;
        }
        EnumFacing direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 5, direction);
        if (dx[1] + wingHeight > 250) {
            return false;
        }
        ComponentTFDarkTowerBridge bridge = new ComponentTFDarkTowerBridge(this.getFeatureType(), index, dx[0], dx[1], dx[2], wingSize, wingHeight, direction);
        StructureComponent intersect = StructureComponent.func_74883_a(list, (StructureBoundingBox)bridge.func_74874_b());
        if (intersect != null && intersect != this) {
            return false;
        }
        intersect = StructureComponent.func_74883_a(list, (StructureBoundingBox)bridge.getWingBB());
        if (intersect == null || intersect == this) {
            list.add(bridge);
            bridge.func_74861_a(this, list, rand);
            this.addOpening(x, y, z, rotation);
            return true;
        }
        return false;
    }

    protected boolean makeTowerBalcony(List<StructureComponent> list, Random rand, int index, int x, int y, int z, Rotation rotation) {
        EnumFacing direction = this.getStructureRelativeRotation(rotation);
        int[] dx = this.offsetTowerCoords(x, y, z, 5, direction);
        ComponentTFDarkTowerBalcony balcony = new ComponentTFDarkTowerBalcony(this.getFeatureType(), index, dx[0], dx[1], dx[2], direction);
        StructureComponent intersect = StructureComponent.func_74883_a(list, (StructureBoundingBox)balcony.func_74874_b());
        if (intersect == null || intersect == this) {
            list.add(balcony);
            balcony.func_74861_a(this, list, rand);
            this.addOpening(x, y, z, rotation, EnumDarkTowerDoor.REAPPEARING);
            return true;
        }
        return false;
    }

    @Override
    public boolean func_74875_a(World world, Random rand, StructureBoundingBox sbb) {
        Random decoRNG = new Random(world.func_72905_C() + (long)(this.field_74887_e.field_78897_a * 321534781) ^ (long)(this.field_74887_e.field_78896_c * 756839));
        this.makeEncasedWalls(world, rand, sbb, 0, 0, 0, this.size - 1, this.height - 1, this.size - 1);
        this.func_74878_a(world, sbb, 1, 1, 1, this.size - 2, this.height - 2, this.size - 2);
        this.nullifySkyLightForBoundingBox(world);
        if (this.size > 9) {
            this.addHalfFloors(world, decoRNG, sbb, 4, this.height - 1);
        } else if (decoRNG.nextInt(3) == 0) {
            this.addSmallTimberBeams(world, decoRNG, sbb, 4, this.height - 1);
        } else {
            this.addHalfFloors(world, decoRNG, sbb, 4, this.height - 1);
        }
        this.makeOpenings(world, sbb);
        if (decoRNG.nextBoolean() && !this.isKeyTower() && this.height > 8) {
            int blobs = 1;
            if (this.size > 9 && decoRNG.nextBoolean()) {
                ++blobs;
            }
            for (int i = 0; i < blobs; ++i) {
                int x = decoRNG.nextInt(this.size);
                int y = decoRNG.nextInt(this.height - 7) + 2;
                int z = decoRNG.nextInt(this.size);
                this.destroyTower(world, decoRNG, x, y, z, 3, sbb);
            }
        }
        return true;
    }

    protected void destroyTower(World world, Random decoRNG, int x, int y, int z, int amount, StructureBoundingBox sbb) {
        int initialRadius = decoRNG.nextInt(amount) + amount;
        this.drawBlob(world, x, y, z, initialRadius, AIR, sbb);
        for (int i = 0; i < 3; ++i) {
            int dx = x + (initialRadius - 1) * (decoRNG.nextBoolean() ? 1 : -1);
            int dy = y + (initialRadius - 1) * (decoRNG.nextBoolean() ? 1 : -1);
            int dz = z + (initialRadius - 1) * (decoRNG.nextBoolean() ? 1 : -1);
            this.netherTransformBlob(world, decoRNG, dx, dy, dz, initialRadius - 1, sbb);
            this.drawBlob(world, dx, dy, dz, initialRadius - 2, AIR, sbb);
        }
    }

    private void netherTransformBlob(World world, Random inRand, int sx, int sy, int sz, int rad, StructureBoundingBox sbb) {
        Random rand = new Random(inRand.nextLong());
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    byte dist = 0;
                    dist = dx >= dy && dx >= dz ? (byte)(dx + (byte)((double)Math.max(dy, dz) * 0.5 + (double)Math.min(dy, dz) * 0.25)) : (dy >= dx && dy >= dz ? (byte)(dy + (byte)((double)Math.max(dx, dz) * 0.5 + (double)Math.min(dx, dz) * 0.25)) : (byte)(dz + (byte)((double)Math.max(dx, dy) * 0.5 + (double)Math.min(dx, dy) * 0.25)));
                    if (dist > rad) continue;
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy + dy, sz + dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy + dy, sz + dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy + dy, sz - dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx - dx, sy + dy, sz + dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx - dx, sy + dy, sz - dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy - dy, sz + dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx + dx, sy - dy, sz - dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx - dx, sy - dy, sz + dz, sbb);
                    this.testAndChangeToNetherrack(world, rand, sx - dx, sy - dy, sz - dz, sbb);
                }
            }
        }
    }

    private void testAndChangeToNetherrack(World world, Random rand, int x, int y, int z, StructureBoundingBox sbb) {
        if (this.func_175807_a(world, x, y, z, sbb).func_177230_c() != Blocks.field_150350_a) {
            this.func_175811_a(world, Blocks.field_150424_aL.func_176223_P(), x, y, z, sbb);
            if (this.func_175807_a(world, x, y + 1, z, sbb).func_177230_c() == Blocks.field_150350_a && rand.nextBoolean()) {
                this.func_175811_a(world, Blocks.field_150480_ab.func_176223_P(), x, y + 1, z, sbb);
            }
        }
    }

    private void drawBlob(World world, int sx, int sy, int sz, int rad, IBlockState state, StructureBoundingBox sbb) {
        for (int dx = 0; dx <= rad; dx = (int)((byte)(dx + 1))) {
            for (int dy = 0; dy <= rad; dy = (int)((byte)(dy + 1))) {
                for (int dz = 0; dz <= rad; dz = (int)((byte)(dz + 1))) {
                    byte dist = 0;
                    dist = dx >= dy && dx >= dz ? (byte)(dx + (byte)((double)Math.max(dy, dz) * 0.5 + (double)Math.min(dy, dz) * 0.25)) : (dy >= dx && dy >= dz ? (byte)(dy + (byte)((double)Math.max(dx, dz) * 0.5 + (double)Math.min(dx, dz) * 0.25)) : (byte)(dz + (byte)((double)Math.max(dx, dy) * 0.5 + (double)Math.min(dx, dy) * 0.25)));
                    if (dist > rad) continue;
                    this.func_175811_a(world, state, sx + dx, sy + dy, sz + dz, sbb);
                    this.func_175811_a(world, state, sx + dx, sy + dy, sz - dz, sbb);
                    this.func_175811_a(world, state, sx - dx, sy + dy, sz + dz, sbb);
                    this.func_175811_a(world, state, sx - dx, sy + dy, sz - dz, sbb);
                    this.func_175811_a(world, state, sx + dx, sy - dy, sz + dz, sbb);
                    this.func_175811_a(world, state, sx + dx, sy - dy, sz - dz, sbb);
                    this.func_175811_a(world, state, sx - dx, sy - dy, sz + dz, sbb);
                    this.func_175811_a(world, state, sx - dx, sy - dy, sz - dz, sbb);
                }
            }
        }
    }

    private void addHalfFloors(World world, Random rand, StructureBoundingBox sbb, int bottom, int top) {
        int spacing = 4;
        Rotation rotation = RotationUtil.ROTATIONS[(this.field_74887_e.field_78895_b + bottom) % 3];
        if (bottom == 0) {
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            rotation = rotation.func_185830_a(Rotation.CLOCKWISE_180);
            if (y >= top - spacing) {
                this.makeFullFloor(world, sbb, rotation, y, spacing);
                if (this.isDeadEnd()) {
                    this.decorateTreasureRoom(world, sbb, rotation, y, 4, this.deco);
                }
            } else {
                this.makeHalfFloor(world, sbb, rotation, y, spacing);
                switch (rand.nextInt(8)) {
                    case 0: {
                        if (this.size < 11) {
                            this.decorateReappearingFloor(world, rand, sbb, rotation, y);
                            break;
                        }
                    }
                    case 1: {
                        this.decorateSpawner(world, rand, sbb, rotation, y);
                        break;
                    }
                    case 2: {
                        this.decorateLounge(world, rand, sbb, rotation, y);
                        break;
                    }
                    case 3: {
                        this.decorateLibrary(world, rand, sbb, rotation, y);
                        break;
                    }
                    case 4: {
                        this.decorateExperimentPulser(world, rand, sbb, rotation, y);
                        break;
                    }
                    case 5: {
                        this.decorateExperimentLamp(world, rand, sbb, rotation, y);
                        break;
                    }
                    case 6: {
                        this.decoratePuzzleChest(world, rand, sbb, rotation, y);
                    }
                }
            }
            this.addStairsDown(world, sbb, rotation, y, this.size - 2, spacing);
            if (this.size <= 9) continue;
            this.addStairsDown(world, sbb, rotation, y, this.size - 3, spacing);
        }
        rotation = rotation.func_185830_a(Rotation.CLOCKWISE_180);
        this.addStairsDown(world, sbb, rotation, this.height - 1, this.size - 2, spacing);
    }

    protected void makeHalfFloor(World world, StructureBoundingBox sbb, Rotation rotation, int y, int spacing) {
        this.fillBlocksRotated(world, sbb, this.size / 2, y, 1, this.size - 2, y, this.size - 2, this.deco.blockState, rotation);
        this.fillBlocksRotated(world, sbb, this.size / 2 - 1, y, 1, this.size / 2 - 1, y, this.size - 2, this.deco.accentState, rotation);
    }

    protected void makeFullFloor(World world, StructureBoundingBox sbb, Rotation rotation, int y, int spacing) {
        this.func_175804_a(world, sbb, 1, y, 1, this.size - 2, y, this.size - 2, this.deco.blockState, Blocks.field_150350_a.func_176223_P(), false);
        this.func_175804_a(world, sbb, this.size / 2, y, 1, this.size / 2, y, this.size - 2, this.deco.accentState, Blocks.field_150350_a.func_176223_P(), true);
    }

    protected void decorateTreasureRoom(World world, StructureBoundingBox sbb, Rotation rotation, int y, int spacing, StructureTFDecorator myDeco) {
        int x = this.size / 2;
        int z = this.size / 2;
        this.makePillarFrame(world, sbb, this.deco, rotation, x - 1, y, z - 1, true);
        this.setBlockStateRotated(world, myDeco.platformState, x, y + 1, z, rotation, sbb);
        this.placeTreasureAtCurrentPosition(world, null, x, y + 2, z, this.isKeyTower() ? TFTreasure.darktower_key : TFTreasure.darktower_cache, sbb);
    }

    private void decorateSpawner(World world, Random rand, StructureBoundingBox sbb, Rotation rotation, int y) {
        int z;
        int x = this.size > 9 ? 4 : 3;
        int n = z = this.size > 9 ? 5 : 4;
        ResourceLocation mobID = this.size > 9 ? (rand.nextBoolean() ? TFEntityNames.TOWER_GOLEM : TFEntityNames.TOWER_BROODLING) : TFEntityNames.TOWER_BROODLING;
        this.makePillarFrame(world, sbb, this.deco, rotation, x, y, z, true);
        this.setSpawnerRotated(world, x + 1, y + 2, z + 1, rotation, mobID, sbb);
    }

    private void decorateLounge(World world, Random rand, StructureBoundingBox sbb, Rotation rotation, int y) {
        int cx = this.size > 9 ? 9 : 7;
        int cz = this.size > 9 ? 4 : 3;
        this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, false), cx, y + 1, cz + 0, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, false), cx, y + 1, cz + 1, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, false), cx, y + 1, cz + 2, rotation, sbb);
        cx = this.size > 9 ? 5 : 3;
        this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, true), cx, y + 1, cz + 0, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getSlabState(Blocks.field_150376_bx.func_176223_P(), BlockPlanks.EnumType.SPRUCE, BlockSlab.EnumBlockHalf.TOP), cx, y + 1, cz + 1, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, true), cx, y + 1, cz + 2, rotation, sbb);
    }

    private void decorateReappearingFloor(World world, Random rand, StructureBoundingBox sbb, Rotation rotation, int y) {
        IBlockState inactiveReappearing = TFBlocks.tower_device.func_176223_P().func_177226_a(BlockTFTowerDevice.VARIANT, (Comparable)((Object)TowerDeviceVariant.REAPPEARING_INACTIVE));
        IBlockState woodenPressurePlate = Blocks.field_150452_aw.func_176223_P();
        this.fillBlocksRotated(world, sbb, 4, y, 3, 7, y, 5, inactiveReappearing, rotation);
        this.fillBlocksRotated(world, sbb, 4, y + 1, 2, 7, y + 1, 2, woodenPressurePlate, rotation);
        this.fillBlocksRotated(world, sbb, 4, y + 1, 6, 7, y + 1, 6, woodenPressurePlate, rotation);
    }

    private void decorateExperimentLamp(World world, Random rand, StructureBoundingBox sbb, Rotation rotation, int y) {
        int cx = this.size > 9 ? 5 : 3;
        int cz = this.size > 9 ? 5 : 4;
        IBlockState redstoneLamp = Blocks.field_150379_bu.func_176223_P();
        this.setBlockStateRotated(world, Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.UP), cx, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, redstoneLamp, cx, y + 2, cz, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, cx, y + 1, cz + 1, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getLeverState(Blocks.field_150442_at.func_176223_P(), BlockLever.EnumOrientation.NORTH, rotation, false), cx, y + 1, cz + 2, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, cx, y + 3, cz - 1, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getLeverState(Blocks.field_150442_at.func_176223_P(), BlockLever.EnumOrientation.SOUTH, rotation, true), cx, y + 3, cz - 2, rotation, sbb);
    }

    protected static IBlockState getLeverState(IBlockState initialState, BlockLever.EnumOrientation direction, Rotation rotation, boolean isPowered) {
        switch (direction) {
            case NORTH: 
            case SOUTH: 
            case EAST: 
            case WEST: {
                break;
            }
            case UP_X: {
                if (rotation != Rotation.CLOCKWISE_90 && rotation != Rotation.COUNTERCLOCKWISE_90) break;
                direction = BlockLever.EnumOrientation.UP_Z;
                break;
            }
            case UP_Z: {
                if (rotation != Rotation.CLOCKWISE_90 && rotation != Rotation.COUNTERCLOCKWISE_90) break;
                direction = BlockLever.EnumOrientation.UP_X;
                break;
            }
            case DOWN_X: {
                if (rotation != Rotation.CLOCKWISE_90 && rotation != Rotation.COUNTERCLOCKWISE_90) break;
                direction = BlockLever.EnumOrientation.DOWN_Z;
                break;
            }
            case DOWN_Z: {
                if (rotation != Rotation.CLOCKWISE_90 && rotation != Rotation.COUNTERCLOCKWISE_90) break;
                direction = BlockLever.EnumOrientation.DOWN_X;
            }
        }
        return initialState.func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)direction).func_177226_a((IProperty)BlockLever.field_176359_b, (Comparable)Boolean.valueOf(isPowered));
    }

    private void decorateExperimentPulser(World world, Random rand, StructureBoundingBox sbb, Rotation rotation, int y) {
        int cx = this.size > 9 ? 6 : 5;
        int cz = this.size > 9 ? 4 : 3;
        IBlockState redstoneWire = Blocks.field_150488_af.func_176223_P();
        IBlockState woodenPressurePlate = Blocks.field_150452_aw.func_176223_P();
        IBlockState stickyPiston = Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.SOUTH);
        IBlockState unpoweredRepeater = Blocks.field_150413_aR.func_176223_P().func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockRedstoneRepeater.field_176410_b, (Comparable)Integer.valueOf(2));
        this.setBlockStateRotated(world, stickyPiston, cx, y + 1, cz + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, cx, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, redstoneWire, cx + 1, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, woodenPressurePlate, cx + 2, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, unpoweredRepeater, cx - 1, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, redstoneWire, cx - 2, y + 1, cz, rotation, sbb);
        this.setBlockStateRotated(world, redstoneWire, cx - 2, y + 1, cz + 1, rotation, sbb);
        this.setBlockStateRotated(world, redstoneWire, cx - 1, y + 1, cz + 1, rotation, sbb);
    }

    private void decorateLibrary(World world, Random rand, StructureBoundingBox sbb, Rotation rotation, int y) {
        int bx = this.size > 9 ? 4 : 3;
        int bz = this.size > 9 ? 3 : 2;
        this.makeSmallBookshelf(world, sbb, rotation, y, bx, bz);
        bx = this.size > 9 ? 9 : 7;
        bz = this.size > 9 ? 3 : 2;
        this.makeSmallBookshelf(world, sbb, rotation, y, bx, bz);
    }

    protected void makeSmallBookshelf(World world, StructureBoundingBox sbb, Rotation rotation, int y, int bx, int bz) {
        this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, false), bx, y + 1, bz + 0, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, true), bx, y + 2, bz + 0, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, false), bx, y + 1, bz + 3, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, true), bx, y + 2, bz + 3, rotation, sbb);
        IBlockState bookshelf = Blocks.field_150342_X.func_176223_P();
        this.setBlockStateRotated(world, bookshelf, bx, y + 1, bz + 1, rotation, sbb);
        this.setBlockStateRotated(world, bookshelf, bx, y + 2, bz + 1, rotation, sbb);
        this.setBlockStateRotated(world, bookshelf, bx, y + 1, bz + 2, rotation, sbb);
        this.setBlockStateRotated(world, bookshelf, bx, y + 2, bz + 2, rotation, sbb);
    }

    private void decoratePuzzleChest(World world, Random rand, StructureBoundingBox sbb, Rotation rotation, int y) {
        int x = this.size > 9 ? 4 : 3;
        int z = this.size > 9 ? 5 : 4;
        this.makePillarFrame(world, sbb, this.deco, rotation, x, y, z, true);
        this.setBlockStateRotated(world, this.deco.platformState, x + 1, y + 1, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 2, y + 1, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 0, y + 1, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 1, y + 1, z + 2, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 1, y + 1, z + 0, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 2, y + 3, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 0, y + 3, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 1, y + 3, z + 2, rotation, sbb);
        this.setBlockStateRotated(world, AIR, x + 1, y + 3, z + 0, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.blockState, x + 1, y + 3, z + 1, rotation, sbb);
        this.setBlockStateRotated(world, Blocks.field_150320_F.func_176223_P().func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.NORTH), x + 1, y + 3, z - 1, rotation, sbb);
        this.setBlockStateRotated(world, this.deco.accentState, x + 1, y + 3, z - 2, rotation, sbb);
        this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getLeverState(Blocks.field_150442_at.func_176223_P(), BlockLever.EnumOrientation.WEST, rotation, false), x + 2, y + 3, z - 2, rotation, sbb);
        this.placeTreasureRotated(world, x + 1, y + 2, z + 1, rotation, TFTreasure.darktower_cache, sbb);
    }

    protected void makePillarFrame(World world, StructureBoundingBox sbb, StructureTFDecorator myDeco, Rotation rotation, int x, int y, int z, boolean fenced) {
        this.makePillarFrame(world, sbb, myDeco, rotation, x, y, z, 3, 3, 3, fenced);
    }

    protected void makePillarFrame(World world, StructureBoundingBox sbb, StructureTFDecorator myDeco, Rotation rotation, int x, int y, int z, int width, int height, int length, boolean fenced) {
        for (int dx = 0; dx < width; ++dx) {
            for (int dz = 0; dz < length; ++dz) {
                if (!(dx % 3 != 0 && dx != width - 1 || dz % 3 != 0 && dz != length - 1)) {
                    for (int py = 1; py <= height; ++py) {
                        this.setBlockStateRotated(world, myDeco.pillarState, x + dx, y + py, z + dz, rotation, sbb);
                    }
                    continue;
                }
                if (dx == 0) {
                    IBlockState southStairs = ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, false);
                    this.setBlockStateRotated(world, southStairs, x + dx, y + 1, z + dz, rotation, sbb);
                    this.setBlockStateRotated(world, southStairs.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), x + dx, y + height, z + dz, rotation, sbb);
                } else if (dx == width - 1) {
                    IBlockState northStairs = ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.EAST, rotation, false);
                    this.setBlockStateRotated(world, northStairs, x + dx, y + 1, z + dz, rotation, sbb);
                    this.setBlockStateRotated(world, northStairs.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), x + dx, y + height, z + dz, rotation, sbb);
                } else if (dz == 0) {
                    IBlockState westStairs = ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.NORTH, rotation, false);
                    this.setBlockStateRotated(world, westStairs, x + dx, y + 1, z + dz, rotation, sbb);
                    this.setBlockStateRotated(world, westStairs.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), x + dx, y + height, z + dz, rotation, sbb);
                } else if (dz == length - 1) {
                    IBlockState eastStairs = ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.SOUTH, rotation, false);
                    this.setBlockStateRotated(world, eastStairs, x + dx, y + 1, z + dz, rotation, sbb);
                    this.setBlockStateRotated(world, eastStairs.func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP), x + dx, y + height, z + dz, rotation, sbb);
                }
                if (!fenced || dx != 0 && dx != width - 1 && dz != 0 && dz != length - 1) continue;
                for (int fy = 2; fy <= height - 1; ++fy) {
                    this.setBlockStateRotated(world, myDeco.fenceState, x + dx, y + fy, z + dz, rotation, sbb);
                }
            }
        }
    }

    protected void addStairsDown(World world, StructureBoundingBox sbb, Rotation rotation, int y, int sz, int spacing) {
        for (int i = 0; i < spacing; ++i) {
            int sx = this.size - 3 - i;
            this.setBlockStateRotated(world, ComponentTFDarkTowerWing.getStairState(this.deco.stairState, EnumFacing.WEST, rotation, false), sx, y - i, sz, rotation, sbb);
            this.setBlockStateRotated(world, this.deco.accentState, sx, y - 1 - i, sz, rotation, sbb);
            this.setBlockStateRotated(world, AIR, sx, y + 1 - i, sz, rotation, sbb);
            this.setBlockStateRotated(world, AIR, sx, y + 2 - i, sz, rotation, sbb);
            this.setBlockStateRotated(world, AIR, sx - 1, y + 2 - i, sz, rotation, sbb);
            this.setBlockStateRotated(world, AIR, sx, y + 3 - i, sz, rotation, sbb);
            this.setBlockStateRotated(world, AIR, sx - 1, y + 3 - i, sz, rotation, sbb);
        }
    }

    protected void addSmallTimberBeams(World world, Random rand, StructureBoundingBox sbb, int bottom, int top) {
        int spacing = 4;
        Rotation rotation = Rotation.NONE;
        if (bottom == 0) {
            bottom += spacing;
        }
        for (int y = bottom; y < top; y += spacing) {
            rotation = rotation.func_185830_a(Rotation.CLOCKWISE_90);
            if (y >= top - spacing && this.isDeadEnd()) {
                this.makeTimberFloor(world, rand, sbb, rotation, y, spacing);
                StructureDecoratorDarkTower logDeco = new StructureDecoratorDarkTower();
                logDeco.pillarState = TFBlocks.twilight_log.func_176223_P().func_177226_a(BlockTFLog.VARIANT, (Comparable)((Object)WoodVariant.DARK));
                logDeco.platformState = TFBlocks.twilight_log.func_176223_P().func_177226_a(BlockTFLog.VARIANT, (Comparable)((Object)WoodVariant.DARK));
                this.decorateTreasureRoom(world, sbb, rotation, y, 4, logDeco);
                continue;
            }
            this.makeSmallTimberBeams(world, rand, sbb, rotation, y, y == bottom && bottom != spacing, y >= top - spacing);
        }
    }

    protected void makeTimberFloor(World world, Random rand, StructureBoundingBox sbb, Rotation rotation, int y, int spacing) {
        IBlockState beamID = TFBlocks.twilight_log.func_176223_P().func_177226_a(BlockTFLog.VARIANT, (Comparable)((Object)WoodVariant.DARK));
        IBlockState beamStateNS = beamID.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
        IBlockState beamStateUD = beamID.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
        IBlockState beamStateEW = beamID.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
        for (int z = 1; z < this.size - 1; ++z) {
            for (int x = 1; x < this.size - 1; ++x) {
                if (x < z) {
                    this.setBlockStateRotated(world, beamStateNS, x, y, z, rotation, sbb);
                    continue;
                }
                this.setBlockStateRotated(world, beamStateEW, x, y, z, rotation, sbb);
            }
        }
        for (int by = 1; by < 4; ++by) {
            IBlockState ladder = Blocks.field_150468_ap.func_176223_P();
            this.setBlockStateRotated(world, beamStateUD, 2, y - by, 2, rotation, sbb);
            this.setBlockStateRotated(world, ladder.func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST), 3, y - by, 2, rotation, sbb);
            this.setBlockStateRotated(world, beamStateUD, 6, y - by, 6, rotation, sbb);
            this.setBlockStateRotated(world, ladder.func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.EAST), 5, y - by, 6, rotation, sbb);
        }
        this.setBlockStateRotated(world, AIR, 3, y, 2, rotation, sbb);
        this.setBlockStateRotated(world, AIR, 5, y, 6, rotation, sbb);
    }

    protected void makeSmallTimberBeams(World world, Random rand, StructureBoundingBox sbb, Rotation rotation, int y, boolean bottom, boolean top) {
        int z;
        IBlockState beamID = TFBlocks.twilight_log.func_176223_P().func_177226_a(BlockTFLog.VARIANT, (Comparable)((Object)WoodVariant.DARK));
        IBlockState beamStateNS = beamID.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.X);
        IBlockState beamStateUD = beamID.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Y);
        IBlockState beamStateEW = beamID.func_177226_a((IProperty)BlockLog.field_176299_a, (Comparable)BlockLog.EnumAxis.Z);
        for (z = 1; z < this.size - 1; ++z) {
            this.setBlockStateRotated(world, beamStateEW, 2, y, z, rotation, sbb);
            this.setBlockStateRotated(world, beamStateEW, 6, y, z, rotation, sbb);
        }
        z = this.pickBetweenExcluding(3, this.size - 3, rand, 2, 2, 6);
        for (int x = 3; x < 6; ++x) {
            this.setBlockStateRotated(world, beamStateNS, x, y, z, rotation, sbb);
        }
        int x1 = 2;
        int z1 = rand.nextBoolean() ? 2 : 6;
        int x3 = 6;
        int z3 = rand.nextBoolean() ? 2 : 6;
        for (int by = 1; by < 4; ++by) {
            IBlockState ladder = Blocks.field_150468_ap.func_176223_P();
            if (!bottom || this.checkPost(world, x1, y - 4, z1, rotation, sbb)) {
                this.setBlockStateRotated(world, beamStateUD, x1, y - by, z1, rotation, sbb);
                this.setBlockStateRotated(world, ladder.func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.WEST), x1 + 1, y - by, z1, rotation, sbb);
            }
            if (bottom && !this.checkPost(world, x3, y - 4, z3, rotation, sbb)) continue;
            this.setBlockStateRotated(world, beamStateUD, x3, y - by, z3, rotation, sbb);
            this.setBlockStateRotated(world, ladder.func_177226_a((IProperty)BlockLadder.field_176382_a, (Comparable)EnumFacing.EAST), x3 - 1, y - by, z3, rotation, sbb);
        }
    }

    protected int pickBetweenExcluding(int low, int high, Random rand, int k, int l, int m) {
        int result;
        while ((result = rand.nextInt(high - low) + low) == k || result == l || result == m) {
        }
        return result;
    }

    protected int pickFrom(Random rand, int i, int j, int k) {
        switch (rand.nextInt(3)) {
            default: {
                return i;
            }
            case 1: {
                return j;
            }
            case 2: 
        }
        return k;
    }

    protected boolean checkPost(World world, int x, int y, int z, Rotation rotation, StructureBoundingBox sbb) {
        int worldZ;
        int worldY;
        int worldX = this.getXWithOffsetRotated(x, z, rotation);
        BlockPos vec = new BlockPos(worldX, worldY = this.func_74862_a(y), worldZ = this.getZWithOffsetRotated(x, z, rotation));
        if (!sbb.func_175898_b((Vec3i)vec)) {
            return false;
        }
        IBlockState blockState = world.func_180495_p(vec);
        return blockState.func_177230_c() != Blocks.field_150350_a && blockState != this.deco.accentState;
    }

    protected void makeEncasedWalls(World world, Random rand, StructureBoundingBox sbb, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (x != minX && x != maxX && y != minY && y != maxY && z != minZ && z != maxZ) continue;
                    if (!((x != minY && x != maxX || y != minY && y != maxY && z != minZ && z != maxZ) && (y != minY && y != maxY || x != minY && x != maxX && z != minZ && z != maxZ) && (z != minZ && z != maxZ || x != minY && x != maxX && y != minY && y != maxY))) {
                        this.func_175811_a(world, this.deco.accentState, x, y, z, sbb);
                        continue;
                    }
                    StructureComponent.BlockSelector blocker = this.deco.randomBlocks;
                    blocker.func_75062_a(rand, x, y, z, true);
                    this.func_175811_a(world, blocker.func_180780_a(), x, y, z, sbb);
                }
            }
        }
        this.func_175811_a(world, this.deco.accentState, minX + 1, minY + 1, minZ, sbb);
        this.func_175811_a(world, this.deco.accentState, minX + 1, minY + 1, maxZ, sbb);
        this.func_175811_a(world, this.deco.accentState, maxX - 1, minY + 1, minZ, sbb);
        this.func_175811_a(world, this.deco.accentState, maxX - 1, minY + 1, maxZ, sbb);
        this.func_175811_a(world, this.deco.accentState, minX + 1, maxY - 1, minZ, sbb);
        this.func_175811_a(world, this.deco.accentState, minX + 1, maxY - 1, maxZ, sbb);
        this.func_175811_a(world, this.deco.accentState, maxX - 1, maxY - 1, minZ, sbb);
        this.func_175811_a(world, this.deco.accentState, maxX - 1, maxY - 1, maxZ, sbb);
        this.func_175811_a(world, this.deco.accentState, minX, minY + 1, minZ + 1, sbb);
        this.func_175811_a(world, this.deco.accentState, minX, minY + 1, maxZ - 1, sbb);
        this.func_175811_a(world, this.deco.accentState, maxX, minY + 1, minZ + 1, sbb);
        this.func_175811_a(world, this.deco.accentState, maxX, minY + 1, maxZ - 1, sbb);
        this.func_175811_a(world, this.deco.accentState, minX, maxY - 1, minZ + 1, sbb);
        this.func_175811_a(world, this.deco.accentState, minX, maxY - 1, maxZ - 1, sbb);
        this.func_175811_a(world, this.deco.accentState, maxX, maxY - 1, minZ + 1, sbb);
        this.func_175811_a(world, this.deco.accentState, maxX, maxY - 1, maxZ - 1, sbb);
        this.func_175811_a(world, this.deco.accentState, minX + 1, minY, minZ + 1, sbb);
        this.func_175811_a(world, this.deco.accentState, minX + 1, minY, maxZ - 1, sbb);
        this.func_175811_a(world, this.deco.accentState, maxX - 1, minY, minZ + 1, sbb);
        this.func_175811_a(world, this.deco.accentState, maxX - 1, minY, maxZ - 1, sbb);
        this.func_175811_a(world, this.deco.accentState, minX + 1, maxY, minZ + 1, sbb);
        this.func_175811_a(world, this.deco.accentState, minX + 1, maxY, maxZ - 1, sbb);
        this.func_175811_a(world, this.deco.accentState, maxX - 1, maxY, minZ + 1, sbb);
        this.func_175811_a(world, this.deco.accentState, maxX - 1, maxY, maxZ - 1, sbb);
    }

    @Override
    public int[] getValidOpening(Random rand, Rotation direction) {
        int verticalOffset;
        int n = verticalOffset = this.size == 19 ? 5 : 4;
        if (direction == Rotation.NONE || direction == Rotation.CLOCKWISE_180) {
            int rx = direction == Rotation.NONE ? this.size - 1 : 0;
            int rz = this.size / 2;
            int ry = this.height - verticalOffset;
            return new int[]{rx, ry, rz};
        }
        if (direction == Rotation.CLOCKWISE_90 || direction == Rotation.COUNTERCLOCKWISE_90) {
            int rx = this.size / 2;
            int rz = direction == Rotation.CLOCKWISE_90 ? this.size - 1 : 0;
            int ry = this.height - verticalOffset;
            return new int[]{rx, ry, rz};
        }
        return new int[]{0, 0, 0};
    }

    @Override
    public void addOpening(int dx, int dy, int dz, Rotation direction) {
        this.addOpening(dx, dy, dz, direction, EnumDarkTowerDoor.VANISHING);
    }

    protected void addOpening(int dx, int dy, int dz, Rotation direction, EnumDarkTowerDoor type) {
        super.addOpening(dx, dy, dz, direction);
        this.openingTypes.add(this.openings.indexOf(new BlockPos(dx, dy, dz)), type);
    }

    @Override
    protected void makeOpenings(World world, StructureBoundingBox sbb) {
        block4: for (int i = 0; i < this.openings.size(); ++i) {
            BlockPos doorCoords = (BlockPos)this.openings.get(i);
            EnumDarkTowerDoor doorType = this.openingTypes.size() > i ? this.openingTypes.get(i) : EnumDarkTowerDoor.VANISHING;
            switch (doorType) {
                default: {
                    this.makeDoorOpening(world, doorCoords.func_177958_n(), doorCoords.func_177956_o(), doorCoords.func_177952_p(), sbb);
                    continue block4;
                }
                case REAPPEARING: {
                    this.makeReappearingDoorOpening(world, doorCoords.func_177958_n(), doorCoords.func_177956_o(), doorCoords.func_177952_p(), sbb);
                    continue block4;
                }
                case LOCKED: {
                    this.makeLockedDoorOpening(world, doorCoords.func_177958_n(), doorCoords.func_177956_o(), doorCoords.func_177952_p(), sbb);
                }
            }
        }
    }

    @Override
    protected void makeDoorOpening(World world, int dx, int dy, int dz, StructureBoundingBox sbb) {
        this.nullifySkyLightAtCurrentPosition(world, dx - 3, dy - 1, dz - 3, dx + 3, dy + 3, dz + 3);
        IBlockState inactiveVanish = TFBlocks.tower_device.func_176223_P().func_177226_a(BlockTFTowerDevice.VARIANT, (Comparable)((Object)TowerDeviceVariant.VANISH_INACTIVE));
        if (dx == 0 || dx == this.size - 1) {
            this.func_175804_a(world, sbb, dx, dy - 1, dz - 2, dx, dy + 3, dz + 2, this.deco.accentState, AIR, false);
            this.func_175804_a(world, sbb, dx, dy, dz - 1, dx, dy + 2, dz + 1, inactiveVanish, AIR, false);
        }
        if (dz == 0 || dz == this.size - 1) {
            this.func_175804_a(world, sbb, dx - 2, dy - 1, dz, dx + 2, dy + 3, dz, this.deco.accentState, AIR, false);
            this.func_175804_a(world, sbb, dx - 1, dy, dz, dx + 1, dy + 2, dz, inactiveVanish, AIR, false);
        }
    }

    protected void makeReappearingDoorOpening(World world, int dx, int dy, int dz, StructureBoundingBox sbb) {
        this.nullifySkyLightAtCurrentPosition(world, dx - 3, dy - 1, dz - 3, dx + 3, dy + 3, dz + 3);
        IBlockState inactiveReappearing = TFBlocks.tower_device.func_176223_P().func_177226_a(BlockTFTowerDevice.VARIANT, (Comparable)((Object)TowerDeviceVariant.REAPPEARING_INACTIVE));
        if (dx == 0 || dx == this.size - 1) {
            this.func_175804_a(world, sbb, dx, dy - 1, dz - 2, dx, dy + 3, dz + 2, this.deco.accentState, AIR, false);
            this.func_175804_a(world, sbb, dx, dy, dz - 1, dx, dy + 2, dz + 1, inactiveReappearing, AIR, false);
        }
        if (dz == 0 || dz == this.size - 1) {
            this.func_175804_a(world, sbb, dx - 2, dy - 1, dz, dx + 2, dy + 3, dz, this.deco.accentState, AIR, false);
            this.func_175804_a(world, sbb, dx - 1, dy, dz, dx + 1, dy + 2, dz, inactiveReappearing, AIR, false);
        }
    }

    protected void makeLockedDoorOpening(World world, int dx, int dy, int dz, StructureBoundingBox sbb) {
        this.nullifySkyLightAtCurrentPosition(world, dx - 3, dy - 1, dz - 3, dx + 3, dy + 3, dz + 3);
        IBlockState lockedVanish = TFBlocks.tower_device.func_176223_P().func_177226_a(BlockTFTowerDevice.VARIANT, (Comparable)((Object)TowerDeviceVariant.VANISH_LOCKED));
        IBlockState inactiveVanish = TFBlocks.tower_device.func_176223_P().func_177226_a(BlockTFTowerDevice.VARIANT, (Comparable)((Object)TowerDeviceVariant.VANISH_INACTIVE));
        if (dx == 0 || dx == this.size - 1) {
            this.func_175804_a(world, sbb, dx, dy - 1, dz - 2, dx, dy + 3, dz + 2, this.deco.accentState, AIR, false);
            this.func_175804_a(world, sbb, dx, dy, dz - 1, dx, dy + 2, dz + 1, inactiveVanish, AIR, false);
            this.func_175811_a(world, lockedVanish, dx, dy + 0, dz + 1, sbb);
            this.func_175811_a(world, lockedVanish, dx, dy + 0, dz - 1, sbb);
            this.func_175811_a(world, lockedVanish, dx, dy + 2, dz + 1, sbb);
            this.func_175811_a(world, lockedVanish, dx, dy + 2, dz - 1, sbb);
        }
        if (dz == 0 || dz == this.size - 1) {
            this.func_175804_a(world, sbb, dx - 2, dy - 1, dz, dx + 2, dy + 3, dz, this.deco.accentState, AIR, false);
            this.func_175804_a(world, sbb, dx - 1, dy, dz, dx + 1, dy + 2, dz, inactiveVanish, AIR, false);
            this.func_175811_a(world, lockedVanish, dx + 1, dy + 0, dz, sbb);
            this.func_175811_a(world, lockedVanish, dx - 1, dy + 0, dz, sbb);
            this.func_175811_a(world, lockedVanish, dx + 1, dy + 2, dz, sbb);
            this.func_175811_a(world, lockedVanish, dx - 1, dy + 2, dz, sbb);
        }
    }

    @Override
    public boolean isDeadEnd() {
        int nonBalconies = 0;
        for (EnumDarkTowerDoor type : this.openingTypes) {
            if (type == EnumDarkTowerDoor.REAPPEARING) continue;
            ++nonBalconies;
        }
        return nonBalconies <= 1;
    }

    public boolean isKeyTower() {
        return this.keyTower;
    }

    public void setKeyTower(boolean keyTower) {
        this.keyTower = keyTower;
    }
}

