/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world.buildings;

import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.blocks.BlockDecorative;
import matteroverdrive.world.MOImageGen;
import matteroverdrive.world.buildings.MOWorldGenBuilding;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.NoiseGeneratorSimplex;

public class MOWorldGenUnderwaterBase
extends MOWorldGenBuilding {
    private static final int MIN_DISTANCE_APART = 2048;
    final NoiseGeneratorSimplex noise;

    public MOWorldGenUnderwaterBase(String name) {
        super(name, new ResourceLocation("matteroverdrive:textures/world/underwater_base.png"), 43, 43);
        this.validSpawnBlocks = new Block[]{Blocks.field_150355_j};
        this.setyOffset(-24);
        this.noise = new NoiseGeneratorSimplex(new Random());
        for (BlockDecorative blockDecorative : BlockDecorative.decorativeBlocks) {
            this.addMapping(blockDecorative.getBlockColor(0), blockDecorative);
        }
        this.addMapping(14456732, new Block[]{Blocks.field_150329_H});
        this.addMapping(7852470, new Block[]{Blocks.field_150328_O});
        this.addMapping(794190, Blocks.field_150458_ak);
        this.addMapping(10988645, MatterOverdrive.BLOCKS.tritaniumCrateColored[EnumDyeColor.ORANGE.func_176765_a()]);
        this.addMapping(14067476, new Block[]{Blocks.field_150399_cn});
        this.addMapping(2906857, MatterOverdrive.BLOCKS.weapon_station);
        this.addMapping(707980, MatterOverdrive.BLOCKS.androidStation);
        this.addMapping(7346425, MatterOverdrive.BLOCKS.tritaniumCrateColored[EnumDyeColor.LIGHT_BLUE.func_176765_a()]);
        this.addMapping(4609996, MatterOverdrive.BLOCKS.tritaniumCrateColored[EnumDyeColor.LIME.func_176765_a()]);
        this.addMapping(2040594, MatterOverdrive.BLOCKS.tritaniumCrateColored[EnumDyeColor.WHITE.func_176765_a()]);
        this.addMapping(13842205, MatterOverdrive.BLOCKS.machine_hull);
        this.addMapping(3555577, Blocks.field_150430_aB);
        this.addMapping(15726397, MatterOverdrive.BLOCKS.network_switch);
        this.addMapping(5923720, MatterOverdrive.BLOCKS.boundingBox);
        this.addMapping(12523945, new Block[]{Blocks.field_150349_c});
        this.addMapping(12607070, Blocks.field_150457_bL);
        this.addMapping(5082579, MatterOverdrive.BLOCKS.pattern_monitor);
        this.addMapping(14392378, MatterOverdrive.BLOCKS.holoSign);
        this.addMapping(6862476, MatterOverdrive.BLOCKS.matter_analyzer);
        this.addMapping(2928839, MatterOverdrive.BLOCKS.starMap);
        this.addMapping(1781751, MatterOverdrive.BLOCKS.network_pipe);
        this.addMapping(387755, MatterOverdrive.BLOCKS.tritaniumCrate);
        this.addMapping(1114174, MatterOverdrive.BLOCKS.chargingStation);
        this.addMapping(11738755, Blocks.field_150459_bM);
        this.addMapping(13078135, MatterOverdrive.BLOCKS.replicator);
        this.addMapping(3377730, Blocks.field_150469_bN);
        this.addMapping(12446351, Blocks.field_150468_ap);
        this.addMapping(5051124, MatterOverdrive.BLOCKS.pattern_storage);
        this.addMapping(16241163, Blocks.field_150345_g);
        this.addMapping(8735544, new Block[]{Blocks.field_150454_av});
        this.addMapping(0xFF00FF, Blocks.field_150350_a);
    }

    @Override
    public int getMetaFromColor(int color, Random random) {
        return 255 - this.getAlphaFromColor(color);
    }

    @Override
    public MOImageGen.ImageGenWorker getNewWorkerInstance() {
        return new MOWorldGenBuilding.WorldGenBuildingWorker();
    }

    protected void onGeneration(Random random, World world, BlockPos pos, MOWorldGenBuilding.WorldGenBuildingWorker worker) {
    }

    @Override
    public boolean isLocationValid(World world, BlockPos pos) {
        return this.isPointDeepEnough(world, pos) && this.isPointDeepEnough(world, pos.func_177982_a(this.layerWidth, 0, 0)) && this.isPointDeepEnough(world, pos.func_177982_a(this.layerWidth, 0, this.layerHeight)) && this.isPointDeepEnough(world, pos.func_177982_a(0, 0, this.layerHeight));
    }

    protected boolean isPointDeepEnough(World world, BlockPos pos) {
        int blocksInWater = 0;
        while (pos.func_177956_o() > 0) {
            if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150355_j || world.func_180495_p(pos).func_177230_c() == Blocks.field_150358_i) {
                ++blocksInWater;
            } else {
                return blocksInWater > 26;
            }
            pos = pos.func_177982_a(0, -1, 0);
        }
        return false;
    }

    @Override
    public boolean shouldGenerate(Random random, World world, BlockPos pos) {
        return world.func_180494_b(pos).equals(Biome.field_185377_q.func_82594_a((Object)new ResourceLocation("minecraft", "deep_ocean"))) && this.isFarEnoughFromOthers(world, pos.func_177958_n(), pos.func_177952_p(), 2048);
    }

    @Override
    public void onGenerationWorkerCreated(MOWorldGenBuilding.WorldGenBuildingWorker worker) {
        super.onGenerationWorkerCreated(worker);
        int offset = 0;
        for (int yo = worker.getPos().func_177956_o(); yo > 0 && !worker.getWorld().isSideSolid(new BlockPos(worker.getPos().func_177958_n() + this.layerWidth / 2, yo, worker.getPos().func_177952_p() + this.layerHeight / 2), EnumFacing.UP); --yo) {
            --offset;
        }
        this.setyOffset(offset);
    }

    @Override
    public void onBlockPlace(World world, IBlockState block, BlockPos pos, Random random, int color, MOImageGen.ImageGenWorker worker) {
    }
}

