/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world.buildings;

import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.entity.monster.EntityMeleeRougeAndroidMob;
import matteroverdrive.entity.monster.EntityRangedRogueAndroidMob;
import matteroverdrive.world.MOImageGen;
import matteroverdrive.world.buildings.MOWorldGenBuilding;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MOAndroidHouseBuilding
extends MOWorldGenBuilding {
    public MOAndroidHouseBuilding(String name) {
        super(name, new ResourceLocation("matteroverdrive:textures/world/android_house.png"), 21, 21);
        this.setyOffset(-2);
        this.addMapping(65532, MatterOverdrive.BLOCKS.decorative_beams, MatterOverdrive.BLOCKS.decorative_carbon_fiber_plate, MatterOverdrive.BLOCKS.decorative_white_plate);
        this.addMapping(6435328, Blocks.field_150346_d);
        this.addMapping(16753152, MatterOverdrive.BLOCKS.decorative_floor_tiles);
        this.addMapping(0xFFF600, MatterOverdrive.BLOCKS.decorative_holo_matrix);
        this.addMapping(8436054, new Block[]{Blocks.field_150349_c});
        this.addMapping(5479107, MatterOverdrive.BLOCKS.decorative_tritanium_plate);
        this.addMapping(11651285, MatterOverdrive.BLOCKS.decorative_floor_noise, MatterOverdrive.BLOCKS.decorative_floor_tiles_green, MatterOverdrive.BLOCKS.decorative_floor_tile_white);
        this.addMapping(6251881, MatterOverdrive.BLOCKS.decorative_vent_dark);
        this.addMapping(0xF1F1F1, Blocks.field_150350_a);
        this.addMapping(14942463, MatterOverdrive.BLOCKS.starMap);
        this.addMapping(1593517, MatterOverdrive.BLOCKS.decorative_clean);
        this.addMapping(9786307, MatterOverdrive.BLOCKS.industrialGlass);
        this.addMapping(3528416, MatterOverdrive.BLOCKS.replicator);
        this.addMapping(3530897, MatterOverdrive.BLOCKS.network_switch);
        this.addMapping(13161533, MatterOverdrive.BLOCKS.tritaniumCrate);
        this.addMapping(2769009, MatterOverdrive.BLOCKS.androidStation, MatterOverdrive.BLOCKS.weapon_station);
        this.addMapping(10567263, MatterOverdrive.BLOCKS.network_pipe);
        this.addMapping(10578494, MatterOverdrive.BLOCKS.chargingStation);
        this.addMapping(4284787, MatterOverdrive.BLOCKS.decorative_tritanium_plate_stripe);
        this.addMapping(1603350, MatterOverdrive.BLOCKS.pattern_monitor);
        this.addMapping(11303966, MatterOverdrive.BLOCKS.decorative_vent_bright);
        this.addMapping(32511, MatterOverdrive.BLOCKS.decorative_stripes);
    }

    protected void onGeneration(Random random, World world, BlockPos pos, MOWorldGenBuilding.WorldGenBuildingWorker worker) {
        for (int i = 0; i < random.nextInt(3) + 3; ++i) {
            this.spawnAndroid(world, random, pos.func_177982_a(7, i, 10));
        }
        this.spawnLegendary(world, random, pos.func_177982_a(12, 4, 10));
    }

    @Override
    public boolean shouldGenerate(Random random, World world, BlockPos pos) {
        return world.field_73011_w.getDimension() == 0;
    }

    @Override
    public void onBlockPlace(World world, IBlockState block, BlockPos pos, Random random, int color, MOImageGen.ImageGenWorker worker) {
    }

    public void spawnAndroid(World world, Random random, BlockPos pos) {
        if (random.nextInt(100) < 60) {
            EntityRangedRogueAndroidMob androidMob = new EntityRangedRogueAndroidMob(world);
            androidMob.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            world.func_72838_d((Entity)androidMob);
            androidMob.func_180482_a(world.func_175649_E(pos), null);
            androidMob.func_110163_bv();
        } else {
            EntityMeleeRougeAndroidMob androidMob = new EntityMeleeRougeAndroidMob(world);
            androidMob.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
            world.func_72838_d((Entity)androidMob);
            androidMob.func_180482_a(world.func_175649_E(pos), null);
            androidMob.func_110163_bv();
        }
    }

    public void spawnLegendary(World world, Random random, BlockPos pos) {
        EntityRangedRogueAndroidMob legendaryMob = new EntityRangedRogueAndroidMob(world, 3, true);
        legendaryMob.func_70107_b((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
        world.func_72838_d((Entity)legendaryMob);
        legendaryMob.func_180482_a(world.func_175649_E(pos), null);
        legendaryMob.func_110163_bv();
    }

    @Override
    public int getMetaFromColor(int color, Random random) {
        int alpha = 255 - this.getAlphaFromColor(color);
        return (int)((double)alpha / 255.0 * 10.0);
    }

    @Override
    public MOWorldGenBuilding.WorldGenBuildingWorker getNewWorkerInstance() {
        return new MOWorldGenBuilding.WorldGenBuildingWorker();
    }
}

