/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.world;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.data.world.GenPositionWorldData;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.Platform;
import matteroverdrive.world.MOImageGen;
import matteroverdrive.world.WorldGenGravitationalAnomaly;
import matteroverdrive.world.buildings.MOAndroidHouseBuilding;
import matteroverdrive.world.buildings.MOSandPit;
import matteroverdrive.world.buildings.MOWorldGenBuilding;
import matteroverdrive.world.buildings.MOWorldGenCargoShip;
import matteroverdrive.world.buildings.MOWorldGenCrashedSpaceShip;
import matteroverdrive.world.buildings.MOWorldGenUnderwaterBase;
import matteroverdrive.world.buildings.WeightedRandomMOWorldGenBuilding;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.feature.WorldGenMinable;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.IWorldGenerator;

public class MOWorldGen
implements IWorldGenerator,
IConfigSubscriber {
    private static final int TRITANIUM_VEINS_PER_CHUNK = 10;
    private static final int TRITANIUM_VEIN_SIZE = 6;
    private static final int DILITHIUM_VEINS_PER_CHUNK = 6;
    private static final int DILITHIUM_VEIN_SIZE = 5;
    private static float BUILDING_SPAWN_CHANCE = 1.0E7f;
    public final List<WeightedRandomMOWorldGenBuilding> buildings;
    private final Random oreRandom = new Random();
    private final Random anomaliesRandom = new Random();
    private final Random buildingsRandom = new Random();
    HashSet<Integer> oreDimentionsBlacklist;
    boolean generateTritanium;
    boolean generateDilithium;
    boolean generateAnomalies;
    boolean generateBuildings = true;
    private WorldGenMinable dilithiumGen;
    private WorldGenMinable tritaniumGen;
    private WorldGenGravitationalAnomaly anomalyGen;
    private Queue<MOImageGen.ImageGenWorker> worldGenBuildingQueue;

    public MOWorldGen() {
        this.buildings = new ArrayList<WeightedRandomMOWorldGenBuilding>();
        this.worldGenBuildingQueue = new ArrayDeque<MOImageGen.ImageGenWorker>();
        this.oreDimentionsBlacklist = new HashSet();
    }

    public static GenPositionWorldData getWorldPositionData(World world) {
        GenPositionWorldData data = (GenPositionWorldData)world.func_72943_a(GenPositionWorldData.class, "MatterOverdriveWorldGenPositions");
        if (data == null) {
            data = new GenPositionWorldData("MatterOverdriveWorldGenPositions");
            world.func_72823_a("MatterOverdriveWorldGenPositions", (WorldSavedData)data);
        }
        return data;
    }

    public void init(ConfigurationHandler configurationHandler) {
        this.tritaniumGen = new WorldGenMinable(MatterOverdrive.BLOCKS.tritaniumOre.func_176223_P(), 6);
        this.dilithiumGen = new WorldGenMinable(MatterOverdrive.BLOCKS.dilithium_ore.func_176223_P(), 5);
        this.buildings.add(new WeightedRandomMOWorldGenBuilding(new MOAndroidHouseBuilding("android_house"), 40));
        this.buildings.add(new WeightedRandomMOWorldGenBuilding(new MOSandPit("sand_pit_house", 3), 100));
        this.buildings.add(new WeightedRandomMOWorldGenBuilding(new MOWorldGenCrashedSpaceShip("crashed_ship"), 75));
        this.buildings.add(new WeightedRandomMOWorldGenBuilding(new MOWorldGenUnderwaterBase("underwater_base"), 30));
        this.buildings.add(new WeightedRandomMOWorldGenBuilding(new MOWorldGenCargoShip("cargo_ship"), 5));
        this.anomalyGen = new WorldGenGravitationalAnomaly("gravitational_anomaly", 0.05f, 2048, 10240);
        configurationHandler.subscribe(this.anomalyGen);
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        long worldSeed = world.func_72905_C();
        Random moRandom = new Random(worldSeed);
        long xSeed = moRandom.nextLong() >> 3;
        long zSeed = moRandom.nextLong() >> 3;
        long chunkSeed = xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed;
        this.oreRandom.setSeed(chunkSeed);
        this.anomaliesRandom.setSeed(chunkSeed);
        this.buildingsRandom.setSeed(chunkSeed);
        this.generateGravitationalAnomalies(world, this.anomaliesRandom, chunkX * 16, chunkZ * 16);
        this.generateOres(world, this.oreRandom, chunkX * 16, chunkZ * 16, world.field_73011_w.getDimension());
    }

    public void generateOres(World world, Random random, int chunkX, int chunkZ, int dimentionID) {
        if (!this.oreDimentionsBlacklist.contains(dimentionID)) {
            int y;
            int z;
            int x;
            int i;
            if (this.generateDilithium) {
                for (i = 0; i < 6; ++i) {
                    x = chunkX + random.nextInt(16);
                    z = chunkZ + random.nextInt(16);
                    y = random.nextInt(28) + 4;
                    this.dilithiumGen.func_180709_b(world, random, new BlockPos(x, y, z));
                }
            }
            if (this.generateTritanium) {
                for (i = 0; i < 10; ++i) {
                    x = chunkX + random.nextInt(16);
                    z = chunkZ + random.nextInt(16);
                    y = random.nextInt(60) + 4;
                    this.tritaniumGen.func_180709_b(world, random, new BlockPos(x, y, z));
                }
            }
        }
    }

    private void generateGravitationalAnomalies(World world, Random random, int chunkX, int chunkZ) {
        if (this.generateAnomalies) {
            int y = this.anomalyGen.yLevelMap.getOrDefault(world.field_73011_w.getDimension(), world.func_181545_F());
            BlockPos pos = new BlockPos(chunkX + random.nextInt(16), Math.min(y + random.nextInt(Math.min(255 - y, 60)) + 4, 255), chunkZ + random.nextInt(16));
            if (this.anomalyGen.func_180709_b(world, random, pos) && Platform.isDev()) {
                MOLog.debug("Generated Anomaly at %s", pos);
            }
        }
    }

    private boolean shouldGenerate(Block block, ConfigurationHandler config) {
        Property p = config.config.get("world gen", "spawn." + block.func_149739_a(), true);
        p.setLanguageKey(block.func_149739_a() + ".name");
        return p.getBoolean(true);
    }

    public void startGenerateBuildings(World world, Random random, int chunkX, int chunkZ, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        BlockPos pos;
        WeightedRandomMOWorldGenBuilding building;
        if (this.generateBuildings && random.nextDouble() <= (double)BUILDING_SPAWN_CHANCE && (building = this.getRandomBuilding(world, (pos = world.func_175645_m(new BlockPos(chunkX * 16 + random.nextInt(16), 0, chunkZ * 16 + random.nextInt(16)))).func_177982_a(0, -2, 0), random)) != null) {
            this.startBuildingGeneration(building.worldGenBuilding, pos.func_177982_a(0, -2, 0), random, world, chunkGenerator, chunkProvider, false);
        }
    }

    public MOImageGen.ImageGenWorker startBuildingGeneration(MOWorldGenBuilding building, BlockPos pos, Random random, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider, boolean forceGeneration) {
        if (building == null) {
            return null;
        }
        pos = pos.func_177982_a(8, 0, 8);
        if (forceGeneration || building.shouldGenerate(random, world, pos) && building.isLocationValid(world, pos)) {
            Object worker = building.createWorker(random, pos, world, chunkGenerator, chunkProvider);
            this.worldGenBuildingQueue.add((MOImageGen.ImageGenWorker)worker);
            return worker;
        }
        return null;
    }

    public void manageBuildingGeneration() {
        MOImageGen.ImageGenWorker worker = this.worldGenBuildingQueue.peek();
        if (worker != null && worker.generate()) {
            this.worldGenBuildingQueue.remove();
        }
    }

    public WeightedRandomMOWorldGenBuilding getRandomBuilding(World world, BlockPos pos, Random random) {
        return this.getBuilding(random, world, pos, this.buildings, random.nextInt(this.getTotalBuildingsWeight(random, world, pos, this.buildings)));
    }

    public int getTotalBuildingsWeight(Random random, World world, BlockPos pos, Collection collection) {
        int i = 0;
        for (WeightedRandomMOWorldGenBuilding building : collection) {
            i += building.getWeight(random, world, pos);
        }
        return i;
    }

    public WeightedRandomMOWorldGenBuilding getBuilding(Random random, World world, BlockPos pos, Collection par1Collection, int weight) {
        WeightedRandomMOWorldGenBuilding building;
        int j = weight;
        Iterator iterator = par1Collection.iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((j -= (building = (WeightedRandomMOWorldGenBuilding)((Object)iterator.next())).getWeight(random, world, pos)) >= 0);
        return building;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        int[] oreDimentionBlacklist;
        Property shouldGenerateOres = config.config.get("world gen", "spawn ores", true);
        shouldGenerateOres.setComment("Should Matter Overdrive Ore Blocks be Generated ?");
        this.generateTritanium = this.shouldGenerate(MatterOverdrive.BLOCKS.tritaniumOre, config) && shouldGenerateOres.getBoolean(true);
        this.generateDilithium = this.shouldGenerate(MatterOverdrive.BLOCKS.dilithium_ore, config) && shouldGenerateOres.getBoolean(true);
        Property shouldGenerateOthers = config.config.get("world gen", "spawn other", true);
        shouldGenerateOthers.setComment("Should other Matter Overdrive World Blocks be Generated?");
        this.generateAnomalies = this.shouldGenerate(MatterOverdrive.BLOCKS.gravitational_anomaly, config) && shouldGenerateOthers.getBoolean(true);
        this.oreDimentionsBlacklist.clear();
        Property oreDimentionBlacklistProp = config.config.get("world gen", "ore_gen_blacklist", new int[]{-1, 2});
        oreDimentionBlacklistProp.setComment("A blacklist of all the Dimensions ores shouldn't spawn in");
        oreDimentionBlacklistProp.setLanguageKey("config.ore_gen_blacklist.name");
        for (int anOreDimentionBlacklist : oreDimentionBlacklist = oreDimentionBlacklistProp.getIntList()) {
            this.oreDimentionsBlacklist.add(anOreDimentionBlacklist);
        }
        this.generateBuildings = config.getBool("generate buildings", "world gen", true, "Should Matter Overdrive Buildings Generate aka ImageGen");
    }
}

