/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.text.DecimalFormat;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.starmap.PlanetStatType;
import matteroverdrive.api.weapon.IWeaponStat;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class MOStringHelper {
    public static final String MORE_INFO = TextFormatting.RESET.toString() + TextFormatting.GRAY + "Hold " + TextFormatting.ITALIC + TextFormatting.YELLOW + "Shift" + TextFormatting.RESET.toString() + TextFormatting.GRAY + " for Details.";
    private static String[] suffix = new String[]{"", "K", "M", "B", "T"};
    private static int MAX_LENGTH = 4;

    public static String formatNumber(double number) {
        return MOStringHelper.formatNumber(number, "0.00");
    }

    public static String formatNumber(double number, String decialFormat) {
        if (number > 1.0E15) {
            return new DecimalFormat(decialFormat + "Q").format(number / 1.0E15);
        }
        if (number > 1.0E12) {
            return new DecimalFormat(decialFormat + "T").format(number / 1.0E12);
        }
        if (number > 1.0E9) {
            return new DecimalFormat(decialFormat + "B").format(number / 1.0E9);
        }
        if (number > 1000000.0) {
            return new DecimalFormat(decialFormat + "M").format(number / 1000000.0);
        }
        if (number > 1000.0) {
            return new DecimalFormat(decialFormat + "K").format(number / 1000.0);
        }
        return new DecimalFormat(decialFormat).format(number);
    }

    public static String formatRemainingTime(float seccounds) {
        return MOStringHelper.formatRemainingTime(seccounds, false);
    }

    public static String formatRemainingTime(float seccounds, boolean shotSufix) {
        if (seccounds > 3600.0f) {
            return String.format("%s%s", String.valueOf(Math.round(seccounds / 3600.0f)), shotSufix ? "h" : " hr");
        }
        if (seccounds > 60.0f && seccounds < 3600.0f) {
            return String.format("%s%s", String.valueOf(Math.round(seccounds / 60.0f)), shotSufix ? "m" : " min");
        }
        return String.format("%s%s", String.valueOf(Math.round(seccounds)), shotSufix ? "s" : " sec");
    }

    public static String typingAnimation(String message, int time, int maxTime) {
        float percent = (float)time / (float)maxTime;
        int messageCount = message.length();
        return message.substring(0, MathHelper.func_76125_a((int)Math.round((float)messageCount * percent), (int)0, (int)messageCount));
    }

    public static boolean hasTranslation(String key) {
        return MatterOverdrive.PROXY.hasTranslation(key);
    }

    public static String translateToLocal(String key, Object ... params) {
        return MatterOverdrive.PROXY.translateToLocal(key, params);
    }

    public static String translateToLocal(PlanetStatType statType) {
        return MOStringHelper.translateToLocal("planet_stat." + statType.getUnlocalizedName() + ".name", new Object[0]);
    }

    public static String translateToLocal(UpgradeTypes type) {
        return MOStringHelper.translateToLocal("upgradetype." + type.name() + ".name", new Object[0]);
    }

    public static String weaponStatTranslateToLocal(IWeaponStat type) {
        return MOStringHelper.translateToLocal("weaponstat." + type.func_176610_l() + ".name", new Object[0]);
    }

    public static String toInfo(UpgradeTypes type, double value, boolean good) {
        String info = "";
        info = good ? info + TextFormatting.GREEN : info + TextFormatting.RED;
        DecimalFormat format = new DecimalFormat("##");
        info = info + MOStringHelper.translateToLocal(type) + ": ";
        info = info + format.format(value * 100.0);
        return info + "%";
    }

    public static String weaponStatToInfo(IWeaponStat stat, float value) {
        String info = "";
        info = stat.isPositive(value) ? info + TextFormatting.GREEN : info + TextFormatting.RED;
        DecimalFormat format = new DecimalFormat("##");
        info = info + MOStringHelper.weaponStatTranslateToLocal(stat) + ": ";
        info = info + format.format(value * 100.0f);
        return info + "%";
    }

    public static String toInfo(UpgradeTypes type, double value) {
        return MOStringHelper.toInfo(type, value, MOStringHelper.getGood(type, value));
    }

    public static boolean getGood(UpgradeTypes type, double value) {
        switch (type) {
            case Speed: {
                return value < 1.0;
            }
            case PowerUsage: {
                return value < 1.0;
            }
            case Fail: {
                return value < 1.0;
            }
        }
        return value >= 1.0;
    }

    public static String readTextFile(ResourceLocation location) {
        StringBuilder text = new StringBuilder();
        try {
            String line;
            String path = "/assets/" + location.func_110624_b() + "/" + location.func_110623_a();
            InputStream descriptionStream = MOStringHelper.class.getResourceAsStream(path);
            if (descriptionStream == null) {
                return text.toString();
            }
            LineNumberReader descriptionReader = new LineNumberReader(new InputStreamReader(descriptionStream));
            while ((line = descriptionReader.readLine()) != null) {
                text.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return text.toString();
    }

    public static String addPrefix(String name, String prefix) {
        if (prefix.endsWith("-")) {
            return prefix.substring(0, prefix.length() - 2) + Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        return prefix + " " + name;
    }

    public static String addSuffix(String name, String suffix) {
        if (suffix.startsWith("-")) {
            return name + suffix.substring(1);
        }
        return name + " " + suffix;
    }

    public static String[] formatVariations(String unlocalizedName, String unlocalizedSuffix, int count) {
        String[] variations = new String[count];
        for (int i = 0; i < count; ++i) {
            variations[i] = unlocalizedName + "." + i + "." + unlocalizedSuffix;
        }
        return variations;
    }

    public static boolean isControlKeyDown() {
        return Keyboard.isKeyDown((int)29) || Keyboard.isKeyDown((int)157);
    }

    public static boolean isAltKeyDown() {
        return Keyboard.isKeyDown((int)56) || Keyboard.isKeyDown((int)184);
    }
}

