/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.starmap.gen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import matteroverdrive.client.data.Color;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.starmap.gen.ISpaceBodyGen;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class StarGen
implements ISpaceBodyGen<Star> {
    public static final ResourceLocation starNamesFile = new ResourceLocation("matteroverdrive:info/star_names.txt");
    public static final ResourceLocation starPrefixesFile = new ResourceLocation("matteroverdrive:info/star_prefixes.txt");
    public static final ResourceLocation starSuffixesFile = new ResourceLocation("matteroverdrive:info/star_suffixes.txt");
    private static String[] prefixes;
    private static String[] starNames;
    private static String[] suffixes;
    final float[] radiuses = new float[]{8.8f, 6.6f, 6.6f, 1.8f, 1.8f, 1.4f, 1.4f, 1.15f, 1.15f, 0.96f, 0.96f, 0.7f, 0.7f, 0.2f};
    final int[] temperatures = new int[]{60000, 30000, 30000, 10000, 10000, 7500, 7500, 6000, 6000, 5200, 5200, 3700, 3700, 2400};
    final float[] masses = new float[]{32.0f, 16.0f, 16.0f, 2.1f, 2.1f, 1.4f, 1.4f, 1.04f, 1.04f, 0.8f, 0.8f, 0.45f, 0.45f, 0.08f};
    final double[] weights = new double[]{3.0E-5, 0.13, 0.6, 3.0, 7.6, 12.1, 76.45};
    int type;

    public StarGen(int type) {
        this.type = Math.min(type, this.weights.length - 1);
        starNames = MOStringHelper.readTextFile(starNamesFile).split(",");
        prefixes = MOStringHelper.readTextFile(starPrefixesFile).split(",");
        suffixes = MOStringHelper.readTextFile(starSuffixesFile).split(",");
    }

    public static List<StarGen> getStarGens() {
        ArrayList<StarGen> gens = new ArrayList<StarGen>(7);
        for (int i = 0; i < 7; ++i) {
            gens.add(new StarGen(i));
        }
        return gens;
    }

    public static Color getColorFromTemperature(int temperature) {
        int blue;
        int green;
        int red;
        if ((temperature /= 100) <= 66) {
            red = 255;
        } else {
            red = temperature - 60;
            red = (int)(329.698727446 * Math.pow(red, -0.1332047592));
            red = MathHelper.func_76125_a((int)red, (int)0, (int)255);
        }
        if (temperature <= 66) {
            green = temperature;
            green = (int)(99.4708025861 * Math.log(green) - 161.1195681661);
            green = MathHelper.func_76125_a((int)green, (int)0, (int)255);
        } else {
            green = temperature - 60;
            green = (int)(288.1221695283 * Math.pow(green, -0.0755148492));
            green = MathHelper.func_76125_a((int)green, (int)0, (int)255);
        }
        if (temperature >= 66) {
            blue = 255;
        } else if (temperature <= 19) {
            blue = 0;
        } else {
            blue = temperature - 10;
            blue = (int)(138.5177312231 * Math.log(blue) - 305.0447927307);
            blue = MathHelper.func_76125_a((int)blue, (int)0, (int)255);
        }
        return new Color(red, green, blue);
    }

    public static List<String> generateAvailableNames(Random random, int maxLength, float prefixChance, float sufixChance) {
        ArrayList<String> names = new ArrayList<String>();
        for (String name : starNames) {
            if (name.length() <= maxLength) {
                names.add(name.replace("*", ""));
            }
            for (String prefix : prefixes) {
                String n;
                if (!name.startsWith("*") && random.nextFloat() < prefixChance && (n = MOStringHelper.addPrefix(name, prefix)).length() <= maxLength) {
                    names.add(n.replace("*", ""));
                }
                for (String sufix : suffixes) {
                    if (!name.endsWith("*") && random.nextFloat() < sufixChance && (n = MOStringHelper.addSuffix(name, sufix)).length() <= maxLength) {
                        names.add(n.replace("*", ""));
                    }
                    if (name.startsWith("*") || name.endsWith("*") || !(random.nextFloat() < prefixChance) || !(random.nextFloat() < sufixChance) || (n = MOStringHelper.addPrefix(MOStringHelper.addSuffix(name, sufix), prefix)).length() > maxLength) continue;
                    names.add(n);
                }
            }
        }
        Collections.shuffle(names, random);
        return names;
    }

    @Override
    public void generateSpaceBody(Star star, Random random) {
        this.setType(star);
        this.setSize(star, random);
        this.setMass(star, random);
        this.setTemperature(star, random);
        this.setColor(star);
    }

    @Override
    public boolean generateMissing(NBTTagCompound tagCompound, Star star, Random random) {
        if (!tagCompound.func_150297_b("Type", 1)) {
            this.setType(star);
        }
        if (!tagCompound.func_150297_b("Size", 5)) {
            this.setSize(star, random);
        }
        if (!tagCompound.func_150297_b("Temperature", 3)) {
            this.setTemperature(star, random);
        }
        if (!tagCompound.func_150297_b("Color", 3)) {
            this.setColor(star);
        }
        return true;
    }

    private void setType(Star star) {
        star.setType((byte)this.type);
    }

    private void setSize(Star star, Random random) {
        star.setSize(this.radiuses[this.type * 2 + 1] + random.nextFloat() * (this.radiuses[this.type * 2] - this.radiuses[this.type * 2 + 1]));
    }

    private void setMass(Star star, Random random) {
        star.setMass(this.masses[this.type * 2 + 1] + random.nextFloat() * (this.masses[this.type * 2] - this.masses[this.type * 2 + 1]));
    }

    private void setTemperature(Star star, Random random) {
        star.setTemperature((short)(this.temperatures[this.type * 2 + 1] + random.nextInt(this.temperatures[this.type * 2] - this.temperatures[this.type * 2 + 1])));
    }

    private void setColor(Star star) {
        star.setColor(StarGen.getColorFromTemperature(star.getTemperature()).getColor());
    }

    @Override
    public double getWeight(Star star) {
        return this.weights[this.type];
    }
}

