/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.starmap.data;

import com.mojang.authlib.GameProfile;
import io.netty.buffer.ByteBuf;
import java.io.File;
import java.util.UUID;
import javax.annotation.Nonnull;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.starmap.GalacticPosition;
import matteroverdrive.client.data.Color;
import matteroverdrive.network.packet.client.starmap.PacketUpdatePlanet;
import matteroverdrive.starmap.GalaxyGenerator;
import matteroverdrive.starmap.data.SpaceBody;
import matteroverdrive.starmap.data.Star;
import matteroverdrive.starmap.gen.ISpaceBodyGen;
import matteroverdrive.util.MOLog;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Level;

public class Planet
extends SpaceBody
implements IInventory {
    public static final int SLOT_COUNT = 4;
    private Star star;
    private float size;
    private float orbit;
    private byte type;
    private UUID ownerUUID;
    private NonNullList<ItemStack> inventory;
    private boolean isDirty;
    private boolean homeworld;
    private boolean generated;
    private boolean needsClientUpdate;
    private int seed;

    public Planet() {
        this.init();
    }

    public Planet(String name, int id) {
        super(name, id);
        this.init();
    }

    @SideOnly(value=Side.CLIENT)
    public static Color getGuiColor(Planet planet) {
        if (planet.hasOwner()) {
            if (planet.getOwnerUUID().equals(EntityPlayer.func_146094_a((GameProfile)Minecraft.func_71410_x().field_71439_g.func_146103_bH()))) {
                if (planet.isHomeworld()) {
                    return Reference.COLOR_HOLO_YELLOW;
                }
                return Reference.COLOR_HOLO_GREEN;
            }
            return Reference.COLOR_HOLO_RED;
        }
        return Reference.COLOR_HOLO;
    }

    public boolean func_191420_l() {
        return false;
    }

    private void init() {
        this.inventory = NonNullList.func_191197_a((int)4, (Object)ItemStack.field_190927_a);
    }

    public void update(World world) {
        if (!world.field_72995_K && this.needsClientUpdate) {
            this.needsClientUpdate = false;
            MatterOverdrive.NETWORK.sendToDimention((IMessage)new PacketUpdatePlanet(this), world);
        }
    }

    public void onSave(File file, World world) {
        this.isDirty = false;
    }

    public void onTravelEvent(ItemStack ship, GalacticPosition from, World world) {
        if (!world.field_72995_K) {
            // empty if block
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            this.func_70301_a(i).func_77955_b(itemTag);
            tagCompound.func_74782_a("Slot" + i, (NBTBase)itemTag);
        }
        if (this.ownerUUID != null) {
            tagCompound.func_74778_a("OwnerUUID", this.ownerUUID.toString());
        }
        tagCompound.func_74757_a("Homeworld", this.homeworld);
        tagCompound.func_74776_a("Size", this.size);
        tagCompound.func_74774_a("Type", this.type);
        tagCompound.func_74776_a("Orbit", this.orbit);
        tagCompound.func_74768_a("Seed", this.seed);
    }

    @Override
    public void writeToBuffer(ByteBuf byteBuf) {
        super.writeToBuffer(byteBuf);
        NBTTagCompound nbtData = new NBTTagCompound();
        this.writeToNBT(nbtData);
        ByteBufUtils.writeTag((ByteBuf)byteBuf, (NBTTagCompound)nbtData);
    }

    @Override
    public void readFromNBT(NBTTagCompound tagCompound, GalaxyGenerator generator) {
        super.readFromNBT(tagCompound, generator);
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!tagCompound.func_150297_b("Slot" + i, 10)) continue;
            this.func_70299_a(i, new ItemStack(tagCompound.func_74775_l("Slot" + i)));
        }
        if (tagCompound.func_150297_b("OwnerUUID", 8)) {
            try {
                this.ownerUUID = UUID.fromString(tagCompound.func_74779_i("OwnerUUID"));
            }
            catch (IllegalArgumentException e) {
                MOLog.log(Level.ERROR, e, "Invalid planet owner UUID '" + tagCompound.func_74779_i("OwnerUUID") + "'", this);
            }
        }
        this.homeworld = tagCompound.func_74767_n("Homeworld");
        this.size = tagCompound.func_74760_g("Size");
        this.type = tagCompound.func_74771_c("Type");
        this.orbit = tagCompound.func_74760_g("Orbit");
        this.seed = tagCompound.func_74762_e("Seed");
        this.generateMissing(tagCompound, generator);
    }

    @Override
    public void readFromBuffer(ByteBuf byteBuf) {
        super.readFromBuffer(byteBuf);
        NBTTagCompound nbtData = ByteBufUtils.readTag((ByteBuf)byteBuf);
        this.readFromNBT(nbtData, null);
    }

    public void generateMissing(NBTTagCompound tagCompound, GalaxyGenerator galaxyGenerator) {
        if (galaxyGenerator != null) {
            for (ISpaceBodyGen<Planet> starGen : galaxyGenerator.getPlanetGen().getGens()) {
                galaxyGenerator.getStarRandom().setSeed(this.seed);
                if (!starGen.generateMissing(tagCompound, this, galaxyGenerator.getStarRandom())) continue;
                break;
            }
        }
    }

    @Override
    public SpaceBody getParent() {
        return this.star;
    }

    public Star getStar() {
        return this.star;
    }

    public void setStar(Star star) {
        this.star = star;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID ownerUUID) {
        this.ownerUUID = ownerUUID;
    }

    public void setOwner(EntityPlayer player) {
        this.ownerUUID = EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH());
    }

    public boolean hasOwner() {
        return this.ownerUUID != null;
    }

    public boolean isOwner(EntityPlayer player) {
        return this.hasOwner() && this.getOwnerUUID().equals(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
    }

    public boolean isHomeworld() {
        return this.homeworld;
    }

    public void setHomeworld(boolean homeworld) {
        this.homeworld = homeworld;
    }

    public boolean isHomeworld(EntityPlayer player) {
        return this.isOwner(player) && this.isHomeworld();
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public float getOrbit() {
        return this.orbit;
    }

    public void setOrbit(float orbit) {
        this.orbit = orbit;
    }

    public int getSeed() {
        return this.seed;
    }

    public void setSeed(int seed) {
        this.seed = seed;
    }

    public boolean isGenerated() {
        return this.generated;
    }

    public void setGenerated(boolean generated) {
        this.generated = generated;
    }

    public int getPopulation() {
        return 0;
    }

    public int getPowerProduction() {
        return 0;
    }

    public float getMatterProduction() {
        return 0.0f;
    }

    public float getHappiness() {
        return 0.0f;
    }

    public void markForUpdate() {
        this.needsClientUpdate = true;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public int func_70302_i_() {
        return 4;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        if (slot >= 0 && slot < this.func_70302_i_()) {
            return (ItemStack)this.inventory.get(slot);
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70298_a(int slot, int size) {
        if (!((ItemStack)this.inventory.get(slot)).func_190926_b()) {
            if (((ItemStack)this.inventory.get(slot)).func_190916_E() <= size) {
                ItemStack itemstack = (ItemStack)this.inventory.get(slot);
                this.inventory.set(slot, (Object)ItemStack.field_190927_a);
                return itemstack;
            }
            ItemStack itemstack = ((ItemStack)this.inventory.get(slot)).func_77979_a(size);
            if (((ItemStack)this.inventory.get(slot)).func_190916_E() == 0) {
                this.inventory.set(slot, (Object)ItemStack.field_190927_a);
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        if (!((ItemStack)this.inventory.get(index)).func_190926_b()) {
            ItemStack stack = (ItemStack)this.inventory.get(index);
            this.inventory.set(index, (Object)ItemStack.field_190927_a);
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, @Nonnull ItemStack stack) {
        if (slot < this.inventory.size()) {
            this.inventory.set(slot, (Object)stack);
            if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
        }
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        this.isDirty = true;
        this.markForUpdate();
    }

    public boolean func_70300_a(@Nonnull EntityPlayer player) {
        return !this.hasOwner() || this.getOwnerUUID().equals(EntityPlayer.func_146094_a((GameProfile)player.func_146103_bH()));
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    public boolean func_94041_b(int slot, @Nonnull ItemStack stack) {
        return false;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    @Nonnull
    public String func_70005_c_() {
        return this.getSpaceBodyName();
    }

    public boolean func_145818_k_() {
        return true;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.getSpaceBodyName());
    }
}

