/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.proxy;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.client.RenderHandler;
import matteroverdrive.client.model.MOModelLoader;
import matteroverdrive.client.render.HoloIcons;
import matteroverdrive.client.resources.data.WeaponMetadataSection;
import matteroverdrive.client.resources.data.WeaponMetadataSectionSerializer;
import matteroverdrive.compat.MatterOverdriveCompat;
import matteroverdrive.gui.GuiAndroidHud;
import matteroverdrive.gui.GuiQuestHud;
import matteroverdrive.handler.KeyHandler;
import matteroverdrive.handler.MouseHandler;
import matteroverdrive.handler.TooltipHandler;
import matteroverdrive.handler.thread.RegistryToast;
import matteroverdrive.handler.weapon.ClientWeaponHandler;
import matteroverdrive.handler.weapon.CommonWeaponHandler;
import matteroverdrive.init.MatterOverdriveGuides;
import matteroverdrive.proxy.CommonProxy;
import matteroverdrive.starmap.GalaxyClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.toasts.IToast;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.resources.IReloadableResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.data.IMetadataSectionSerializer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ClientProxy
extends CommonProxy {
    public static RenderHandler renderHandler;
    public static KeyHandler keyHandler;
    public static MouseHandler mouseHandler;
    public static GuiAndroidHud androidHud;
    public static HoloIcons holoIcons;
    public static GuiQuestHud questHud;
    public static FontRenderer moFontRender;
    private ClientWeaponHandler weaponHandler = new ClientWeaponHandler();
    private MOModelLoader modelLoader;

    public static ClientProxy instance() {
        if (MatterOverdrive.PROXY instanceof ClientProxy) {
            return (ClientProxy)MatterOverdrive.PROXY;
        }
        if (MatterOverdrive.PROXY == null) {
            throw new UnsupportedOperationException("Attempted to access ClientProxy without it being initialized");
        }
        throw new UnsupportedOperationException("Attempted to access ClientProxy on server side");
    }

    private void registerSubscribtions() {
        MinecraftForge.EVENT_BUS.register((Object)keyHandler);
        MinecraftForge.EVENT_BUS.register((Object)mouseHandler);
        MinecraftForge.EVENT_BUS.register((Object)GalaxyClient.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)new TooltipHandler());
        MinecraftForge.EVENT_BUS.register((Object)androidHud);
        MinecraftForge.EVENT_BUS.register((Object)questHud);
        MinecraftForge.EVENT_BUS.register((Object)this.weaponHandler);
        MinecraftForge.EVENT_BUS.register((Object)holoIcons);
    }

    @Override
    public void registerCompatModules() {
        super.registerCompatModules();
        MatterOverdriveCompat.registerClientModules();
    }

    @Override
    public EntityPlayer getPlayerEntity(MessageContext ctx) {
        return ctx.side.isClient() ? Minecraft.func_71410_x().field_71439_g : super.getPlayerEntity(ctx);
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        super.preInit(event);
        OBJLoader.INSTANCE.addDomain("matteroverdrive");
        this.modelLoader = new MOModelLoader();
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)this.modelLoader);
        Minecraft.func_71410_x().func_110438_M().field_110621_c.func_110504_a((IMetadataSectionSerializer)new WeaponMetadataSectionSerializer(), WeaponMetadataSection.class);
        renderHandler = new RenderHandler();
        renderHandler.registerEntityRenderers();
        renderHandler.createItemRenderers();
        renderHandler.registerWeaponModuleRenders();
    }

    @Override
    public void init(FMLInitializationEvent event) {
        super.init(event);
        renderHandler.init((World)Minecraft.func_71410_x().field_71441_e, Minecraft.func_71410_x().func_110434_K());
        renderHandler.createEntityRenderers(Minecraft.func_71410_x().func_175598_ae());
        androidHud = new GuiAndroidHud(Minecraft.func_71410_x());
        keyHandler = new KeyHandler();
        mouseHandler = new MouseHandler();
        holoIcons = new HoloIcons();
        this.weaponHandler = new ClientWeaponHandler();
        questHud = new GuiQuestHud();
        this.registerSubscribtions();
        renderHandler.createTileEntityRenderers(MatterOverdrive.CONFIG_HANDLER);
        renderHandler.createBioticStatRenderers();
        renderHandler.createStarmapRenderers();
        renderHandler.createModels();
        renderHandler.registerWeaponLayers();
        renderHandler.registerTileEntitySpecialRenderers();
        renderHandler.registerBlockColors();
        renderHandler.registerItemColors();
        renderHandler.registerBioticStatRenderers();
        renderHandler.registerBionicPartRenderers();
        renderHandler.registerStarmapRenderers();
        MatterOverdrive.CONFIG_HANDLER.subscribe(androidHud);
        this.weaponHandler.registerWeapon(MatterOverdrive.ITEMS.phaserRifle);
        this.weaponHandler.registerWeapon(MatterOverdrive.ITEMS.phaser);
        this.weaponHandler.registerWeapon(MatterOverdrive.ITEMS.omniTool);
        this.weaponHandler.registerWeapon(MatterOverdrive.ITEMS.plasmaShotgun);
        this.weaponHandler.registerWeapon(MatterOverdrive.ITEMS.ionSniper);
        MatterOverdriveGuides.registerGuideElements(event);
        moFontRender = new FontRenderer(Minecraft.func_71410_x().field_71474_y, new ResourceLocation("matteroverdrive", "textures/font/ascii.png"), Minecraft.func_71410_x().field_71446_o, false);
        ((IReloadableResourceManager)Minecraft.func_71410_x().func_110442_L()).func_110542_a((IResourceManagerReloadListener)moFontRender);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        MatterOverdriveGuides.registerGuides(event);
    }

    public ClientWeaponHandler getClientWeaponHandler() {
        return this.weaponHandler;
    }

    @Override
    public CommonWeaponHandler getWeaponHandler() {
        return this.weaponHandler;
    }

    @Override
    public boolean hasTranslation(String key) {
        return I18n.func_188566_a((String)key);
    }

    @Override
    public String translateToLocal(String key, Object ... params) {
        return I18n.func_135052_a((String)key, (Object[])params);
    }

    @Override
    public void matterToast(boolean b, long l) {
        Minecraft.func_71410_x().func_193033_an().func_192988_a((IToast)new RegistryToast(b, l));
    }
}

