/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import io.netty.buffer.ByteBuf;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.android.IBioticStat;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketUnlockBioticStat
extends PacketAbstract {
    String name;
    int level;

    public PacketUnlockBioticStat() {
    }

    public PacketUnlockBioticStat(String name, int level) {
        this.name = name;
        this.level = level;
    }

    public void fromBytes(ByteBuf buf) {
        this.name = ByteBufUtils.readUTF8String((ByteBuf)buf);
        this.level = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.name);
        buf.writeInt(this.level);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketUnlockBioticStat> {
        @Override
        public void handleServerMessage(EntityPlayerMP player, PacketUnlockBioticStat message, MessageContext ctx) {
            IBioticStat stat = MatterOverdrive.STAT_REGISTRY.getStat(message.name);
            AndroidPlayer androidPlayer = MOPlayerCapabilityProvider.GetAndroidCapability((Entity)player);
            if (stat != null && androidPlayer != null && androidPlayer.isAndroid()) {
                androidPlayer.tryUnlock(stat, message.level);
            }
        }
    }
}

