/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import io.netty.buffer.ByteBuf;
import java.util.EnumSet;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.network.packet.AbstractBiPacketHandler;
import matteroverdrive.network.packet.TileEntityUpdatePacket;
import matteroverdrive.tile.MOTileEntity;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketSendMachineNBT
extends TileEntityUpdatePacket {
    NBTTagCompound data;
    int cattegories;
    boolean forceUpdate;

    public PacketSendMachineNBT() {
    }

    public PacketSendMachineNBT(EnumSet<MachineNBTCategory> categories, MOTileEntity tileEntity, boolean forceUpdate, boolean toDisk) {
        super(tileEntity);
        this.data = new NBTTagCompound();
        this.forceUpdate = forceUpdate;
        tileEntity.writeCustomNBT(this.data, categories, toDisk);
        this.cattegories = MachineNBTCategory.encode(categories);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.data = ByteBufUtils.readTag((ByteBuf)buf);
        this.cattegories = buf.readInt();
        this.forceUpdate = buf.readBoolean();
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.data);
        buf.writeInt(this.cattegories);
        buf.writeBoolean(this.forceUpdate);
    }

    public static class BiHandler
    extends AbstractBiPacketHandler<PacketSendMachineNBT> {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleClientMessage(EntityPlayerSP player, PacketSendMachineNBT message, MessageContext ctx) {
            TileEntity tileEntity = message.getTileEntity(player.field_70170_p);
            if (tileEntity instanceof MOTileEntity) {
                ((MOTileEntity)tileEntity).readCustomNBT(message.data, MachineNBTCategory.decode(message.cattegories));
            }
        }

        @Override
        public void handleServerMessage(EntityPlayerMP player, PacketSendMachineNBT message, MessageContext ctx) {
            TileEntity tileEntity = message.getTileEntity(player.field_70170_p);
            if (tileEntity instanceof MOTileEntity) {
                ((MOTileEntity)tileEntity).readCustomNBT(message.data, MachineNBTCategory.decode(message.cattegories));
                if (message.forceUpdate && tileEntity instanceof MOTileEntityMachine) {
                    ((MOTileEntityMachine)tileEntity).forceSync();
                }
            }
        }
    }
}

