/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.server;

import io.netty.buffer.ByteBuf;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.dialog.IDialogMessage;
import matteroverdrive.api.dialog.IDialogNpc;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.server.AbstractServerPacketHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketConversationInteract
extends PacketAbstract {
    int npcID;
    int dialogMessageID;
    int optionId;

    public PacketConversationInteract() {
    }

    public PacketConversationInteract(IDialogNpc npc, IDialogMessage dialogMessage, int optionId) {
        this.npcID = npc.getEntity().func_145782_y();
        this.dialogMessageID = MatterOverdrive.DIALOG_REGISTRY.getMessageId(dialogMessage);
        this.optionId = optionId;
    }

    public void fromBytes(ByteBuf buf) {
        this.npcID = buf.readInt();
        this.dialogMessageID = buf.readInt();
        this.optionId = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.npcID);
        buf.writeInt(this.dialogMessageID);
        buf.writeInt(this.optionId);
    }

    public static class ServerHandler
    extends AbstractServerPacketHandler<PacketConversationInteract> {
        @Override
        public void handleServerMessage(EntityPlayerMP player, PacketConversationInteract message, MessageContext ctx) {
            IDialogMessage m;
            Entity npcEntity = player.field_70170_p.func_73045_a(message.npcID);
            if (npcEntity instanceof IDialogNpc && (m = message.dialogMessageID >= 0 ? MatterOverdrive.DIALOG_REGISTRY.getMessage(message.dialogMessageID) : ((IDialogNpc)npcEntity).getStartDialogMessage((EntityPlayer)player)) != null) {
                m.onOptionsInteract((IDialogNpc)npcEntity, (EntityPlayer)player, message.optionId);
            }
        }
    }
}

