/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client.quest;

import io.netty.buffer.ByteBuf;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.data.quest.PlayerQuestData;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketUpdateQuest
extends PacketAbstract {
    public static final byte UPDATE_QUEST = 0;
    public static final byte ADD_QUEST = 1;
    public static final byte COMPLETE_QUEST = 2;
    private byte questUpdateOperation;
    private int questIndex;
    private QuestStack questStack;
    private QuestState questState;

    public PacketUpdateQuest() {
    }

    public PacketUpdateQuest(int questIndex, QuestState questState, PlayerQuestData playerQuestData, byte questUpdateOperation) {
        this.questIndex = questIndex;
        this.questState = questState;
        this.questUpdateOperation = questUpdateOperation;
        this.questStack = playerQuestData.getActiveQuests().get(questIndex);
    }

    public PacketUpdateQuest(int questIndex, QuestState questState, QuestStack questStack, byte questUpdateOperation) {
        this.questIndex = questIndex;
        this.questState = questState;
        this.questUpdateOperation = questUpdateOperation;
        this.questStack = questStack;
    }

    public PacketUpdateQuest(QuestStack questStack, byte questUpdateOperation) {
        this.questIndex = -1;
        this.questUpdateOperation = questUpdateOperation;
        this.questStack = questStack;
    }

    public void fromBytes(ByteBuf buf) {
        this.questIndex = buf.readInt();
        this.questUpdateOperation = buf.readByte();
        if (buf.readBoolean()) {
            int indexesSize = buf.readByte();
            int[] indexes = new int[]{indexesSize};
            for (int i = 0; i < indexesSize; ++i) {
                indexes[i] = buf.readShort();
            }
            this.questState = new QuestState(QuestState.Type.values()[buf.readByte()], indexes, buf.readBoolean());
        }
        this.questStack = QuestStack.loadFromNBT(ByteBufUtils.readTag((ByteBuf)buf));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.questIndex);
        buf.writeByte((int)this.questUpdateOperation);
        if (this.questState != null) {
            buf.writeBoolean(true);
            buf.writeByte(this.questState.getObjectiveIds().length);
            for (int i : this.questState.getObjectiveIds()) {
                buf.writeShort(i);
            }
            buf.writeByte(this.questState.getType().ordinal());
            buf.writeBoolean(this.questState.isShowOnHud());
        } else {
            buf.writeBoolean(false);
        }
        NBTTagCompound questStackNBT = new NBTTagCompound();
        this.questStack.writeToNBT(questStackNBT);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)questStackNBT);
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketUpdateQuest> {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleClientMessage(EntityPlayerSP player, PacketUpdateQuest message, MessageContext ctx) {
            OverdriveExtendedProperties extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)player);
            if (extendedProperties != null) {
                if (message.questUpdateOperation == 0) {
                    extendedProperties.updateQuestFromServer(message.questIndex, message.questStack, message.questState);
                } else if (message.questUpdateOperation == 1) {
                    extendedProperties.addQuest(message.questStack);
                } else if (message.questUpdateOperation == 2) {
                    extendedProperties.onQuestCompleted(message.questStack, message.questIndex);
                }
            }
        }
    }
}

