/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.network.packet.client.pattern_monitor;

import io.netty.buffer.ByteBuf;
import matteroverdrive.container.matter_network.ContainerPatternMonitor;
import matteroverdrive.network.packet.PacketAbstract;
import matteroverdrive.network.packet.client.AbstractClientPacketHandler;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketClearPatterns
extends PacketAbstract {
    private int windowID;
    private BlockPos database;
    private int patternStorageId;

    public PacketClearPatterns() {
    }

    public PacketClearPatterns(int windowID) {
        this.windowID = windowID;
    }

    public PacketClearPatterns(int windowID, BlockPos database) {
        this(windowID);
        this.database = database;
    }

    public PacketClearPatterns(int windowID, BlockPos database, int patternStorageId) {
        this(windowID, database);
        this.patternStorageId = patternStorageId;
    }

    public void fromBytes(ByteBuf buf) {
        this.windowID = buf.readByte();
        if (buf.readBoolean()) {
            this.database = BlockPos.func_177969_a((long)buf.readLong());
        }
        this.patternStorageId = buf.readByte();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.windowID);
        buf.writeBoolean(this.database != null);
        if (this.database != null) {
            buf.writeLong(this.database.func_177986_g());
        }
        buf.writeByte(this.patternStorageId);
    }

    public static class ClientHandler
    extends AbstractClientPacketHandler<PacketClearPatterns> {
        @Override
        @SideOnly(value=Side.CLIENT)
        public void handleClientMessage(EntityPlayerSP player, PacketClearPatterns message, MessageContext ctx) {
            if (player.field_71070_bA instanceof ContainerPatternMonitor) {
                if (message.database != null) {
                    if (message.patternStorageId >= 0) {
                        ((ContainerPatternMonitor)player.field_71070_bA).clearPatternStoragePatterns(message.database, message.patternStorageId);
                    } else {
                        ((ContainerPatternMonitor)player.field_71070_bA).clearDatabasePatterns(message.database);
                    }
                } else {
                    ((ContainerPatternMonitor)player.field_71070_bA).clearAllPatterns();
                }
            }
        }
    }
}

