/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network.components;

import java.util.EnumSet;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.matter_network.IMatterNetworkComponent;
import matteroverdrive.api.matter_network.IMatterNetworkConnection;
import matteroverdrive.api.transport.IGridNode;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.transport.MatterNetwork;
import matteroverdrive.machines.IMachineComponent;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.events.MachineEvent;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class MatterNetworkComponentClient<T extends MOTileEntityMachine>
implements IMachineComponent,
IMatterNetworkConnection,
ITickable,
IMatterNetworkComponent {
    protected final T rootClient;
    private MatterNetwork matterNetwork;

    public MatterNetworkComponentClient(T rootClient) {
        this.rootClient = rootClient;
    }

    @Override
    public MatterNetwork getNetwork() {
        return this.matterNetwork;
    }

    @Override
    public void setNetwork(MatterNetwork network) {
        this.matterNetwork = network;
    }

    @Override
    public World getNodeWorld() {
        return this.rootClient.func_145831_w();
    }

    @Override
    public boolean canConnectToNetworkNode(IBlockState blockState, IGridNode toNode, EnumFacing direction) {
        return this.canConnectFromSide(blockState, direction);
    }

    @Override
    public BlockPos getNodePos() {
        return this.rootClient.func_174877_v();
    }

    @Override
    public boolean canConnectFromSide(IBlockState blockState, EnumFacing side) {
        return ((IGridNode)this.rootClient).canConnectFromSide(blockState, side);
    }

    @Override
    public boolean establishConnectionFromSide(IBlockState blockState, EnumFacing side) {
        return ((IGridNode)this.rootClient).canConnectFromSide(blockState, side);
    }

    @Override
    public void breakConnection(IBlockState blockState, EnumFacing side) {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
    }

    @Override
    public void registerSlots(Inventory inventory) {
    }

    public void func_73660_a() {
        if (!this.getNodeWorld().field_72995_K) {
            this.manageNetwork();
        }
    }

    protected void manageNetwork() {
        if (this.matterNetwork == null && !this.tryConnectToNeighborNetworks(this.getNodeWorld())) {
            MatterNetwork network = (MatterNetwork)MatterOverdrive.MATTER_NETWORK_HANDLER.getNetwork((IGridNode)this.rootClient);
            network.addNode((IGridNode)this.rootClient);
        }
    }

    protected boolean tryConnectToNeighborNetworks(World world) {
        boolean hasConnected = false;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileEntity neighborEntity;
            if (!((IGridNode)this.rootClient).canConnectFromSide(world.func_180495_p(this.getNodePos()), side) || !((neighborEntity = world.func_175625_s(this.getNodePos().func_177972_a(side))) instanceof IMatterNetworkConnection) || !this.canConnectToNetworkNode(world.func_180495_p(this.getNodePos()), (IMatterNetworkConnection)neighborEntity, side) || ((IMatterNetworkConnection)neighborEntity).getNetwork() == null || ((IMatterNetworkConnection)neighborEntity).getNetwork() == this.matterNetwork) continue;
            ((MatterNetwork)((IMatterNetworkConnection)neighborEntity).getNetwork()).addNode((IGridNode)this.rootClient);
            hasConnected = true;
        }
        return hasConnected;
    }

    @Override
    public boolean isAffectedByUpgrade(UpgradeTypes type) {
        return false;
    }

    @Override
    public boolean isActive() {
        return false;
    }

    @Override
    public void onMachineEvent(MachineEvent event) {
        if (event instanceof MachineEvent.Destroyed) {
            this.onDestroyed((MachineEvent.Destroyed)event);
        } else if (event instanceof MachineEvent.Added) {
            this.onAdded((MachineEvent.Added)event);
        } else if (event instanceof MachineEvent.Unload) {
            this.onUnload((MachineEvent.Unload)event);
        }
    }

    protected void onDestroyed(MachineEvent.Destroyed event) {
        if (!event.world.field_72995_K) {
            if (this.matterNetwork != null) {
                this.matterNetwork.onNodeDestroy(event.state, (IGridNode)this.rootClient);
            }
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                if (!this.canConnectFromSide(event.state, enumFacing)) continue;
                TileEntity tileEntityNeignbor = event.world.func_175625_s(event.pos.func_177972_a(enumFacing));
                IBlockState neighborState = event.world.func_180495_p(event.pos.func_177972_a(enumFacing));
                if (!(tileEntityNeignbor instanceof IMatterNetworkConnection)) continue;
                ((IMatterNetworkConnection)tileEntityNeignbor).breakConnection(neighborState, enumFacing.func_176734_d());
            }
        }
    }

    protected void onAdded(MachineEvent.Added event) {
        if (!event.world.field_72995_K) {
            for (EnumFacing enumFacing : EnumFacing.field_82609_l) {
                TileEntity tileEntityNeignbor = event.world.func_175625_s(event.pos.func_177972_a(enumFacing));
                IBlockState neighborState = event.world.func_180495_p(event.pos.func_177972_a(enumFacing));
                if (this.canConnectFromSide(event.state, enumFacing) && tileEntityNeignbor instanceof IMatterNetworkConnection && !((IMatterNetworkConnection)tileEntityNeignbor).establishConnectionFromSide(neighborState, enumFacing.func_176734_d())) continue;
            }
        }
    }

    protected void onUnload(MachineEvent.Unload event) {
        if (!this.getNodeWorld().field_72995_K && !this.getNodeWorld().field_72995_K) {
            IBlockState blockState = this.getNodeWorld().func_180495_p(this.getNodePos());
            if (this.matterNetwork != null) {
                this.matterNetwork.onNodeDestroy(blockState, (IGridNode)this.rootClient);
            }
        }
    }
}

