/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.matter_network;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import matteroverdrive.api.network.MatterNetworkTask;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskReplicatePattern;
import matteroverdrive.matter_network.tasks.MatterNetworkTaskStorePattern;

public class MatterNetworkRegistry {
    public static final List<Class> taskTypes = new ArrayList<Class>();

    public static int registerTask(Class<? extends MatterNetworkTask> taskClass) {
        taskTypes.add(taskClass);
        return taskTypes.size() - 1;
    }

    public static void register() {
        MatterNetworkRegistry.registerTask(MatterNetworkTaskReplicatePattern.class);
        MatterNetworkRegistry.registerTask(MatterNetworkTaskStorePattern.class);
    }

    public static int getTaskID(Class<? extends MatterNetworkTask> type) throws NoSuchElementException {
        for (int i = 0; i < taskTypes.size(); ++i) {
            if (!type.equals(taskTypes.get(i))) continue;
            return i;
        }
        throw new NoSuchElementException(String.format("Task %s was not registered", type));
    }

    public static Class getTaskClass(int id) {
        return taskTypes.get(id);
    }
}

