/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.machines;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.IMOTileEntity;
import matteroverdrive.api.IUpgradeable;
import matteroverdrive.api.container.IMachineWatcher;
import matteroverdrive.api.inventory.IUpgrade;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.api.machines.IUpgradeHandler;
import matteroverdrive.blocks.includes.MOBlock;
import matteroverdrive.blocks.includes.MOBlockMachine;
import matteroverdrive.client.sound.MachineSound;
import matteroverdrive.data.Inventory;
import matteroverdrive.data.TileEntityInventory;
import matteroverdrive.data.inventory.UpgradeSlot;
import matteroverdrive.fx.VentParticle;
import matteroverdrive.items.SecurityProtocol;
import matteroverdrive.machines.IMachineComponent;
import matteroverdrive.machines.MachineNBTCategory;
import matteroverdrive.machines.UpgradeHandlerGeneric;
import matteroverdrive.machines.components.ComponentConfigs;
import matteroverdrive.machines.configs.ConfigPropertyStringList;
import matteroverdrive.machines.events.MachineEvent;
import matteroverdrive.network.packet.server.PacketSendMachineNBT;
import matteroverdrive.tile.MOTileEntity;
import matteroverdrive.util.MOLog;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MatterHelper;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.apache.logging.log4j.Level;
import org.lwjgl.util.vector.Matrix4f;
import org.lwjgl.util.vector.Vector3f;
import org.lwjgl.util.vector.Vector4f;

public abstract class MOTileEntityMachine
extends MOTileEntity
implements IMOTileEntity,
ISidedInventory,
IUpgradeable,
ITickable {
    protected static final Random random = new Random();
    protected static final UpgradeHandlerGeneric basicUpgradeHandler = new UpgradeHandlerGeneric(0.05, Double.MAX_VALUE).addUpgradeMinimum(UpgradeTypes.Speed, 0.1);
    protected final List<IMachineWatcher> watchers;
    protected final Inventory inventory;
    protected final IItemHandler inventoryHandler;
    protected final IItemHandler[] sidedWrappers = new IItemHandler[EnumFacing.field_82609_l.length];
    protected final List<IMachineComponent> components = new ArrayList<IMachineComponent>();
    private final int[] upgrade_slots;
    @SideOnly(value=Side.CLIENT)
    protected MachineSound sound;
    protected boolean redstoneState;
    protected boolean redstoneStateDirty = true;
    protected UUID owner;
    protected boolean playerSlotsHotbar;
    protected boolean playerSlotsMain;
    protected ComponentConfigs configs;
    private boolean lastActive;
    private boolean activeState;
    private boolean awoken;
    private boolean forceClientUpdate;

    public MOTileEntityMachine(int upgradeCount) {
        this.upgrade_slots = new int[upgradeCount];
        this.inventory = new TileEntityInventory(this, "");
        for (EnumFacing facing : EnumFacing.field_82609_l) {
            this.sidedWrappers[facing.ordinal()] = new SidedInvWrapper((ISidedInventory)this, facing);
        }
        this.inventoryHandler = new InvWrapper((IInventory)this);
        this.registerComponents();
        this.RegisterSlots(this.inventory);
        this.watchers = new ArrayList<IMachineWatcher>();
    }

    public boolean func_191420_l() {
        return this.inventory.func_191420_l();
    }

    public void func_73660_a() {
        if (!this.awoken) {
            this.awoken = true;
            this.onAwake(this.field_145850_b.field_72995_K ? Side.CLIENT : Side.SERVER);
        }
        if (this.field_145850_b.field_72995_K) {
            this.manageSound();
            if (this.lastActive != this.isActive()) {
                this.onActiveChange();
                this.lastActive = this.isActive();
            }
        } else {
            this.activeState = this.getServerActive();
            if (this.lastActive != this.activeState) {
                this.forceSync();
                this.onActiveChange();
                this.lastActive = this.activeState;
            }
            this.manageRedstoneState();
            this.manageClientSync();
        }
        this.components.stream().filter(component -> component instanceof ITickable).forEach(component -> {
            try {
                ((ITickable)component).func_73660_a();
            }
            catch (Exception e) {
                MOLog.log(Level.FATAL, e, "There was a problem while ticking %s component %s", this, component);
            }
        });
    }

    protected void RegisterSlots(Inventory inventory) {
        for (int i = 0; i < this.upgrade_slots.length; ++i) {
            this.upgrade_slots[i] = inventory.AddSlot(new UpgradeSlot(false, this));
        }
        for (IMachineComponent component : this.components) {
            component.registerSlots(inventory);
        }
    }

    protected void registerComponents() {
        this.configs = new ComponentConfigs(this);
        this.configs.addProperty(new ConfigPropertyStringList("redstoneMode", "gui.config.redstone", new String[]{MOStringHelper.translateToLocal("gui.redstone_mode.low", new Object[0]), MOStringHelper.translateToLocal("gui.redstone_mode.high", new Object[0]), MOStringHelper.translateToLocal("gui.redstone_mode.disabled", new Object[0])}, 0));
        this.addComponent(this.configs);
    }

    public abstract SoundEvent getSound();

    public abstract boolean hasSound();

    public abstract boolean getServerActive();

    public abstract float soundVolume();

    public boolean getRedstoneActive() {
        if (this.getRedstoneMode() == 1) {
            return this.redstoneState;
        }
        if (this.getRedstoneMode() == 0) {
            return !this.redstoneState;
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    protected void manageSound() {
        float soundVolume = this.soundVolume();
        if (this.hasSound() && soundVolume > 0.0f) {
            if (this.isActive() && !this.func_145837_r()) {
                if (this.sound == null) {
                    float soundMultiply = 1.0f;
                    if (this.func_145838_q() instanceof MOBlockMachine) {
                        soundMultiply = ((MOBlockMachine)this.func_145838_q()).volume;
                    }
                    if (soundMultiply > 0.0f) {
                        this.sound = new MachineSound(this.getSound(), SoundCategory.BLOCKS, this.func_174877_v(), this.soundVolume() * soundMultiply, 1.0f);
                        FMLClientHandler.instance().getClient().func_147118_V().func_147682_a((ISound)this.sound);
                    }
                } else if (FMLClientHandler.instance().getClient().func_147118_V().func_147692_c((ISound)this.sound)) {
                    this.sound.setVolume(this.soundVolume());
                } else {
                    this.sound = null;
                }
            } else if (this.sound != null) {
                this.stopSound();
            }
        } else if (this.hasSound() && soundVolume <= 0.0f) {
            this.stopSound();
        }
    }

    @SideOnly(value=Side.CLIENT)
    void stopSound() {
        if (this.sound != null) {
            this.sound.stopPlaying();
            FMLClientHandler.instance().getClient().func_147118_V().func_147683_b((ISound)this.sound);
            this.sound = null;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.field_145850_b.field_72995_K) {
            this.stopSound();
        }
        MachineEvent.Unload unload = new MachineEvent.Unload();
        this.onMachineEvent(unload);
        this.onMachineEventCompoments(unload);
    }

    @Override
    public void readCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            this.redstoneState = nbt.func_74767_n("redstoneState");
            this.activeState = nbt.func_74767_n("activeState");
            if (nbt.func_150297_b("Owner", 8) && !nbt.func_74779_i("Owner").isEmpty()) {
                try {
                    this.owner = UUID.fromString(nbt.func_74779_i("Owner"));
                }
                catch (Exception e) {
                    MOLog.log(Level.ERROR, "Invalid Owner ID: " + nbt.func_74779_i("Owner"), new Object[0]);
                }
            }
        }
        if (categories.contains((Object)MachineNBTCategory.INVENTORY)) {
            this.inventory.readFromNBT(nbt);
        }
        for (IMachineComponent component : this.components) {
            component.readFromNBT(nbt, categories);
        }
    }

    @Override
    public void writeCustomNBT(NBTTagCompound nbt, EnumSet<MachineNBTCategory> categories, boolean toDisk) {
        if (categories.contains((Object)MachineNBTCategory.DATA)) {
            nbt.func_74757_a("redstoneState", this.redstoneState);
            nbt.func_74757_a("activeState", this.activeState);
            if (toDisk) {
                if (this.owner != null) {
                    nbt.func_74778_a("Owner", this.owner.toString());
                } else if (nbt.func_150297_b("Owner", 6)) {
                    nbt.func_82580_o("Owner");
                }
            }
        }
        if (categories.contains((Object)MachineNBTCategory.INVENTORY)) {
            this.inventory.writeToNBT(nbt, toDisk);
        }
        for (IMachineComponent component : this.components) {
            component.writeToNBT(nbt, categories, toDisk);
        }
    }

    @Override
    public void writeToDropItem(ItemStack itemStack) {
        boolean saveTagFlag = false;
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound machineTag = new NBTTagCompound();
        NBTTagList itemTagList = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!this.inventory.getSlot(i).keepOnDismantle() || this.inventory.func_70301_a(i) == null) continue;
            NBTTagCompound itemTag = new NBTTagCompound();
            itemTag.func_74774_a("Slot", (byte)i);
            this.func_70301_a(i).func_77955_b(itemTag);
            itemTagList.func_74742_a((NBTBase)itemTag);
            saveTagFlag = true;
        }
        if (saveTagFlag) {
            machineTag.func_74782_a("Items", (NBTBase)itemTagList);
        }
        this.writeCustomNBT(machineTag, EnumSet.of(MachineNBTCategory.CONFIGS, MachineNBTCategory.DATA), true);
        if (this.hasOwner()) {
            machineTag.func_74778_a("Owner", this.owner.toString());
        }
        itemStack.func_77978_p().func_74782_a("Machine", (NBTBase)machineTag);
    }

    @Override
    public void readFromPlaceItem(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            NBTTagCompound machineTag = itemStack.func_77978_p().func_74775_l("Machine");
            NBTTagList itemTagList = machineTag.func_150295_c("Items", 10);
            for (int i = 0; i < itemTagList.func_74745_c(); ++i) {
                NBTTagCompound itemTag = itemTagList.func_150305_b(i);
                byte b0 = itemTag.func_74771_c("Slot");
                this.inventory.func_70299_a(b0, new ItemStack(itemTag));
            }
            this.readCustomNBT(machineTag, EnumSet.of(MachineNBTCategory.CONFIGS, MachineNBTCategory.DATA));
            if (machineTag.func_150297_b("Owner", 8)) {
                try {
                    this.owner = UUID.fromString(machineTag.func_74779_i("Owner"));
                }
                catch (Exception e) {
                    MOLog.log(Level.ERROR, e, "Invalid Owner ID: " + machineTag.func_74779_i("Owner"), new Object[0]);
                }
            }
        }
    }

    @Override
    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound syncData = new NBTTagCompound();
        this.writeCustomNBT(syncData, MachineNBTCategory.ALL_OPTS, false);
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, syncData);
    }

    @Override
    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound syncData = pkt.func_148857_g();
        if (syncData != null) {
            this.readCustomNBT(syncData, MachineNBTCategory.ALL_OPTS);
        }
    }

    protected void manageRedstoneState() {
        if (this.redstoneStateDirty) {
            boolean flag = this.redstoneState;
            this.redstoneState = false;
            for (int i = 0; i < EnumFacing.field_82609_l.length; ++i) {
                if (this.func_145831_w().func_175651_c(this.func_174877_v(), EnumFacing.field_82609_l[i]) <= 0) continue;
                this.redstoneState = true;
                break;
            }
            this.redstoneStateDirty = false;
            if (flag != this.redstoneState) {
                this.forceClientUpdate = true;
            }
        }
    }

    protected void manageClientSync() {
        if (this.forceClientUpdate) {
            this.forceClientUpdate = false;
            MatterOverdrive.NETWORK.sendToAllAround((IMessage)new PacketSendMachineNBT(MachineNBTCategory.ALL_OPTS, this, false, false), this, 64.0);
            this.func_70296_d();
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.field_145850_b.field_72995_K) {
            this.manageSound();
        }
    }

    protected abstract void onMachineEvent(MachineEvent var1);

    protected void onMachineEventCompoments(MachineEvent event) {
        for (IMachineComponent component : this.components) {
            component.onMachineEvent(event);
        }
    }

    @Override
    public void onNeighborBlockChange(IBlockAccess world, BlockPos pos, IBlockState state, Block neighborBlock) {
        MachineEvent.NeighborChange event = new MachineEvent.NeighborChange(world, pos, state, neighborBlock);
        this.onMachineEvent(event);
        this.onMachineEventCompoments(event);
        this.redstoneStateDirty = true;
    }

    @Override
    public void onDestroyed(World worldIn, BlockPos pos, IBlockState state) {
        MachineEvent.Destroyed event = new MachineEvent.Destroyed(worldIn, pos, state);
        this.onMachineEvent(event);
        this.onMachineEventCompoments(event);
    }

    @Override
    public void onPlaced(World world, EntityLivingBase entityLiving) {
        MachineEvent.Placed event = new MachineEvent.Placed(world, entityLiving);
        this.onMachineEvent(event);
        this.onMachineEventCompoments(event);
    }

    @Override
    public void onAdded(World world, BlockPos pos, IBlockState state) {
        MachineEvent.Added event = new MachineEvent.Added(world, pos, state);
        this.onMachineEvent(event);
        this.onMachineEventCompoments(event);
    }

    protected void onActiveChange() {
        MachineEvent.ActiveChange event = new MachineEvent.ActiveChange();
        this.onMachineEvent(event);
        this.onMachineEventCompoments(event);
    }

    @Override
    protected void onAwake(Side side) {
        MachineEvent.Awake machineEvent = new MachineEvent.Awake(side);
        this.onMachineEvent(machineEvent);
        this.onMachineEventCompoments(machineEvent);
    }

    public void onContainerOpen(Side side) {
        MachineEvent.OpenContainer event = new MachineEvent.OpenContainer(side);
        this.onMachineEvent(event);
        this.onMachineEventCompoments(event);
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return this.getInventory() != null && this.getInventory().func_94041_b(slot, item);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }

    public int func_70302_i_() {
        if (this.getInventory() != null) {
            return this.getInventory().func_70302_i_();
        }
        return 0;
    }

    @Nonnull
    public ItemStack func_70301_a(int slot) {
        if (this.getInventory() != null) {
            return this.getInventory().func_70301_a(slot);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70298_a(int slot, int size) {
        if (this.getInventory() != null) {
            return this.getInventory().func_70298_a(slot, size);
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        if (this.getInventory() != null) {
            return this.getInventory().func_70304_b(index);
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int slot, ItemStack itemStack) {
        if (this.getInventory() != null) {
            this.getInventory().func_70299_a(slot, itemStack);
        }
    }

    public ITextComponent func_145748_c_() {
        if (this.getInventory() != null && this.getInventory().func_145748_c_() != null) {
            return this.getInventory().func_145748_c_();
        }
        if (this.func_145838_q() != null) {
            return new TextComponentString(this.func_145838_q().func_149732_F());
        }
        return new TextComponentString("");
    }

    public int func_70297_j_() {
        if (this.getInventory() != null) {
            return this.getInventory().func_70297_j_();
        }
        return 0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.hasOwner()) {
            if (player.func_146103_bH().getId().equals(this.owner) || player.field_71075_bZ.field_75098_d) {
                return true;
            }
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                ItemStack itemStack = player.field_71071_by.func_70301_a(i);
                if (itemStack.func_190926_b() || !(itemStack.func_77973_b() instanceof SecurityProtocol) || !itemStack.func_77942_o() || itemStack.func_77952_i() != 2 || !UUID.fromString(itemStack.func_77978_p().func_74779_i("Owner")).equals(this.owner)) continue;
                return true;
            }
        } else {
            return true;
        }
        return false;
    }

    public void func_174889_b(EntityPlayer player) {
        if (this.getInventory() != null) {
            this.getInventory().func_174889_b(player);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (this.getInventory() != null) {
            this.getInventory().func_174886_c(player);
        }
    }

    public IInventory getInventory() {
        return this.inventory;
    }

    public Inventory getInventoryContainer() {
        return this.inventory;
    }

    public String func_70005_c_() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void addWatcher(IMachineWatcher watcher) {
        if (!this.watchers.contains(watcher)) {
            this.watchers.add(watcher);
            watcher.onWatcherAdded(this);
        }
    }

    public void removeWatcher(IMachineWatcher watcher) {
        this.watchers.remove(watcher);
    }

    public void forceSync() {
        this.forceClientUpdate = true;
    }

    @SideOnly(value=Side.CLIENT)
    public void sendConfigsToServer(boolean forceUpdate) {
        this.sendNBTToServer(EnumSet.of(MachineNBTCategory.CONFIGS), forceUpdate, true);
    }

    public double getUpgradeMultiply(UpgradeTypes type) {
        double multiply = 1.0;
        if (this.isAffectedByUpgrade(type)) {
            for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
                Map<UpgradeTypes, Double> upgrades;
                ItemStack upgradeItem;
                if (!(this.inventory.getSlot(i) instanceof UpgradeSlot) || (upgradeItem = this.inventory.func_70301_a(i)).func_190926_b() || !MatterHelper.isUpgrade(upgradeItem) || !(upgrades = ((IUpgrade)upgradeItem.func_77973_b()).getUpgrades(upgradeItem)).containsKey((Object)type)) continue;
                multiply *= upgrades.get((Object)type).doubleValue();
            }
            if (this.getUpgradeHandler() != null) {
                multiply = this.getUpgradeHandler().affectUpgrade(type, multiply);
            }
        }
        if (multiply == 0.0) {
            return 1.0;
        }
        return multiply;
    }

    @SideOnly(value=Side.CLIENT)
    public void SpawnVentParticles(float speed, EnumFacing side, int count) {
        for (int i = 0; i < count; ++i) {
            Matrix4f rotation = new Matrix4f();
            Vector3f offset = new Vector3f();
            if (side == EnumFacing.UP) {
                rotation.rotate(1.5707964f, new Vector3f(0.0f, 0.0f, 1.0f));
                offset = new Vector3f(0.5f, 0.7f, 0.5f);
            } else if (side == EnumFacing.WEST) {
                rotation.rotate(1.5707964f, new Vector3f(0.0f, 0.0f, 1.0f));
                offset = new Vector3f(-0.2f, 0.5f, 0.5f);
            } else if (side == EnumFacing.EAST) {
                rotation.rotate(1.5707964f, new Vector3f(0.0f, 0.0f, -1.0f));
                offset = new Vector3f(1.2f, 0.5f, 0.5f);
            } else if (side == EnumFacing.SOUTH) {
                rotation.rotate(1.5707964f, new Vector3f(1.0f, 0.0f, 0.0f));
                offset = new Vector3f(0.5f, 0.5f, 1.2f);
            } else if (side == EnumFacing.NORTH) {
                rotation.rotate(1.5707964f, new Vector3f(-1.0f, 0.0f, 0.0f));
                offset = new Vector3f(0.5f, 0.5f, -0.2f);
            }
            Vector3f circle = MOMathHelper.randomCirclePoint(random.nextFloat(), random);
            circle.scale(0.4f);
            Vector4f circleTransformed = new Vector4f(circle.x, circle.y, circle.z, 1.0f);
            Matrix4f.transform((Matrix4f)rotation, (Vector4f)circleTransformed, (Vector4f)circleTransformed);
            float scale = 3.0f;
            VentParticle ventParticle = new VentParticle(this.field_145850_b, (float)this.func_174877_v().func_177958_n() + offset.x + circleTransformed.x, (float)this.func_174877_v().func_177956_o() + offset.y + circleTransformed.y, (float)this.func_174877_v().func_177952_p() + offset.z + circleTransformed.z, (float)side.func_176730_m().func_177958_n() * speed, (float)side.func_176730_m().func_177956_o() * speed, (float)side.func_176730_m().func_177952_p() * speed, scale);
            ventParticle.func_82338_g(0.05f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)ventParticle);
        }
    }

    public <T extends MOBlock> T getBlockType(Class<T> type) {
        if (this.field_145854_h == null) {
            this.field_145854_h = this.field_145850_b.func_180495_p(this.func_174877_v()).func_177230_c();
        }
        if (type.isInstance(this.field_145854_h)) {
            return (T)((MOBlock)type.cast(this.field_145854_h));
        }
        return null;
    }

    public int getRedstoneMode() {
        return this.getConfigs().getEnum("redstoneMode", 0);
    }

    public UUID getOwner() {
        return this.owner;
    }

    public boolean hasOwner() {
        return this.owner != null;
    }

    public boolean claim(ItemStack security_protocol) {
        try {
            if (this.owner == null && security_protocol.func_77942_o() && security_protocol.func_77978_p().func_150297_b("Owner", 8)) {
                this.owner = UUID.fromString(security_protocol.func_77978_p().func_74779_i("Owner"));
                this.forceSync();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public boolean unclaim(ItemStack security_protocol) {
        try {
            if (this.owner != null && security_protocol.func_77942_o() && security_protocol.func_77978_p().func_150297_b("Owner", 8) && this.owner.equals(UUID.fromString(security_protocol.func_77978_p().func_74779_i("Owner")))) {
                this.owner = null;
                this.forceSync();
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void addComponent(IMachineComponent component) {
        this.components.add(component);
    }

    public boolean removeComponent(IMachineComponent component) {
        return this.components.remove(component);
    }

    public IMachineComponent removeComponent(int index) {
        return this.components.remove(index);
    }

    public IMachineComponent getComponent(int index) {
        return this.components.get(index);
    }

    public <C extends IMachineComponent> C getComponent(Class<C> componentClasss) {
        for (IMachineComponent component : this.components) {
            if (!componentClasss.isInstance(component)) continue;
            return (C)((IMachineComponent)componentClasss.cast(component));
        }
        return null;
    }

    public boolean hasPlayerSlotsHotbar() {
        return this.playerSlotsHotbar;
    }

    public boolean hasPlayerSlotsMain() {
        return this.playerSlotsMain;
    }

    public float getProgress() {
        return 0.0f;
    }

    public boolean isActive() {
        return this.activeState;
    }

    public void setActive(boolean active) {
        this.activeState = active;
    }

    public ComponentConfigs getConfigs() {
        return this.configs;
    }

    @Override
    public IUpgradeHandler getUpgradeHandler() {
        return basicUpgradeHandler;
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        return false;
    }

    public List<IMachineWatcher> getWatchers() {
        return this.watchers;
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == null) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inventoryHandler);
            }
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.sidedWrappers[facing.ordinal()]);
        }
        return (T)super.getCapability(capability, facing);
    }
}

