/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.weapon;

import java.util.List;
import javax.annotation.Nonnull;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.api.weapon.WeaponStats;
import matteroverdrive.client.data.Color;
import matteroverdrive.client.sound.MOPositionedSound;
import matteroverdrive.client.sound.WeaponSound;
import matteroverdrive.entity.weapon.PlasmaBolt;
import matteroverdrive.fx.PhaserBoltRecoil;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.network.packet.server.PacketDigBlock;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.StackUtils;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.vector.Vector2f;

public class OmniTool
extends EnergyWeapon {
    public static final int RANGE = 24;
    private static final int MAX_USE_TIME = 240;
    private static final int ENERGY_PER_SHOT = 512;
    private static final float DIG_POWER_MULTIPLY = 0.03f;
    private static float BLOCK_DAMAGE;
    private static float STEP_SOUND_COUNTER;
    private static float LAST_BRAKE_TIME;
    private static BlockPos CURRENT_BLOCK;
    private static EnumFacing LAST_SIDE;

    public OmniTool(String name) {
        super(name, 24);
        this.setHarvestLevel("pickaxe", 5);
        this.setHarvestLevel("axe", 5);
        this.setHarvestLevel("shovel", 5);
        this.field_77789_bW = true;
        this.leftClickFire = true;
    }

    @Override
    protected int getCapacity() {
        return 32000;
    }

    @Override
    protected int getInput() {
        return 128;
    }

    @Override
    protected int getOutput() {
        return 128;
    }

    public int func_77626_a(ItemStack item) {
        return 240;
    }

    @Override
    public int func_77619_b() {
        return 1;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (hand == EnumHand.OFF_HAND) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        this.TagCompountCheck(stack);
        if (this.canDig(stack, world)) {
            player.func_184598_c(hand);
            if (world.field_72995_K) {
                this.stopMiningLastBlock(player, world);
            }
        }
        if (this.needsRecharge(stack) && world.field_72995_K) {
            this.chargeFromEnergyPack(stack, player);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase player, int count) {
        if (player.field_70170_p.field_72995_K && player.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            if (this.canDig(stack, player.field_70170_p)) {
                RayTraceResult hit = player.func_174822_a((double)this.getRange(stack), 1.0f);
                if (hit != null && hit.field_72313_a == RayTraceResult.Type.BLOCK) {
                    IBlockState state = player.field_70170_p.func_180495_p(hit.func_178782_a());
                    boolean canMine = ((EntityPlayer)player).field_71075_bZ.field_75099_e;
                    if (!state.func_177230_c().isAir(state, (IBlockAccess)player.field_70170_p, hit.func_178782_a()) && canMine) {
                        STEP_SOUND_COUNTER += 1.0f;
                        LAST_SIDE = hit.field_178784_b;
                        if (this.isSameBlock(hit.func_178782_a())) {
                            if (BLOCK_DAMAGE >= 1.0f) {
                                MatterOverdrive.NETWORK.sendToServer(new PacketDigBlock(hit.func_178782_a(), PacketDigBlock.Type.HARVEST, hit.field_178784_b));
                                Minecraft.func_71410_x().field_71442_b.func_187103_a(hit.func_178782_a());
                                BLOCK_DAMAGE = 0.0f;
                                STEP_SOUND_COUNTER = 0.0f;
                            } else if (BLOCK_DAMAGE == 0.0f) {
                                MatterOverdrive.NETWORK.sendToServer(new PacketDigBlock(hit.func_178782_a(), PacketDigBlock.Type.CLICK, hit.field_178784_b));
                            }
                            BLOCK_DAMAGE = MathHelper.func_76131_a((float)this.modifyStatFromModules(WeaponStats.BLOCK_DAMAGE, stack, (BLOCK_DAMAGE + state.func_185903_a((EntityPlayer)player, player.field_70170_p, hit.func_178782_a())) * 2.0f), (float)0.0f, (float)1.0f);
                            player.field_70170_p.func_175715_c(player.func_145782_y(), hit.func_178782_a(), (int)(BLOCK_DAMAGE * 10.0f));
                        } else {
                            this.stopMiningLastBlock((EntityPlayer)player, player.field_70170_p);
                            this.setLastBlock(hit.func_178782_a());
                        }
                    }
                }
            } else {
                player.func_184597_cx();
            }
        } else {
            this.DrainEnergy(stack, 0.03f, false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private boolean isSameBlock(BlockPos pos) {
        return CURRENT_BLOCK != null && CURRENT_BLOCK.equals((Object)pos);
    }

    @SideOnly(value=Side.CLIENT)
    private void setLastBlock(BlockPos pos) {
        CURRENT_BLOCK = pos;
    }

    public void func_77615_a(ItemStack stack, World world, EntityLivingBase entity, int timeLeft) {
        super.func_77615_a(stack, world, entity, timeLeft);
        if (world.field_72995_K && entity instanceof EntityPlayer) {
            this.stopMiningLastBlock((EntityPlayer)entity, world);
        } else {
            int n = this.func_77626_a(stack) - timeLeft;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void stopMiningLastBlock(EntityPlayer player, World world) {
        if (CURRENT_BLOCK != null) {
            BLOCK_DAMAGE = 0.0f;
            STEP_SOUND_COUNTER = 0.0f;
            MatterOverdrive.NETWORK.sendToServer(new PacketDigBlock(CURRENT_BLOCK, PacketDigBlock.Type.CANCEL, LAST_SIDE));
            world.func_175715_c(player.func_145782_y(), CURRENT_BLOCK, -1);
        }
    }

    public boolean func_179218_a(ItemStack p_onBlockDestroyed_1_, World p_onBlockDestroyed_2_, IBlockState p_onBlockDestroyed_3_, BlockPos p_onBlockDestroyed_4_, EntityLivingBase p_onBlockDestroyed_5_) {
        return super.func_179218_a(p_onBlockDestroyed_1_, p_onBlockDestroyed_2_, p_onBlockDestroyed_3_, p_onBlockDestroyed_4_, p_onBlockDestroyed_5_);
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        return EnumActionResult.FAIL;
    }

    @Override
    public PlasmaBolt getDefaultProjectile(ItemStack weapon, EntityLivingBase shooter, Vec3d position, Vec3d dir, WeaponShot shot) {
        PlasmaBolt bolt = super.getDefaultProjectile(weapon, shooter, position, dir, shot);
        bolt.setKnockBack(0.05f);
        return bolt;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientShot(ItemStack weapon, EntityLivingBase shooter, Vec3d position, Vec3d dir, WeaponShot shot) {
        MOPositionedSound sound = new MOPositionedSound(MatterOverdriveSounds.weaponsLaserFire, SoundCategory.PLAYERS, 0.5f + field_77697_d.nextFloat() * 0.2f, 1.2f + field_77697_d.nextFloat() * 0.2f);
        sound.setPosition((float)position.field_72450_a, (float)position.field_72448_b, (float)position.field_72449_c);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        this.spawnProjectile(weapon, shooter, position, dir, shot);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onProjectileHit(RayTraceResult hit, ItemStack weapon, World world, float amount) {
        if (hit.field_72313_a == RayTraceResult.Type.BLOCK && amount == 1.0f && field_77697_d.nextFloat() < 0.8f) {
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new PhaserBoltRecoil(world, hit.field_72307_f.field_72450_a, hit.field_72307_f.field_72448_b, hit.field_72307_f.field_72449_c, new Color(255, 255, 255)));
        }
    }

    @Override
    public float getWeaponBaseAccuracy(ItemStack weapon, boolean zoomed) {
        return 0.3f + this.getHeat(weapon) / this.getMaxHeat(weapon) * 5.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addCustomDetails(ItemStack weapon, EntityPlayer player, List infos) {
    }

    @Override
    protected int getBaseEnergyUse(ItemStack item) {
        return 512 / this.getShootCooldown(item);
    }

    @Override
    protected int getBaseMaxHeat(ItemStack item) {
        return 80;
    }

    @Override
    public float getWeaponBaseDamage(ItemStack weapon) {
        return 7.0f;
    }

    @Override
    public boolean canFire(ItemStack itemStack, World world, EntityLivingBase shooter) {
        return !this.isOverheated(itemStack) && this.DrainEnergy(itemStack, this.getShootCooldown(itemStack), true) && !this.isEntitySpectator(shooter);
    }

    @Override
    public float getShotSpeed(ItemStack weapon, EntityLivingBase shooter) {
        return 3.0f;
    }

    public boolean canDig(ItemStack itemStack, World world) {
        return !this.isOverheated(itemStack) && this.DrainEnergy(itemStack, 0.03f, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getSlotPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(170.0f, 115.0f);
            }
            case 1: {
                return new Vector2f(80.0f, 40.0f);
            }
            case 2: {
                return new Vector2f(60.0f, 115.0f);
            }
        }
        return new Vector2f(200.0f, (float)(60 + (slot - 4) * 22));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getModuleScreenPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(173.0f, 90.0f);
            }
            case 1: {
                return new Vector2f(125.0f, 72.0f);
            }
            case 2: {
                return new Vector2f(85.0f, 105.0f);
            }
        }
        return this.getSlotPosition(slot, weapon);
    }

    @Override
    public boolean supportsModule(int slot, ItemStack weapon) {
        return slot != 3;
    }

    @Override
    public boolean supportsModule(ItemStack weapon, ItemStack module) {
        return !StackUtils.isNullOrEmpty(module) && !StackUtils.isNullOrEmpty(weapon) && (module.func_77973_b() == MatterOverdrive.ITEMS.weapon_module_color || module.func_77973_b() == MatterOverdrive.ITEMS.weapon_module_barrel && module.func_77952_i() == 5);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onShooterClientUpdate(ItemStack itemStack, World world, EntityPlayer entityPlayer, boolean sendServerTick) {
        if (Mouse.isButtonDown((int)0) && this.hasShootDelayPassed()) {
            if (this.canFire(itemStack, world, (EntityLivingBase)entityPlayer)) {
                if (!itemStack.func_77942_o()) {
                    itemStack.func_77982_d(new NBTTagCompound());
                }
                itemStack.func_77978_p().func_74772_a("LastShot", world.func_82737_E());
                Vec3d dir = entityPlayer.func_70676_i(1.0f);
                Vec3d pos = this.getFirePosition(entityPlayer, dir, Mouse.isButtonDown((int)1));
                WeaponShot shot = this.createClientShot(itemStack, (EntityLivingBase)entityPlayer, Mouse.isButtonDown((int)1));
                this.onClientShot(itemStack, (EntityLivingBase)entityPlayer, pos, dir, shot);
                this.addShootDelay(itemStack);
                this.sendShootTickToServer(world, shot, dir, pos);
                if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    ClientProxy.instance().getClientWeaponHandler().setRecoil(6.0f + this.getAccuracy(itemStack, (EntityLivingBase)entityPlayer, this.isWeaponZoomed((EntityLivingBase)entityPlayer, itemStack)) * 2.0f, 1.0f, 0.05f);
                    ClientProxy.instance().getClientWeaponHandler().setCameraRecoil(1.0f + this.getAccuracy(itemStack, (EntityLivingBase)entityPlayer, true) * 0.08f, 1.0f);
                }
                return;
            }
            if (this.needsRecharge(itemStack)) {
                this.chargeFromEnergyPack(itemStack, entityPlayer);
            }
        }
        super.onShooterClientUpdate(itemStack, world, entityPlayer, sendServerTick);
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3d getFirePosition(EntityPlayer entityPlayer, Vec3d dir, boolean isAiming) {
        Vec3d pos = entityPlayer.func_174824_e(1.0f);
        pos = pos.func_178786_a((double)(MathHelper.func_76134_b((float)(entityPlayer.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f), 0.0, (double)(MathHelper.func_76134_b((float)(entityPlayer.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f));
        pos = pos.func_72441_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
        return pos;
    }

    @Override
    public boolean onServerFire(ItemStack weapon, EntityLivingBase shooter, WeaponShot shot, Vec3d position, Vec3d dir, int delay) {
        this.DrainEnergy(weapon, this.getShootCooldown(weapon), false);
        float newHeat = (this.getHeat(weapon) + 4.0f) * 2.7f;
        this.setHeat(weapon, newHeat);
        this.manageOverheat(weapon, shooter.field_70170_p, shooter);
        PlasmaBolt fire = this.spawnProjectile(weapon, shooter, position, dir, shot);
        fire.simulateDelay(delay);
        weapon.func_77978_p().func_74772_a("LastShot", shooter.field_70170_p.func_82737_E());
        return true;
    }

    @Override
    public boolean isAlwaysEquipped(ItemStack weapon) {
        return false;
    }

    @Override
    public int getBaseShootCooldown(ItemStack itemStack) {
        return 18;
    }

    @Override
    public float getBaseZoom(ItemStack weapon, EntityLivingBase shooter) {
        return 0.0f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isWeaponZoomed(EntityLivingBase entityPlayer, ItemStack weapon) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public WeaponSound getFireSound(ItemStack weapon, EntityLivingBase entity) {
        return new WeaponSound(MatterOverdriveSounds.weaponsOmniToolHum, SoundCategory.PLAYERS, (float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v, field_77697_d.nextFloat() * 0.04f + 0.06f, field_77697_d.nextFloat() * 0.1f + 0.95f);
    }
}

