/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.weapon;

import java.util.List;
import matteroverdrive.api.weapon.IWeaponModule;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.client.sound.MOPositionedSound;
import matteroverdrive.client.sound.WeaponSound;
import matteroverdrive.entity.weapon.PlasmaBolt;
import matteroverdrive.init.MatterOverdriveSounds;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.proxy.ClientProxy;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Mouse;
import org.lwjgl.util.vector.Vector2f;

public class IonSniper
extends EnergyWeapon {
    public static final int RANGE = 96;
    private static final int MAX_HEAT = 100;
    private static final int MAX_USE_TIME = 512;
    private static final int ENERGY_PER_SHOT = 3072;

    public IonSniper(String name) {
        super(name, 96);
        this.func_77664_n();
        this.leftClickFire = true;
    }

    @Override
    protected int getCapacity() {
        return 32000;
    }

    @Override
    protected int getInput() {
        return 128;
    }

    @Override
    protected int getOutput() {
        return 128;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    protected void addCustomDetails(ItemStack weapon, EntityPlayer player, List infos) {
    }

    @Override
    public int getBaseEnergyUse(ItemStack item) {
        return 3072 / this.getShootCooldown(item);
    }

    @Override
    protected int getBaseMaxHeat(ItemStack item) {
        return 100;
    }

    @Override
    public float getWeaponBaseDamage(ItemStack weapon) {
        return 21.0f;
    }

    @Override
    public float getWeaponBaseAccuracy(ItemStack weapon, boolean zoomed) {
        if (zoomed) {
            return 1.0f + this.getHeat(weapon) * 0.1f;
        }
        return 5.0f + this.getHeat(weapon) * 0.3f;
    }

    @Override
    public boolean canFire(ItemStack weapon, World world, EntityLivingBase shooter) {
        return this.DrainEnergy(weapon, this.getShootCooldown(weapon), true) && !this.isOverheated(weapon) && !this.isEntitySpectator(shooter);
    }

    @Override
    public float getShotSpeed(ItemStack weapon, EntityLivingBase shooter) {
        return 8.0f;
    }

    @Override
    public int getBaseShootCooldown(ItemStack weapon) {
        return 30;
    }

    @Override
    public float getBaseZoom(ItemStack weapon, EntityLivingBase shooter) {
        return 0.4f;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onShooterClientUpdate(ItemStack itemStack, World world, EntityPlayer entityPlayer, boolean sendServerTick) {
        if (Mouse.isButtonDown((int)0) && this.hasShootDelayPassed()) {
            if (this.canFire(itemStack, world, (EntityLivingBase)entityPlayer)) {
                Vec3d dir = entityPlayer.func_70676_i(1.0f);
                Vec3d pos = this.getFirePosition(entityPlayer, dir, this.isWeaponZoomed((EntityLivingBase)entityPlayer, itemStack));
                WeaponShot shot = this.createClientShot(itemStack, (EntityLivingBase)entityPlayer, this.isWeaponZoomed((EntityLivingBase)entityPlayer, itemStack));
                this.onClientShot(itemStack, (EntityLivingBase)entityPlayer, pos, dir, shot);
                this.addShootDelay(itemStack);
                this.sendShootTickToServer(world, shot, dir, pos);
                if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 0) {
                    if (this.isWeaponZoomed((EntityLivingBase)entityPlayer, itemStack)) {
                        ClientProxy.instance().getClientWeaponHandler().setRecoil(2.0f + Math.min(2.0f, this.getAccuracy(itemStack, (EntityLivingBase)entityPlayer, true)), 1.0f, 0.5f);
                        ClientProxy.instance().getClientWeaponHandler().setCameraRecoil(3.0f + this.getHeat(itemStack) / this.getMaxHeat(itemStack) * 3.0f, 1.0f);
                    } else {
                        ClientProxy.instance().getClientWeaponHandler().setRecoil(4.0f + Math.min(2.0f, this.getAccuracy(itemStack, (EntityLivingBase)entityPlayer, true)), 1.0f, 1.0f);
                        ClientProxy.instance().getClientWeaponHandler().setCameraRecoil(4.0f + this.getHeat(itemStack) / this.getMaxHeat(itemStack) * 4.0f, 1.0f);
                    }
                }
                return;
            }
            if (this.needsRecharge(itemStack)) {
                this.chargeFromEnergyPack(itemStack, entityPlayer);
            }
        }
        super.onShooterClientUpdate(itemStack, world, entityPlayer, sendServerTick);
    }

    @SideOnly(value=Side.CLIENT)
    private Vec3d getFirePosition(EntityPlayer entityPlayer, Vec3d dir, boolean isAiming) {
        Vec3d pos = entityPlayer.func_174824_e(1.0f);
        if (!isAiming) {
            pos = pos.func_178786_a((double)(MathHelper.func_76134_b((float)(entityPlayer.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f), 0.0, (double)(MathHelper.func_76126_a((float)(entityPlayer.field_70177_z / 180.0f * (float)Math.PI)) * 0.16f));
        }
        pos = pos.func_72441_c(dir.field_72450_a, dir.field_72448_b, dir.field_72449_c);
        return pos;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onClientShot(ItemStack weapon, EntityLivingBase shooter, Vec3d position, Vec3d dir, WeaponShot shot) {
        MOPositionedSound sound = new MOPositionedSound(MatterOverdriveSounds.weaponsSniperRifleFire, SoundCategory.PLAYERS, 3.0f + field_77697_d.nextFloat() * 0.5f, 0.9f + field_77697_d.nextFloat() * 0.2f);
        sound.setPosition((float)position.field_72450_a, (float)position.field_72448_b, (float)position.field_72449_c);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)sound);
        this.spawnProjectile(weapon, shooter, position, dir, shot);
    }

    @Override
    public void onProjectileHit(RayTraceResult hit, ItemStack weapon, World world, float amount) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getSlotPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(170.0f, 115.0f);
            }
            case 1: {
                return new Vector2f(60.0f, 45.0f);
            }
            case 2: {
                return new Vector2f(60.0f, 115.0f);
            }
            case 3: {
                return new Vector2f(150.0f, 35.0f);
            }
        }
        return new Vector2f(205.0f, (float)(80 + (slot - 4) * 22));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public Vector2f getModuleScreenPosition(int slot, ItemStack weapon) {
        switch (slot) {
            case 0: {
                return new Vector2f(165.0f, 80.0f);
            }
            case 1: {
                return new Vector2f(110.0f, 90.0f);
            }
            case 2: {
                return new Vector2f(90.0f, 95.0f);
            }
            case 3: {
                return new Vector2f(150.0f, 72.0f);
            }
        }
        return this.getSlotPosition(slot, weapon);
    }

    @Override
    public PlasmaBolt getDefaultProjectile(ItemStack weapon, EntityLivingBase shooter, Vec3d position, Vec3d dir, WeaponShot shot) {
        PlasmaBolt bolt = super.getDefaultProjectile(weapon, shooter, position, dir, shot);
        bolt.setKnockBack(1.0f);
        return bolt;
    }

    @Override
    public EnumAction func_77661_b(ItemStack itemStack) {
        return itemStack.func_77952_i() == 1 ? EnumAction.BOW : EnumAction.NONE;
    }

    public int func_77626_a(ItemStack item) {
        return 512;
    }

    @Override
    public boolean supportsModule(int slot, ItemStack weapon) {
        return true;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (hand == EnumHand.OFF_HAND) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)stack);
        }
        playerIn.func_184598_c(hand);
        if (worldIn.field_72995_K) {
            for (int i = 0; i < 3; ++i) {
                Minecraft.func_71410_x().field_71460_t.field_78516_c.func_78441_a();
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public boolean supportsModule(ItemStack weapon, ItemStack module) {
        return module.func_190926_b() || !(module.func_77973_b() instanceof IWeaponModule) || ((IWeaponModule)module.func_77973_b()).getSlot(module) != 2 || module.func_77952_i() != 3;
    }

    @Override
    public boolean onServerFire(ItemStack weapon, EntityLivingBase shooter, WeaponShot shot, Vec3d position, Vec3d dir, int delay) {
        this.DrainEnergy(weapon, this.getShootCooldown(weapon), false);
        float newHeat = this.getHeat(weapon) + this.getMaxHeat(weapon) * 0.8f;
        this.setHeat(weapon, newHeat);
        this.manageOverheat(weapon, shooter.field_70170_p, shooter);
        PlasmaBolt fire = this.spawnProjectile(weapon, shooter, position, dir, shot);
        fire.simulateDelay(delay);
        return true;
    }

    @Override
    public boolean isAlwaysEquipped(ItemStack weapon) {
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isWeaponZoomed(EntityLivingBase entityPlayer, ItemStack weapon) {
        return Mouse.isButtonDown((int)1) && entityPlayer.func_184587_cr() && entityPlayer.func_184600_cs() == EnumHand.MAIN_HAND;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public WeaponSound getFireSound(ItemStack weapon, EntityLivingBase entity) {
        return null;
    }
}

