/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items.includes;

import java.util.List;
import javax.annotation.Nullable;
import matteroverdrive.api.inventory.IUpgrade;
import matteroverdrive.util.MOEnergyHelper;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.MatterHelper;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class MOMachineBlockItem
extends ItemBlock {
    public MOMachineBlockItem(Block block) {
        super(block);
        this.setRegistryName(block.getRegistryName());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> infos, ITooltipFlag flagIn) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            if (MOStringHelper.hasTranslation(this.func_77658_a() + ".details")) {
                infos.add(TextFormatting.GRAY + MOStringHelper.translateToLocal(this.func_77658_a() + ".details", new Object[0]));
            }
            if (stack.func_77942_o()) {
                if (stack.func_77978_p().func_74764_b("Energy") && stack.func_77978_p().func_74764_b("MaxEnergy")) {
                    infos.add(TextFormatting.YELLOW + MOEnergyHelper.formatEnergy(stack.func_77978_p().func_74762_e("Energy"), (long)stack.func_77978_p().func_74762_e("MaxEnergy")));
                    if (stack.func_77978_p().func_74764_b("PowerSend") && stack.func_77978_p().func_74764_b("PowerReceive")) {
                        infos.add("Send/Receive: " + MOStringHelper.formatNumber(stack.func_77978_p().func_74762_e("PowerSend")) + "/" + MOStringHelper.formatNumber(stack.func_77978_p().func_74762_e("PowerReceive")) + MOEnergyHelper.ENERGY_UNIT + "/t");
                    }
                }
                if (stack.func_77978_p().func_74764_b("Matter") && stack.func_77978_p().func_74764_b("MaxMatter")) {
                    infos.add(TextFormatting.BLUE + MatterHelper.formatMatter(stack.func_77978_p().func_74762_e("Matter"), stack.func_77978_p().func_74762_e("MaxMatter")));
                    if (stack.func_77978_p().func_74764_b("MatterSend") && stack.func_77978_p().func_74764_b("MatterReceive")) {
                        infos.add(TextFormatting.DARK_BLUE + "Send/Receive: " + MOStringHelper.formatNumber(stack.func_77978_p().func_74762_e("MatterSend")) + "/" + MOStringHelper.formatNumber(stack.func_77978_p().func_74762_e("MatterReceive")) + " kM" + "/t");
                    }
                }
                this.showItems(stack, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, infos);
            }
        } else {
            infos.add(MOStringHelper.MORE_INFO);
        }
    }

    public String func_77653_i(ItemStack itemStack) {
        if (itemStack.func_77942_o()) {
            return super.func_77653_i(itemStack) + String.format(TextFormatting.AQUA + " [%s]" + TextFormatting.RESET, MOStringHelper.translateToLocal("item.info.configured", new Object[0]));
        }
        return super.func_77653_i(itemStack);
    }

    public int getDamage(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Energy") && stack.func_77978_p().func_74764_b("MaxEnergy")) {
            return stack.func_77978_p().func_74762_e("MaxEnergy") - stack.func_77978_p().func_74762_e("Energy") + 1;
        }
        return 0;
    }

    public int getMaxDamage(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("MaxEnergy")) {
            return stack.func_77978_p().func_74762_e("MaxEnergy");
        }
        return 0;
    }

    private void showItems(ItemStack itemStack, EntityPlayer player, List<String> infos) {
        NBTTagList stackTagList = itemStack.func_77978_p().func_74775_l("Machine").func_150295_c("Items", 10);
        if (stackTagList.func_74745_c() > 0) {
            infos.add("");
            infos.add(TextFormatting.YELLOW + "Inventory:");
            for (int i = 0; i < stackTagList.func_74745_c(); ++i) {
                ItemStack stack = new ItemStack(stackTagList.func_150305_b(i));
                if (stack.func_77973_b() instanceof IUpgrade) {
                    infos.add("   " + TextFormatting.GREEN + stack.func_82833_r());
                    continue;
                }
                infos.add("   " + infos.add(stack.func_82833_r()));
            }
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return this.getDamage(stack) > 0;
    }
}

