/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import java.text.DecimalFormat;
import java.util.List;
import javax.annotation.Nullable;
import matteroverdrive.init.OverdriveFluids;
import matteroverdrive.items.includes.EnergyContainer;
import matteroverdrive.items.includes.MOItemEnergyContainer;
import matteroverdrive.util.MatterHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PortableDecomposer
extends MOItemEnergyContainer {
    private int defaultMatter;
    private float defaultMatterRatio;

    public PortableDecomposer(String name, int defaultMatter, float defaultMatterRatio) {
        super(name);
        this.defaultMatter = defaultMatter;
        this.defaultMatterRatio = defaultMatterRatio;
    }

    @Override
    protected int getCapacity() {
        return 128000;
    }

    @Override
    protected int getInput() {
        return 256;
    }

    @Override
    protected int getOutput() {
        return 256;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetails(ItemStack itemstack, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        infos.add(String.format("%s/%s %s", DecimalFormat.getIntegerInstance().format(this.getMatter(itemstack)), Float.valueOf(this.getMaxMatter(itemstack)), " kM"));
        if (itemstack.func_77978_p() != null) {
            NBTTagList list = itemstack.func_77978_p().func_150295_c("Items", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                ItemStack s = new ItemStack(list.func_150305_b(i));
                infos.add(TextFormatting.GRAY + s.func_82833_r());
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (te != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing)) {
            IFluidHandler handler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, facing);
            FluidStack fluid = new FluidStack((Fluid)OverdriveFluids.matterPlasma, this.getMatter(stack));
            int filled = handler.fill(fluid, true);
            this.setMatter(stack, Math.max(0, fluid.amount - filled));
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public int getMatter(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null) {
            return itemStack.func_77978_p().func_74762_e("Matter");
        }
        return 0;
    }

    public void setMatter(ItemStack itemStack, float matter) {
        if (itemStack.func_77978_p() == null) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        itemStack.func_77978_p().func_74776_a("Matter", matter);
    }

    public float getMaxMatter(ItemStack itemStack) {
        if (itemStack.func_77978_p() != null && itemStack.func_77978_p().func_74764_b("MaxMatter")) {
            return itemStack.func_77978_p().func_74760_g("MaxMatter");
        }
        return this.defaultMatter;
    }

    public boolean isStackListed(ItemStack decomposer, ItemStack itemStack) {
        if (decomposer.func_77978_p() != null && MatterHelper.containsMatter(itemStack)) {
            NBTTagList stackList = decomposer.func_77978_p().func_150295_c("Items", 10);
            for (int i = 0; i < stackList.func_74745_c(); ++i) {
                ItemStack s = new ItemStack(stackList.func_150305_b(i));
                if (!s.func_77969_a(itemStack) || !ItemStack.func_77970_a((ItemStack)s, (ItemStack)itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public void addStackToList(ItemStack decomposer, ItemStack itemStack) {
        if (decomposer.func_77978_p() == null) {
            decomposer.func_77982_d(new NBTTagCompound());
        }
        NBTTagList list = decomposer.func_77978_p().func_150295_c("Items", 10);
        if (MatterHelper.containsMatter(itemStack)) {
            NBTTagCompound tagCompound = new NBTTagCompound();
            itemStack.func_77955_b(tagCompound);
            list.func_74742_a((NBTBase)tagCompound);
        }
        decomposer.func_77978_p().func_74782_a("Items", (NBTBase)list);
    }

    public void decomposeItem(ItemStack decomposer, ItemStack itemStack) {
        if (MatterHelper.containsMatter(itemStack) && this.isStackListed(decomposer, itemStack)) {
            IEnergyStorage storage = PortableDecomposer.getStorage(itemStack);
            float matterFromItem = (float)MatterHelper.getMatterAmountFromItem(itemStack) * this.defaultMatterRatio;
            int energyForItem = MathHelper.func_76123_f((float)(matterFromItem / this.defaultMatterRatio));
            float freeMatter = this.getMaxMatter(decomposer) - (float)this.getMatter(decomposer);
            if (freeMatter > 0.0f && storage.getEnergyStored() > energyForItem) {
                int canTakeCount = (int)(freeMatter / matterFromItem);
                int itemsTaken = Math.min(canTakeCount, itemStack.func_190916_E());
                itemsTaken = Math.min(itemsTaken, storage.getEnergyStored() / energyForItem);
                if (storage instanceof EnergyContainer) {
                    ((EnergyContainer)storage).setEnergy(storage.getEnergyStored() - itemsTaken * energyForItem);
                }
                this.setMatter(decomposer, (float)this.getMatter(decomposer) + (float)itemsTaken * matterFromItem);
                itemStack.func_190920_e(Math.max(0, itemStack.func_190916_E() - itemsTaken));
            }
        }
    }
}

