/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import java.util.List;
import javax.annotation.Nullable;
import matteroverdrive.api.matter_network.IMatterNetworkConnection;
import matteroverdrive.api.network.IMatterNetworkFilter;
import matteroverdrive.items.includes.MOBaseItem;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class NetworkFlashDrive
extends MOBaseItem
implements IMatterNetworkFilter {
    public NetworkFlashDrive(String name) {
        super(name);
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetails(ItemStack itemstack, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        super.addDetails(itemstack, player, worldIn, infos);
        if (itemstack.func_77942_o()) {
            NBTTagList list = itemstack.func_77978_p().func_150295_c("CONNECTIONS", 4);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                BlockPos pos = BlockPos.func_177969_a((long)((NBTTagLong)list.func_179238_g(i)).func_150291_c());
                IBlockState block = player.field_70170_p.func_180495_p(pos);
                infos.add(String.format("[%s] %s", pos.toString(), block.func_177230_c().func_149732_F()));
            }
        }
    }

    public EnumActionResult func_180614_a(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = playerIn.func_184586_b(hand);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof IMatterNetworkConnection) {
            BlockPos connectionPosition = tileEntity.func_174877_v();
            if (!stack.func_77942_o()) {
                stack.func_77982_d(new NBTTagCompound());
            }
            boolean hasPos = false;
            NBTTagList list = stack.func_77978_p().func_150295_c("CONNECTIONS", 4);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                BlockPos p = BlockPos.func_177969_a((long)((NBTTagLong)list.func_179238_g(i)).func_150291_c());
                if (!p.equals((Object)connectionPosition)) continue;
                hasPos = true;
                list.func_74744_a(i);
                break;
            }
            if (!hasPos) {
                list.func_74742_a((NBTBase)new NBTTagLong(pos.func_177986_g()));
            }
            stack.func_77978_p().func_74782_a("CONNECTIONS", (NBTBase)list);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    @Override
    public NBTTagCompound getFilter(ItemStack stack) {
        return stack.func_77978_p();
    }
}

