/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.items;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.inventory.IUpgrade;
import matteroverdrive.api.inventory.UpgradeTypes;
import matteroverdrive.items.IAdvancedModelProvider;
import matteroverdrive.items.includes.MOBaseItem;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemUpgrade
extends MOBaseItem
implements IUpgrade,
IAdvancedModelProvider {
    public static final String[] subItemNames = new String[]{"base", "speed", "power", "failsafe", "range", "power_storage", "hyper_speed", "matter_storage"};

    public ItemUpgrade(String name) {
        super(name);
        this.func_77625_d(16);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77637_a(MatterOverdrive.TAB_OVERDRIVE_MODULES);
    }

    @Override
    public String[] getSubNames() {
        return subItemNames;
    }

    @Override
    public boolean hasDetails(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        return damage != 0;
    }

    public int func_77647_b(int damage) {
        return damage;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDetails(ItemStack itemstack, EntityPlayer player, @Nullable World worldIn, List<String> infos) {
        Map<UpgradeTypes, Double> stats = this.getUpgrades(itemstack);
        for (Map.Entry<UpgradeTypes, Double> entry : stats.entrySet()) {
            infos.add(MOStringHelper.toInfo(entry.getKey(), entry.getValue()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        if (this.func_194125_a(creativeTabs)) {
            for (int i = 0; i < subItemNames.length; ++i) {
                list.add((Object)new ItemStack((Item)this, 1, i));
            }
        }
    }

    public String func_77667_c(ItemStack stack) {
        int i = MathHelper.func_76125_a((int)stack.func_77952_i(), (int)0, (int)(subItemNames.length - 1));
        return super.func_77658_a() + "." + subItemNames[i];
    }

    @Override
    public Map<UpgradeTypes, Double> getUpgrades(ItemStack itemStack) {
        HashMap<UpgradeTypes, Double> upgrades = new HashMap<UpgradeTypes, Double>();
        int damage = itemStack.func_77952_i();
        switch (damage) {
            case 1: {
                upgrades.put(UpgradeTypes.Speed, 0.75);
                upgrades.put(UpgradeTypes.PowerUsage, 1.25);
                upgrades.put(UpgradeTypes.Fail, 1.25);
                upgrades.put(UpgradeTypes.MatterUsage, 1.25);
                break;
            }
            case 2: {
                upgrades.put(UpgradeTypes.Speed, 1.5);
                upgrades.put(UpgradeTypes.PowerUsage, 0.75);
                upgrades.put(UpgradeTypes.Fail, 1.25);
                break;
            }
            case 3: {
                upgrades.put(UpgradeTypes.Fail, 0.5);
                upgrades.put(UpgradeTypes.Speed, 1.25);
                upgrades.put(UpgradeTypes.PowerUsage, 1.25);
                upgrades.put(UpgradeTypes.MatterUsage, 1.25);
                break;
            }
            case 4: {
                upgrades.put(UpgradeTypes.Range, 4.0);
                upgrades.put(UpgradeTypes.PowerUsage, 1.5);
                upgrades.put(UpgradeTypes.MatterUsage, 1.5);
                break;
            }
            case 5: {
                upgrades.put(UpgradeTypes.PowerStorage, 2.0);
                break;
            }
            case 6: {
                upgrades.put(UpgradeTypes.Speed, 0.15);
                upgrades.put(UpgradeTypes.PowerUsage, 2.0);
                upgrades.put(UpgradeTypes.MatterUsage, 2.0);
                upgrades.put(UpgradeTypes.Fail, 1.25);
                break;
            }
            case 7: {
                upgrades.put(UpgradeTypes.MatterStorage, 2.0);
            }
        }
        return upgrades;
    }

    @Override
    public UpgradeTypes getMainUpgrade(ItemStack itemStack) {
        int damage = itemStack.func_77952_i();
        switch (damage) {
            case 1: {
                return UpgradeTypes.Speed;
            }
            case 2: {
                return UpgradeTypes.PowerUsage;
            }
            case 3: {
                return UpgradeTypes.Fail;
            }
            case 4: {
                return UpgradeTypes.Range;
            }
            case 5: {
                return UpgradeTypes.PowerStorage;
            }
            case 6: {
                return UpgradeTypes.Speed;
            }
            case 7: {
                return UpgradeTypes.MatterStorage;
            }
        }
        return null;
    }
}

