/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler.dialog;

import java.util.HashMap;
import java.util.Map;
import matteroverdrive.api.dialog.IDialogMessage;
import matteroverdrive.api.dialog.IDialogRegistry;
import matteroverdrive.api.exceptions.MORuntimeException;
import net.minecraft.util.ResourceLocation;

public class DialogRegistry
implements IDialogRegistry {
    private final Map<Integer, IDialogMessage> messageMap = new HashMap<Integer, IDialogMessage>();
    private final Map<IDialogMessage, Integer> messageIntegerMap = new HashMap<IDialogMessage, Integer>();
    private final Map<ResourceLocation, IDialogMessage> namedDialogMessages = new HashMap<ResourceLocation, IDialogMessage>();
    private int nextMessageID = 0;

    @Override
    public IDialogMessage getMessage(int id) {
        return this.messageMap.get(id);
    }

    public IDialogMessage getMessage(ResourceLocation id) {
        return this.namedDialogMessages.get(id);
    }

    @Override
    public int getMessageId(IDialogMessage dialogMessage) {
        Integer id = this.messageIntegerMap.get(dialogMessage);
        if (id == null) {
            return -1;
        }
        return id;
    }

    @Override
    public void registerMessage(IDialogMessage message) {
        this.messageMap.put(this.nextMessageID, message);
        this.messageIntegerMap.put(message, this.nextMessageID);
        ++this.nextMessageID;
    }

    @Override
    public void registerMessage(ResourceLocation name, IDialogMessage message) {
        this.registerMessage(message);
        if (this.namedDialogMessages.containsKey(name)) {
            throw new MORuntimeException(String.format("Dialog Message name '%s' already present", name));
        }
        this.namedDialogMessages.put(name, message);
    }
}

