/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import com.google.gson.Gson;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import matteroverdrive.api.events.MOEventRegisterMatterEntry;
import matteroverdrive.api.matter.IMatterEntry;
import matteroverdrive.api.matter.IMatterRegistry;
import matteroverdrive.data.matter.IMatterEntryHandler;
import matteroverdrive.data.matter.ItemStackHandlerCachable;
import matteroverdrive.data.matter.MatterEntryAbstract;
import matteroverdrive.data.matter.MatterEntryBlock;
import matteroverdrive.data.matter.MatterEntryItem;
import matteroverdrive.data.matter.MatterEntryOre;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.MOLog;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public class MatterRegistry
implements IMatterRegistry {
    private static final int MAX_DEPTH = 8;
    private final Set<String> modBlacklist = Collections.synchronizedSet(new HashSet());
    public boolean CALCULATION_DEBUG = false;
    public boolean AUTOMATIC_CALCULATION = true;
    public boolean CALCULATE_RECIPES = true;
    public boolean CALCULATE_FURNACE = true;
    public boolean CALCULATE_INSCRIBER = true;
    public boolean hasComplitedRegistration = false;
    public int basicEntries = 0;
    private boolean REGISTRATION_DEBUG = false;
    private Map<Item, MatterEntryItem> itemEntires = new HashMap<Item, MatterEntryItem>();
    private Map<Block, MatterEntryBlock> blockEntires = new HashMap<Block, MatterEntryBlock>();
    private Map<String, MatterEntryOre> oreEntries = new HashMap<String, MatterEntryOre>();

    public void preInit(FMLPreInitializationEvent event, ConfigurationHandler configurationHandler) {
        this.REGISTRATION_DEBUG = configurationHandler.getBool("matter registration", "debug", false, "Enables Debug logging for Matter Registration");
        this.CALCULATION_DEBUG = configurationHandler.getBool("matter calculation", "debug", false, "Enables Debug logging for Matter Calculation");
        this.CALCULATE_RECIPES = configurationHandler.getBool("automatic matter calculation from recipe", "matter registry", true, "Enables Matter Calculation from recipes");
        this.CALCULATE_FURNACE = configurationHandler.getBool("automatic matter calculation from furnace", "matter registry", true, "Enables Matter Calculation from furnace recipes");
        this.CALCULATE_INSCRIBER = configurationHandler.getBool("automatic matter calculation from inscriber", "matter registry", true, "Enables Matter Calculation from inscriber recipes");
        this.AUTOMATIC_CALCULATION = configurationHandler.getBool("automatic_calculation", "matter registry", true, "Should the matter registry calculation run on world start when recepie ");
    }

    public void saveToFile(File file) throws Exception {
        file.getParentFile().mkdirs();
        file.createNewFile();
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        NBTTagCompound tagCompound = new NBTTagCompound();
        this.saveListToNBT("Items", tagCompound, this.itemEntires.values());
        this.saveListToNBT("Ores", tagCompound, this.oreEntries.values());
        tagCompound.func_74778_a("Version", "0.7.0.0");
        tagCompound.func_74768_a("RecipeCount", CraftingManager.field_193380_a.func_148742_b().size());
        tagCompound.func_74768_a("BasicEntriesCount", this.basicEntries);
        tagCompound.func_74768_a("ModBlacklistCount", this.modBlacklist.size());
        CompressedStreamTools.func_74799_a((NBTTagCompound)tagCompound, (OutputStream)fileOutputStream);
        fileOutputStream.close();
    }

    private void saveListToNBT(String listName, NBTTagCompound mainTag, Collection<? extends MatterEntryAbstract> list) {
        NBTTagCompound itemEntryList = new NBTTagCompound();
        mainTag.func_74782_a(listName, (NBTBase)itemEntryList);
        for (MatterEntryAbstract matterEntryAbstract : list) {
            if (!matterEntryAbstract.hasCached()) continue;
            NBTTagCompound itemEntryTag = new NBTTagCompound();
            matterEntryAbstract.writeTo(itemEntryTag);
            itemEntryList.func_74782_a(matterEntryAbstract.writeKey(), (NBTBase)itemEntryTag);
        }
    }

    public void loadFromFile(File file) throws IOException {
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            NBTTagCompound tagCompound = CompressedStreamTools.func_74796_a((InputStream)fileInputStream);
            NBTTagCompound itemsList = tagCompound.func_74775_l("Items");
            for (Object key : itemsList.func_150296_c()) {
                MatterEntryItem item = new MatterEntryItem();
                item.readKey((String)key);
                MatterEntryItem existingEntry = this.itemEntires.get(item.getKey());
                if (existingEntry != null) {
                    existingEntry.readFrom(itemsList.func_74775_l((String)key));
                    continue;
                }
                item.readFrom(itemsList.func_74775_l((String)key));
                this.itemEntires.put((Item)item.getKey(), item);
            }
            NBTTagCompound oresList = tagCompound.func_74775_l("Ores");
            for (String key : oresList.func_150296_c()) {
                MatterEntryOre entry = new MatterEntryOre();
                entry.readKey(key);
                MatterEntryOre existingEntry = this.oreEntries.get(entry.getKey());
                if (existingEntry != null) {
                    existingEntry.readFrom(oresList.func_74775_l(key));
                    continue;
                }
                entry.readFrom(oresList.func_74775_l(key));
                this.oreEntries.put((String)entry.getKey(), entry);
            }
            String version = tagCompound.func_74779_i("Version");
            fileInputStream.close();
            MOLog.info("Registry Loaded %1$s cached itemEntires, from version %2$s from: %3$s", itemsList.func_150296_c().size() + oresList.func_150296_c().size(), version, file.getPath());
        }
    }

    public void loadCustomHandlers(File file) throws FileNotFoundException {
        if (file.exists()) {
            Gson gson = new Gson();
            FileReader fileReader = new FileReader(file);
            CusomHandlerListJSON list = (CusomHandlerListJSON)gson.fromJson((Reader)fileReader, CusomHandlerListJSON.class);
            for (Map.Entry customHandlerJSON : list.items.entrySet()) {
                Item item = Item.func_111206_d((String)((String)customHandlerJSON.getKey()));
                if (item != null) {
                    if (((CustomHandlerJSON)customHandlerJSON.getValue()).hasMeta) {
                        for (int i = 0; i < ((CustomHandlerJSON)customHandlerJSON.getValue()).meta.length; ++i) {
                            ItemStackHandlerCachable cachable = new ItemStackHandlerCachable(((CustomHandlerJSON)customHandlerJSON.getValue()).matter, ((CustomHandlerJSON)customHandlerJSON.getValue()).meta[i]);
                            cachable.markCustom();
                            this.register(item, cachable);
                        }
                        continue;
                    }
                    ItemStackHandlerCachable cachable = new ItemStackHandlerCachable(((CustomHandlerJSON)customHandlerJSON.getValue()).matter);
                    cachable.markCustom();
                    this.register(item, cachable);
                    continue;
                }
                MOLog.error("Trying to load a Matter Registry Custom Handler with invalid item ID: %s", customHandlerJSON.getKey());
            }
        }
    }

    public void unload() {
        this.itemEntires.values().forEach(MatterEntryItem::clearAllCashed);
        this.oreEntries.values().forEach(MatterEntryOre::clearAllCashed);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean needsCalculation(File file) throws IOException, ClassNotFoundException {
        String reason = "";
        if (file.exists()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            NBTTagCompound tagCompound = CompressedStreamTools.func_74796_a((InputStream)fileInputStream);
            String version = tagCompound.func_74779_i("Version");
            int recipeCount = tagCompound.func_74762_e("RecipeCount");
            int basicEntries = tagCompound.func_74762_e("BasicEntriesCount");
            fileInputStream.close();
            if (version.equalsIgnoreCase("0.7.0.0")) {
                if (recipeCount == CraftingManager.field_193380_a.func_148742_b().size()) {
                    if (basicEntries == this.basicEntries) return false;
                    reason = "Basic Entries size changed";
                } else {
                    reason = "Recipe List Changed";
                }
            }
        } else {
            reason = "Matter Registry File missing";
        }
        MOLog.warn(reason + "! Recalculation required!", new Object[0]);
        return true;
    }

    public boolean blacklistedFromMod(ItemStack stack) {
        return this.modBlacklist.contains(stack.func_77973_b().getCreatorModId(stack));
    }

    public IMatterEntry<?, ?> getEntry(ItemStack item) {
        try {
            IMatterEntry<String, ItemStack> e = this.itemEntires.get(item.func_77973_b());
            if (e == null) {
                e = this.getOreDicionaryEntry(item);
            }
            return e;
        }
        catch (Exception e) {
            this.debug("There was a problem getting a Matter Entry for %s.", item);
            return null;
        }
    }

    @Override
    public int getMatter(ItemStack itemStack) {
        IMatterEntry<Object, Object> entry = this.getEntry(itemStack);
        int matter = 0;
        if (entry != null) {
            matter = entry.getMatter(itemStack);
        } else {
            this.debug("Could not find matter entry for: %s", itemStack);
        }
        if (matter <= 0) {
            entry = this.getOreDicionaryEntry(itemStack);
            if (entry != null) {
                matter = entry.getMatter(itemStack);
            } else {
                this.debug("Could not find ore dictionary entry for: %s", itemStack);
            }
        }
        return matter;
    }

    @Override
    public int getMatterOre(String ore) {
        IMatterEntry entry = this.oreEntries.get(ore);
        if (entry != null) {
            return entry.getMatter(null);
        }
        return 0;
    }

    @Override
    public IMatterEntry register(@Nonnull Item item, IMatterEntryHandler handler) {
        IMatterEntry existingEntry = this.itemEntires.get(item);
        if (existingEntry != null) {
            existingEntry.addHandler(handler);
            return existingEntry;
        }
        MatterEntryItem entry = new MatterEntryItem(item);
        entry.addHandler(handler);
        if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventRegisterMatterEntry(entry))) {
            this.itemEntires.put((Item)entry.getKey(), entry);
        }
        return entry;
    }

    @Override
    public IMatterEntry registerOre(String ore, IMatterEntryHandler handler) {
        IMatterEntry existingEntry = this.oreEntries.get(ore);
        if (existingEntry != null) {
            existingEntry.addHandler(handler);
            return existingEntry;
        }
        MatterEntryOre matterEntryOre = new MatterEntryOre(ore);
        matterEntryOre.addHandler(handler);
        if (!MinecraftForge.EVENT_BUS.post((Event)new MOEventRegisterMatterEntry(matterEntryOre))) {
            this.oreEntries.put(ore, matterEntryOre);
        }
        return matterEntryOre;
    }

    private IMatterEntry<String, ItemStack> getOreDicionaryEntry(ItemStack stack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        if (ids.length <= 0) {
            if (stack.func_77952_i() == Short.MAX_VALUE) {
                this.debug("Messed up damage for: %s.", stack);
            } else {
                this.debug("No OreDictionary support for: %s", stack);
            }
            return null;
        }
        for (int id : ids) {
            String entryName = OreDictionary.getOreName((int)id);
            this.debug("Searching for OreDictionary key with name: %s for item: %s", entryName, stack);
            IMatterEntry e = this.oreEntries.get(entryName);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    @Override
    public int getMatterFromRecipe(ItemStack item) {
        int matter = 0;
        Collection recipes = ForgeRegistries.RECIPES.getValuesCollection();
        for (IRecipe recipe : recipes) {
            ItemStack recipeOutput = recipe.func_77571_b();
            if (recipeOutput.func_190926_b() || !ItemStack.func_77989_b((ItemStack)recipeOutput, (ItemStack)item)) continue;
            int m = this.getMatterFromList(recipeOutput, (NonNullList<Ingredient>)recipe.func_192400_c());
            matter += m;
        }
        return matter;
    }

    @Override
    public void addModToBlacklist(String modID) {
        this.modBlacklist.add(modID);
    }

    public void loadModBlacklistFromConfig(ConfigurationHandler c) {
        String[] list;
        for (String value : list = c.getStringList("matter registry", "mod_blacklist")) {
            this.addModToBlacklist(value);
        }
    }

    public int getMatterFromList(ItemStack item, NonNullList<Ingredient> list) {
        int totalMatter = 0;
        for (Ingredient s : list) {
            if (s == null || s == Ingredient.field_193370_a) continue;
            int tempMatter = 0;
            ItemStack[] l = s.func_193365_a();
            boolean first = true;
            for (ItemStack element : l) {
                IMatterEntry<?, ?> tempEntry = this.getEntry(element);
                if (tempEntry == null) continue;
                if (tempEntry.getMatter(element) > 0) {
                    if (tempEntry.getMatter(element) >= tempMatter && !first) continue;
                    tempMatter = tempEntry.getMatter(element);
                    first = false;
                    continue;
                }
                this.debug("entry for %s, found in recipe for: %s was blacklisted or costs lower then previous", element, item);
            }
            if (tempMatter < 0) {
                this.debug("%s is invalid.", item);
                return -1;
            }
            if (tempMatter == 0) {
                this.debug("%s item in recipe has 0 matter.", item);
                return 0;
            }
            totalMatter += tempMatter;
        }
        return (int)Math.round((double)totalMatter / (double)item.func_190916_E());
    }

    public Map<Item, MatterEntryItem> getItemEntires() {
        return this.itemEntires;
    }

    public Map<String, MatterEntryOre> getOreEntries() {
        return this.oreEntries;
    }

    public void debug(String debug, Object ... params) {
        if (this.REGISTRATION_DEBUG) {
            for (int i = 0; i < params.length; ++i) {
                if (!(params[i] instanceof ItemStack)) continue;
                try {
                    params[i] = ((ItemStack)params[i]).func_77973_b();
                    continue;
                }
                catch (Exception e) {
                    MOLog.warn("There was a problem getting ItemStack's name", new Object[0]);
                }
            }
            MOLog.debug(debug, params);
        }
    }

    private static class CustomHandlerJSON {
        private final boolean isOre;
        private final boolean hasMeta;
        private final int[] meta;
        private final int matter;
        private final int priority;

        public CustomHandlerJSON(boolean isOre, boolean metadataSpecific, int[] meta, int matter, int priority) {
            this.isOre = isOre;
            this.hasMeta = metadataSpecific;
            this.meta = meta;
            this.matter = matter;
            this.priority = priority;
        }
    }

    private static class CusomHandlerListJSON {
        private final Map<String, CustomHandlerJSON> items;
        private final Map<String, CustomHandlerJSON> ores;

        public CusomHandlerListJSON(Map<String, CustomHandlerJSON> items, Map<String, CustomHandlerJSON> ores) {
            this.items = items;
            this.ores = ores;
        }
    }
}

