/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.handler;

import matteroverdrive.api.network.IMatterNetworkHandler;
import matteroverdrive.handler.ConfigurationHandler;
import matteroverdrive.util.IConfigSubscriber;
import matteroverdrive.util.MOLog;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.logging.log4j.Level;

public class MatterNetworkTickHandler
implements IConfigSubscriber {
    int id_count;
    int last_ID;
    private int max_broadcasts;
    private int broadcastCount;

    public void updateHandler(IMatterNetworkHandler handler, TickEvent.Phase phase, World world) {
        if (this.broadcastCount < this.max_broadcasts) {
            if (this.id_count >= this.last_ID) {
                try {
                    this.broadcastCount += handler.onNetworkTick(world, phase);
                }
                catch (Exception e) {
                    MOLog.log(Level.FATAL, e, "There was a problem while ticking MatterNetworkHandler %s", handler);
                }
            }
            ++this.id_count;
        }
    }

    public void onWorldTickPre(TickEvent.Phase phase, World world) {
        this.broadcastCount = 0;
        this.id_count = 0;
    }

    public void onWorldTickPost(TickEvent.Phase phase, World world) {
        this.last_ID = this.broadcastCount >= this.max_broadcasts ? this.id_count : 0;
    }

    @Override
    public void onConfigChanged(ConfigurationHandler config) {
        this.max_broadcasts = config.getInt("max broadcasts per tick", "matter network", 128, "The maximum amount of network packet broadcasts per tick.");
    }
}

