/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.guide.GuideElementPage;
import matteroverdrive.guide.IGuideElement;
import matteroverdrive.guide.MOGuideEntry;
import matteroverdrive.guide.MatterOverdriveGuide;
import matteroverdrive.network.packet.server.PacketDataPadCommands;
import matteroverdrive.util.MOLog;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Level;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PageGuideDescription
extends ElementBaseGroup {
    private static final String SCROLL_RIGHT_ELEMENT_NAME = "scroll_right";
    private static final String SCROLL_LEFT_ELEMENT_NAME = "scroll_left";
    private static final String RETURN_ELEMENT_NAME = "return";
    private static final Stack<HistoryEntry> historyStack = new Stack();
    private static int tabID;
    private static int scroll;
    private final MOElementButton bt_return;
    private final List<IGuideElement> pages;
    private DocumentBuilder builder;
    private MOElementButton bt_scroll_right;
    private MOElementButton bt_scroll_left;
    private ItemStack dataPadStack;
    private EnumHand hand;

    public PageGuideDescription(MOGuiBase gui, int posX, int posY, int width, int height, String name) {
        super(gui, posX, posY, width, height);
        this.setName(name);
        this.pages = new ArrayList<IGuideElement>();
        this.bt_scroll_right = new MOElementButton(gui, this, this.sizeX - 20, this.sizeY - 16, SCROLL_RIGHT_ELEMENT_NAME, 0, 0, 10, 0, 10, 10, "");
        this.bt_scroll_right.setTexture("matteroverdrive:textures/gui/elements/scroll_right.png", 20, 10);
        this.bt_scroll_left = new MOElementButton(gui, this, 10, this.sizeY - 16, SCROLL_LEFT_ELEMENT_NAME, 0, 0, 10, 0, 10, 10, "");
        this.bt_scroll_left.setTexture("matteroverdrive:textures/gui/elements/scroll_left.png", 20, 10);
        this.bt_return = new MOElementButton(gui, this, this.sizeX / 2 - 5, this.sizeY - 16, RETURN_ELEMENT_NAME, 0, 0, 11, 0, 11, 11, "");
        this.bt_return.setTexture("matteroverdrive:textures/gui/elements/return_arrow.png", 22, 11);
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setIgnoringElementContentWhitespace(true);
        try {
            this.builder = builderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void init() {
        super.init();
        this.elements.add(this.bt_scroll_left);
        this.elements.add(this.bt_scroll_right);
        this.elements.add(this.bt_return);
        this.loadGuideInfo(MatterOverdrive.ITEMS.dataPad.getGuideID(this.dataPadStack));
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (MatterOverdrive.ITEMS.dataPad.getGuideID(this.dataPadStack) >= 0) {
            boolean lastUnicodeFlag = Minecraft.func_71410_x().field_71466_p.func_82883_a();
            Minecraft.func_71410_x().field_71466_p.func_78264_a(true);
            if (tabID == 0) {
                this.DrawDescription(mouseX, mouseY);
            }
            Minecraft.func_71410_x().field_71466_p.func_78264_a(lastUnicodeFlag);
        }
        super.drawForeground(mouseX, mouseY);
    }

    private void DrawDescription(int mouseX, int mouseY) {
        if (scroll < this.pages.size() && scroll >= 0) {
            int x = this.posX;
            int y = this.posY;
            if (this.pages.get(scroll) != null && scroll < this.pages.size()) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
                IGuideElement element = this.pages.get(scroll);
                element.drawElement(this.sizeX, mouseX - x, mouseY - y);
                GlStateManager.func_179121_F();
            } else {
                this.drawNoInfo();
            }
        } else {
            this.drawNoInfo();
        }
        this.handleScrollButtons();
    }

    private void drawNoInfo() {
        int noInfoWidth = this.getFontRenderer().func_78256_a("No Info...");
        this.getFontRenderer().func_78276_b("No Info...", this.sizeX / 2 - noInfoWidth / 2, this.sizeY / 2, Reference.COLOR_HOLO_RED.getColor());
    }

    private void handleScrollButtons() {
        this.bt_scroll_left.setVisible(true);
        this.bt_scroll_right.setVisible(true);
        if (scroll >= this.pages.size() - 1) {
            this.bt_scroll_right.setVisible(false);
        }
        if (scroll <= 0) {
            this.bt_scroll_left.setVisible(false);
        }
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String buttonName, int mouseButton) {
        if (element.equals(this.bt_scroll_left)) {
            --scroll;
        } else if (element.equals(this.bt_scroll_right)) {
            ++scroll;
        } else if (element.equals(this.bt_return)) {
            this.undo();
        }
        scroll = MathHelper.func_76125_a((int)scroll, (int)0, (int)(this.pages.size() - 1));
    }

    public void OpenGuide(int id, boolean writeToHistory) {
        this.OpenGuide(id, 0, writeToHistory);
    }

    public void OpenGuide(int id, int page, boolean writeToHistory) {
        if (MatterOverdrive.ITEMS.dataPad.getGuideID(this.dataPadStack) != id) {
            if (writeToHistory) {
                historyStack.push(new HistoryEntry(MatterOverdrive.ITEMS.dataPad.getGuideID(this.dataPadStack), scroll));
            }
            this.loadGuideInfo(id);
            MatterOverdrive.ITEMS.dataPad.setOpenGuide(this.dataPadStack, id);
            MatterOverdrive.NETWORK.sendToServer(new PacketDataPadCommands(this.hand, this.dataPadStack));
            scroll = page;
            tabID = 0;
        }
    }

    private void undo() {
        if (historyStack.size() > 0) {
            HistoryEntry historyEntry = historyStack.pop();
            this.OpenGuide(historyEntry.entry, false);
            scroll = historyEntry.scroll;
        } else {
            this.gui.setPage(0);
        }
    }

    private void loadGuideInfo(int guideID) {
        this.pages.clear();
        if (guideID >= 0) {
            MOGuideEntry entry = MatterOverdriveGuide.getQuide(guideID);
            InputStream descriptionStream = entry.getDescriptionStream();
            if (descriptionStream != null) {
                try {
                    Document document = this.builder.parse(descriptionStream);
                    document.normalize();
                    Element rootNode = (Element)document.getElementsByTagName("entry").item(0);
                    NodeList pagesNodes = rootNode.getElementsByTagName("page");
                    Map<String, String> stylesheetMap = this.loadStyleSheetMap(rootNode);
                    for (int i = 0; i < pagesNodes.getLength(); ++i) {
                        GuideElementPage page = new GuideElementPage();
                        page.setGUI(this.gui);
                        page.loadElement(entry, (Element)pagesNodes.item(i), stylesheetMap, this.sizeX, this.sizeY);
                        this.pages.add(page);
                    }
                }
                catch (SAXException e) {
                    MOLog.log(Level.ERROR, e, "XML for guide entry %s is not valid", entry.getDisplayName());
                }
                catch (IOException e) {
                    MOLog.log(Level.ERROR, e, "there was a problem reading language file for entry %s", entry.getDisplayName());
                }
            } else {
                MOLog.warn("Guide Entry file for %s missing at: %s", entry.getDisplayName(), entry.getDescriptionPath(Minecraft.func_71410_x().field_71474_y.field_74363_ab));
            }
        }
    }

    private Map<String, String> loadStyleSheetMap(Element element) {
        if (element.hasAttribute("stylesheet")) {
            try {
                HashMap<String, String> styleMap = new HashMap<String, String>();
                InputStream stylesheetStream = Minecraft.func_71410_x().func_110442_L().func_110536_a(new ResourceLocation(element.getAttribute("stylesheet"))).func_110527_b();
                String rawStyle = IOUtils.toString((InputStream)stylesheetStream, (String)"UTF-8");
                rawStyle = rawStyle.replaceAll("\\r|\\n|\\s+", "");
                rawStyle = rawStyle.replaceAll("(?s)/\\*.*?\\*/", "");
                Matcher matcher = Pattern.compile("([^}{]+)(\\{[^}]+})", 40).matcher(rawStyle);
                while (matcher.find()) {
                    styleMap.put(matcher.group(1), matcher.group(2).substring(1, matcher.group(2).length() - 1));
                }
                return styleMap;
            }
            catch (IOException e) {
                MOLog.log(Level.ERROR, e, "There was a problem loading the stylesheet", new Object[0]);
            }
        }
        return null;
    }

    public void setDataPadStack(EnumHand hand, ItemStack stack) {
        this.dataPadStack = stack;
        this.hand = hand;
    }

    private class HistoryEntry {
        public final int entry;
        private final int scroll;

        private HistoryEntry(int entry, int scroll) {
            this.entry = entry;
            this.scroll = scroll;
        }
    }
}

