/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.pages;

import matteroverdrive.Reference;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementCheckbox;
import matteroverdrive.gui.element.ElementIntegerField;
import matteroverdrive.gui.element.ElementStates;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementButtonScaled;
import matteroverdrive.gui.element.MOElementTextField;
import matteroverdrive.machines.MOTileEntityMachine;
import matteroverdrive.machines.components.ComponentConfigs;
import matteroverdrive.machines.configs.ConfigPropertyBoolean;
import matteroverdrive.machines.configs.ConfigPropertyInteger;
import matteroverdrive.machines.configs.ConfigPropertyString;
import matteroverdrive.machines.configs.ConfigPropertyStringList;
import matteroverdrive.machines.configs.IConfigProperty;
import matteroverdrive.util.MOStringHelper;

public class AutoConfigPage
extends ElementBaseGroup {
    final MOGuiMachine machineGui;
    private final ComponentConfigs componentConfigs;

    public AutoConfigPage(MOGuiMachine gui, int posX, int posY, int width, int height) {
        super(gui, posX, posY, width, height);
        this.componentConfigs = ((MOTileEntityMachine)gui.getMachine()).getConfigs();
        this.machineGui = gui;
    }

    @Override
    public void init() {
        super.init();
        int yPos = 0;
        for (IConfigProperty configProperty : this.componentConfigs.getValues().values()) {
            if (configProperty instanceof ConfigPropertyBoolean) {
                ElementCheckbox elementCheckbox = new ElementCheckbox(this.gui, this, 0, yPos, configProperty.getKey(), (Boolean)configProperty.getValue());
                elementCheckbox.setCheckboxLabel(MOStringHelper.translateToLocal(configProperty.getUnlocalizedName(), new Object[0]));
                this.addElement(elementCheckbox);
                yPos += elementCheckbox.getHeight() + 4;
                continue;
            }
            if (configProperty instanceof ConfigPropertyInteger) {
                if (configProperty instanceof ConfigPropertyStringList) {
                    ElementStates elementStates = new ElementStates(this.gui, this, 0, yPos, configProperty.getKey(), ((ConfigPropertyStringList)configProperty).getList());
                    elementStates.setSelectedState((Integer)configProperty.getValue());
                    elementStates.setLabel(MOStringHelper.translateToLocal(configProperty.getUnlocalizedName(), new Object[0]));
                    elementStates.setTextColor(Reference.COLOR_HOLO.getColor());
                    this.addElement(elementStates);
                    yPos += elementStates.getHeight() + 4;
                    continue;
                }
                ElementIntegerField elementIntegerField = new ElementIntegerField(this.gui, this, 0, yPos, 20, ((ConfigPropertyInteger)configProperty).getMin(), ((ConfigPropertyInteger)configProperty).getMax());
                elementIntegerField.setNumber((Integer)configProperty.getValue());
                elementIntegerField.setName(configProperty.getKey());
                elementIntegerField.setLabel(MOStringHelper.translateToLocal(configProperty.getUnlocalizedName(), new Object[0]));
                elementIntegerField.setLabelColor(Reference.COLOR_HOLO.getColor());
                elementIntegerField.init();
                this.addElement(elementIntegerField);
                yPos += elementIntegerField.getHeight() + 4;
                continue;
            }
            if (!(configProperty instanceof ConfigPropertyString)) continue;
            MOElementTextField textField = new MOElementTextField(this.gui, this, 8, yPos + 2, this.sizeX, 20);
            textField.setMaxLength(((ConfigPropertyString)configProperty).getMaxLength());
            textField.setName(configProperty.getKey());
            textField.setText(configProperty.getValue().toString());
            textField.setBackground(MOElementButtonScaled.HOVER_TEXTURE_DARK);
            textField.setTextOffset(8, 4);
            if (((ConfigPropertyString)configProperty).getPattern() != null) {
                textField.setFilter(((ConfigPropertyString)configProperty).getPattern(), false);
            }
            this.addElement(textField);
            yPos += textField.getHeight() + 4;
        }
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String name, int mouseButton) {
        for (IConfigProperty configProperty : this.componentConfigs.getValues().values()) {
            if (configProperty instanceof ConfigPropertyBoolean) {
                if (!name.equals(configProperty.getKey()) || !(element instanceof ElementCheckbox)) continue;
                configProperty.setValue(((ElementCheckbox)element).getState());
                ((MOTileEntityMachine)this.componentConfigs.getMachine()).sendConfigsToServer(true);
                continue;
            }
            if (!(configProperty instanceof ConfigPropertyInteger) || !name.equals(configProperty.getKey())) continue;
            int state = 0;
            if (element instanceof ElementStates) {
                state = mouseButton;
            } else if (element instanceof ElementIntegerField) {
                state = ((ElementIntegerField)element).getNumber();
            }
            configProperty.setValue(state);
            ((MOTileEntityMachine)this.componentConfigs.getMachine()).sendConfigsToServer(true);
        }
    }

    @Override
    public void textChanged(String elementName, String text, boolean typed) {
        for (IConfigProperty configProperty : this.componentConfigs.getValues().values()) {
            if (!(configProperty instanceof ConfigPropertyString) || !elementName.equals(configProperty.getKey())) continue;
            configProperty.setValue(text);
            ((MOTileEntityMachine)this.componentConfigs.getMachine()).sendConfigsToServer(true);
        }
    }
}

