/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import java.util.List;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.data.matter_network.ItemPatternMapping;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementSlot;
import matteroverdrive.util.MatterDatabaseHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ElementItemPattern
extends ElementSlot {
    protected ScaleTexture texture;
    protected ItemPatternMapping patternMapping;
    protected ItemStack itemStack;
    protected int amount = 0;

    public ElementItemPattern(MOGuiBase gui, ItemPatternMapping patternMapping, String bgType, int width, int height) {
        super(gui, 0, 0, width, height, bgType);
        this.texture = new ScaleTexture(ElementItemPattern.getTexture(bgType), width, height).setOffsets(2, 2, 2, 2);
        this.setPatternMapping(patternMapping);
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        if (this.patternMapping != null) {
            this.itemStack.func_190920_e(this.amount);
            RenderHelper.func_74520_c();
            GlStateManager.func_179140_f();
            GlStateManager.func_179091_B();
            GlStateManager.func_179142_g();
            GlStateManager.func_179145_e();
            RenderUtils.renderStack(this.posX + 3, this.posY + 3, 100, this.itemStack, true);
            GlStateManager.func_179140_f();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179126_j();
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        this.texture.render(this.posX, this.posY, this.sizeX, this.sizeY);
    }

    @Override
    public void addTooltip(List<String> list, int mouseX, int mouseY) {
        if (this.patternMapping != null && this.itemStack != null) {
            list.addAll(this.itemStack.func_82840_a((EntityPlayer)Minecraft.func_71410_x().field_71439_g, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL));
            String name = list.get(0);
            int progress = this.patternMapping.getItemPattern().getProgress();
            name = MatterDatabaseHelper.getPatternInfoColor(progress) + name + " [" + progress + "%]";
            list.set(0, name);
        }
    }

    public ItemPatternMapping getPatternMapping() {
        return this.patternMapping;
    }

    public void setPatternMapping(ItemPatternMapping patternMapping) {
        this.patternMapping = patternMapping;
        if (patternMapping != null) {
            this.itemStack = patternMapping.getItemPattern().toItemStack(false);
            this.name = this.itemStack.func_82833_r();
        } else {
            this.itemStack = null;
        }
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public ScaleTexture getTexture() {
        return this.texture;
    }
}

