/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.element;

import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.IParallaxElement;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.util.RenderUtils;
import net.minecraft.util.math.MathHelper;

public class ElementGroup2DScroll
extends ElementBaseGroup {
    int scrollX;
    int scrollY;
    int lastMouseX;
    int lastMouseY;
    int minScrollX;
    int maxScrollX;
    int minScrollY;
    int maxScrollY;
    boolean isDragging;
    boolean hasDragged;

    public ElementGroup2DScroll(MOGuiBase gui, int posX, int posY, int width, int height) {
        super(gui, posX, posY, width, height);
    }

    @Override
    public void update(int mouseX, int mouseY, float partialTicks) {
        super.update(mouseX, mouseY, partialTicks);
        if (this.isDragging) {
            int mouseDeltaX = mouseX - this.lastMouseX;
            int mouseDeltaY = mouseY - this.lastMouseY;
            if (mouseDeltaX != 0 || mouseDeltaY != 0) {
                this.hasDragged = true;
            }
            this.setScroll(this.scrollX + mouseDeltaX, this.scrollY - mouseDeltaY);
        }
        this.lastMouseX = mouseX;
        this.lastMouseY = mouseY;
    }

    private void moveElementByDelta(int deltaX, int deltaY) {
        for (MOElementBase elementBase : this.elements) {
            if (elementBase instanceof IParallaxElement) {
                ((IParallaxElement)((Object)elementBase)).move(deltaX, deltaY);
                continue;
            }
            elementBase.setPosition(elementBase.getPosX() + deltaX, elementBase.getPosY() + deltaY);
        }
    }

    @Override
    public void drawBackground(int mouseX, int mouseY, float gameTicks) {
        RenderUtils.beginDrawingDepthMask();
        RenderUtils.drawPlane(this.posX, this.posY, 200.0, this.sizeX, this.sizeY);
        RenderUtils.beginDepthMasking();
        super.drawBackground(mouseX, mouseY, gameTicks);
        RenderUtils.endDepthMask();
    }

    @Override
    public void drawForeground(int mouseX, int mouseY) {
        RenderUtils.beginDrawingDepthMask();
        RenderUtils.drawPlane(this.posX, this.posY, 200.0, this.sizeX, this.sizeY);
        RenderUtils.beginDepthMasking();
        super.drawForeground(mouseX, mouseY);
        RenderUtils.endDepthMask();
    }

    @Override
    public boolean onMousePressed(int mouseX, int mouseY, int mouseButton) {
        this.isDragging = true;
        return super.onMousePressed(mouseX, mouseY, mouseButton);
    }

    @Override
    public void onMouseReleased(int mouseX, int mouseY) {
        this.isDragging = false;
        if (!this.hasDragged) {
            super.onMouseReleased(mouseX, mouseY);
        }
        this.hasDragged = false;
    }

    public void setScroll(int scrollX, int scrollY) {
        scrollX = MathHelper.func_76125_a((int)scrollX, (int)(-this.maxScrollX), (int)(-this.minScrollX));
        scrollY = MathHelper.func_76125_a((int)scrollY, (int)this.minScrollY, (int)this.maxScrollY);
        int scrollDeltaX = scrollX - this.scrollX;
        int scrollDeltaY = this.scrollY - scrollY;
        this.scrollX = scrollX;
        this.scrollY = scrollY;
        this.moveElementByDelta(scrollDeltaX, scrollDeltaY);
    }

    @Override
    public MOElementBase addElement(MOElementBase element) {
        MOElementBase elementBase = super.addElement(element);
        if (elementBase != null) {
            if (elementBase instanceof IParallaxElement) {
                ((IParallaxElement)((Object)elementBase)).move(this.scrollX, -this.scrollY);
            } else {
                elementBase.setPosition(elementBase.getPosX() + this.scrollX, elementBase.getPosY() - this.scrollY);
            }
        }
        return elementBase;
    }

    public int getScrollX() {
        return this.scrollX;
    }

    public void setScrollX(int scrollX) {
        int scrollDeltaX = this.scrollX - scrollX;
        this.scrollX = scrollX;
        this.moveElementByDelta(scrollDeltaX, 0);
    }

    public int getScrollY() {
        return this.scrollY;
    }

    public void setScrollY(int scrollY) {
        int scrollDeltaY = this.scrollY - scrollY;
        this.scrollY = scrollY;
        this.moveElementByDelta(0, scrollDeltaY);
    }

    public void setScrollBounds(int minScrollX, int maxScrollX, int minScrollY, int maxScrollY) {
        this.minScrollX = minScrollX;
        this.minScrollY = minScrollY;
        this.maxScrollX = maxScrollX;
        this.maxScrollY = maxScrollY;
    }
}

