/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui.android;

import matteroverdrive.Reference;
import matteroverdrive.client.data.Color;
import matteroverdrive.data.MinimapEntityInfo;
import matteroverdrive.entity.android_player.AndroidPlayer;
import matteroverdrive.gui.android.AndroidHudElement;
import matteroverdrive.gui.android.AndroidHudPosition;
import matteroverdrive.init.OverdriveBioticStats;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IMerchant;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.Cylinder;
import org.lwjgl.util.glu.Sphere;

public class AndroidHudMinimap
extends AndroidHudElement {
    private final Sphere sphere = new Sphere();
    private final Cylinder cylinder = new Cylinder();
    private final float OPACITY = 0.6f;
    private final int ROTATION = 55;
    private final float ZOOM = 1.0f;
    private final int RADIUS = 64;

    public AndroidHudMinimap(AndroidHudPosition position, String name) {
        super(position, name, 188, 188);
    }

    @Override
    public boolean isVisible(AndroidPlayer android) {
        return android.isUnlocked(OverdriveBioticStats.minimap, 0);
    }

    @Override
    public void drawElement(AndroidPlayer androidPlayer, ScaledResolution resolution, float ticks) {
        int x = this.getWidth(resolution, androidPlayer) / 2;
        int y = this.getHeight(resolution, androidPlayer) / 2;
        float scale = this.getScale(resolution);
        GlStateManager.func_179097_i();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)1);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)-100.0f);
        GlStateManager.func_179114_b((float)55.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        this.drawBackground(resolution);
        this.beginMask();
        GlStateManager.func_179121_F();
        for (Object entityObj : this.mc.field_71441_e.field_72996_f) {
            if (!(entityObj instanceof EntityLivingBase)) continue;
            EntityLivingBase entityLivingBase = (EntityLivingBase)entityObj;
            Vec3d pos = entityLivingBase.func_174824_e(ticks);
            Vec3d playerPosition = this.mc.field_71439_g.func_174824_e(ticks);
            pos = pos.func_178788_d(playerPosition);
            pos = new Vec3d(pos.field_72450_a * 1.0, pos.field_72448_b * 1.0, pos.field_72449_c * 1.0);
            if (!AndroidPlayer.isVisibleOnMinimap((EntityLivingBase)entityObj, (EntityPlayer)this.mc.field_71439_g, pos) || !(pos.func_72433_c() < (double)Math.min(256.0f, 80.0f))) continue;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-130.0f);
            this.drawEntity(entityLivingBase, scale, x, y, pos);
            GlStateManager.func_179121_F();
        }
        this.endMask();
        GlStateManager.func_179098_w();
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
    }

    private void beginMask() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179086_m((int)256);
        GlStateManager.func_179151_a((double)1.0);
        GlStateManager.func_179143_c((int)513);
        GlStateManager.func_179126_j();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        GlStateManager.func_179090_x();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)1.0f);
        RenderUtils.drawCircle(64.0, 32);
        GlStateManager.func_179098_w();
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_179126_j();
        GlStateManager.func_179143_c((int)516);
        GlStateManager.func_179121_F();
    }

    private void endMask() {
        GlStateManager.func_179143_c((int)515);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179097_i();
    }

    private void drawBackground(ScaledResolution resolution) {
        this.drawCompas();
        GlStateManager.func_179118_c();
        GlStateManager.func_179090_x();
        GL11.glPolygonMode((int)1032, (int)6913);
        GL11.glLineWidth((float)1.0f);
        RenderUtils.applyColorWithAlpha(this.baseColor, 0.3f);
        RenderUtils.drawCircle(64.0, 32);
        this.drawFov(resolution);
        double radarPercent = (double)(this.mc.field_71441_e.func_72820_D() % 40L) / 40.0;
        RenderUtils.applyColorWithAlpha(this.baseColor, 0.48000002f * (float)radarPercent);
        RenderUtils.drawCircle(radarPercent * 64.0, 32);
        RenderUtils.applyColorWithAlpha(this.baseColor, 0.3f);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
        this.cylinder.draw(64.0f, 64.0f, 5.0f, 64, 1);
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GL11.glPolygonMode((int)1032, (int)6914);
        GlStateManager.func_179094_E();
        this.drawPlayer();
        GlStateManager.func_179121_F();
    }

    private void drawCompas() {
        int rad = 74;
        this.mc.field_71466_p.func_78276_b("S", (int)(Math.sin(Math.toRadians(180.0f - this.mc.func_175606_aa().field_70177_z)) * (double)rad), (int)(Math.cos(Math.toRadians(180.0f - this.mc.func_175606_aa().field_70177_z)) * (double)rad), Reference.COLOR_MATTER.getColor());
        this.mc.field_71466_p.func_78276_b("N", (int)(Math.sin(Math.toRadians(-this.mc.func_175606_aa().field_70177_z)) * (double)rad), (int)(Math.cos(Math.toRadians(-this.mc.func_175606_aa().field_70177_z)) * 64.0), Reference.COLOR_MATTER.getColor());
        this.mc.field_71466_p.func_78276_b("E", (int)(Math.sin(Math.toRadians(90.0f - this.mc.func_175606_aa().field_70177_z)) * (double)rad), (int)(Math.cos(Math.toRadians(90.0f - this.mc.func_175606_aa().field_70177_z)) * (double)rad), Reference.COLOR_MATTER.getColor());
        this.mc.field_71466_p.func_78276_b("W", (int)(Math.sin(Math.toRadians(-this.mc.func_175606_aa().field_70177_z - 90.0f)) * (double)rad), (int)(Math.cos(Math.toRadians(-this.mc.func_175606_aa().field_70177_z - 90.0f)) * (double)rad), Reference.COLOR_MATTER.getColor());
    }

    private void drawPlayer() {
        RenderUtils.applyColor(Reference.COLOR_HOLO_GREEN);
        GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderUtils.drawShip(0.0, 0.0, 0.0, 3.0);
    }

    private void drawFov(ScaledResolution resolution) {
        double aspectRatio = resolution.func_78327_c() / resolution.func_78324_d();
        float angleAdd = 180.0f;
        float fovAngle = this.mc.field_71474_y.field_74334_X * 0.5f * (float)aspectRatio;
        GL11.glBegin((int)3);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)(Math.sin(Math.toRadians(fovAngle + angleAdd)) * 64.0), (double)(Math.cos(Math.toRadians(fovAngle + angleAdd)) * 64.0), (double)0.0);
        GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
        GL11.glVertex3d((double)(Math.sin(Math.toRadians(-fovAngle + angleAdd)) * 64.0), (double)(Math.cos(Math.toRadians(-fovAngle + angleAdd)) * 64.0), (double)0.0);
        GL11.glEnd();
    }

    private void drawEntity(EntityLivingBase entityLivingBase, float scale, int x, int y, Vec3d pos) {
        GlStateManager.func_179109_b((float)x, (float)y, (float)0.0f);
        GlStateManager.func_179114_b((float)55.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        if (!entityLivingBase.equals((Object)this.mc.field_71439_g)) {
            int size = this.getMinimapSize(entityLivingBase);
            Color color = this.getMinimapColor(entityLivingBase);
            float opacity = this.mc.field_71439_g.func_70685_l((Entity)entityLivingBase) ? 1.0f : 0.7f;
            GlStateManager.func_179098_w();
            RenderUtils.applyColorWithAlpha(color, 0.6f * (opacity *= this.baseColor.getFloatA()));
            GlStateManager.func_179114_b((float)(this.mc.func_175606_aa().field_70177_z + 180.0f), (float)0.0f, (float)0.0f, (float)-1.0f);
            GlStateManager.func_179137_b((double)pos.field_72450_a, (double)pos.field_72449_c, (double)0.0);
            GlStateManager.func_179114_b((float)entityLivingBase.func_70079_am(), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179090_x();
            GlStateManager.func_179094_E();
            RenderUtils.applyColorWithAlpha(color, 0.6f * opacity);
            RenderUtils.drawCircle(2.0, 18);
            if (Math.abs(pos.field_72448_b) > 4.0) {
                GL11.glBegin((int)1);
                GL11.glVertex3d((double)0.0, (double)0.0, (double)0.0);
                GL11.glVertex3d((double)0.0, (double)0.0, (double)pos.field_72448_b);
                GL11.glEnd();
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)pos.field_72448_b);
                this.sphere.draw(2.0f * opacity, 6, 6);
                GL11.glNormal3f((float)0.0f, (float)0.0f, (float)1.0f);
            }
            GlStateManager.func_179121_F();
            RenderUtils.applyColorWithAlpha(color, 0.120000005f * opacity);
            RenderUtils.drawCircle(size, 18);
        }
    }

    private int getMinimapSize(EntityLivingBase entityLivingBase) {
        if (entityLivingBase instanceof IMob && entityLivingBase instanceof EntityCreature) {
            return 17;
        }
        return 4;
    }

    private Color getMinimapColor(EntityLivingBase entityLivingBase) {
        if (entityLivingBase instanceof IMob && !entityLivingBase.func_184191_r((Entity)Minecraft.func_71410_x().field_71439_g)) {
            MinimapEntityInfo entityInfo = AndroidPlayer.getMinimapEntityInfo(entityLivingBase);
            if (entityInfo != null && entityInfo.isAttacking()) {
                return Reference.COLOR_GUI_ENERGY;
            }
            return Reference.COLOR_HOLO_RED;
        }
        if (entityLivingBase instanceof EntityPlayer) {
            return Reference.COLOR_HOLO_YELLOW;
        }
        if (entityLivingBase instanceof IMerchant || entityLivingBase.func_184191_r((Entity)Minecraft.func_71410_x().field_71439_g)) {
            return Reference.COLOR_HOLO_GREEN;
        }
        return Reference.COLOR_HOLO;
    }

    private float getScale(ScaledResolution resolution) {
        return 1.5f - 0.2f * (float)resolution.func_78325_e();
    }

    @Override
    public int getWidth(ScaledResolution resolution, AndroidPlayer androidPlayer) {
        return (int)((float)this.width * this.getScale(resolution));
    }

    @Override
    public int getHeight(ScaledResolution resolution, AndroidPlayer androidPlayer) {
        return (int)((float)this.height * this.getScale(resolution));
    }
}

