/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import java.util.List;
import matteroverdrive.Reference;
import matteroverdrive.api.weapon.IWeapon;
import matteroverdrive.client.render.weapons.WeaponItemRenderer;
import matteroverdrive.client.render.weapons.WeaponRenderHandler;
import matteroverdrive.container.ContainerWeaponStation;
import matteroverdrive.container.slot.MOSlot;
import matteroverdrive.data.ScaleTexture;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementInventorySlot;
import matteroverdrive.gui.element.ElementSlot;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.tile.TileEntityWeaponStation;
import matteroverdrive.util.MOInventoryHelper;
import matteroverdrive.util.WeaponHelper;
import matteroverdrive.util.math.MOMathHelper;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class GuiWeaponStation
extends MOGuiMachine<TileEntityWeaponStation> {
    public static final ScaleTexture BG = new ScaleTexture(new ResourceLocation("matteroverdrive:textures/gui/weapon_station.png"), 255, 141).setOffsets(213, 34, 42, 94);
    ElementSlot[] module_slots = new ElementSlot[6];
    String[] module_slots_info = new String[]{"battery", "color", "barrel", "sights", "other", "other"};

    public GuiWeaponStation(InventoryPlayer inventoryPlayer, TileEntityWeaponStation machine) {
        super(new ContainerWeaponStation(inventoryPlayer, machine), machine, 255, 237);
        this.texW = 255;
        this.texH = 237;
        this.name = "weapon_station";
        this.background = BG;
        for (int i = 0; i < this.module_slots.length; ++i) {
            this.module_slots[i] = new ElementInventorySlot((MOGuiBase)this, (MOSlot)this.field_147002_h.func_75139_a(i + 1), 20, 20, "holo", machine.getInventoryContainer().getSlot(i).getHoloIcon());
            this.module_slots[i].setColor(Reference.COLOR_MATTER.getIntR(), Reference.COLOR_MATTER.getIntG(), Reference.COLOR_MATTER.getIntB(), 78);
            this.module_slots[i].setInfo("module." + this.module_slots_info[i] + ".name");
        }
        this.sidePannel.setPosition(243, 33);
        this.closeButton.setPosition(237, 6);
        this.indicator.setPosition(6, 220);
        this.slotsList.getMainSlot().setType("big_main_dark");
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        for (ElementSlot module_slot : this.module_slots) {
            ((ElementBaseGroup)this.pages.get(0)).addElement(module_slot);
        }
        this.AddMainPlayerSlots(this.field_147002_h, this);
        this.AddHotbarPlayerSlots(this.field_147002_h, this);
    }

    @Override
    protected void updateElementInformation() {
        super.updateElementInformation();
        ItemStack item = ((TileEntityWeaponStation)this.machine).func_70301_a(((TileEntityWeaponStation)this.machine).INPUT_SLOT);
        if (WeaponHelper.isWeapon(item)) {
            IWeapon weapon = (IWeapon)item.func_77973_b();
            for (int i = 0; i < this.module_slots.length; ++i) {
                if (weapon.supportsModule(i, item)) {
                    Vector2f pos = weapon.getSlotPosition(i, item);
                    this.module_slots[i].setColor(Reference.COLOR_MATTER.getIntR(), Reference.COLOR_MATTER.getIntG(), Reference.COLOR_MATTER.getIntB(), 78);
                    this.module_slots[i].setPosition((int)pos.x, (int)pos.y);
                    continue;
                }
                this.module_slots[i].setColor(30, 30, 30, 78);
                this.ResetModuleSlotPos(i);
            }
        } else {
            for (int i = 0; i < this.module_slots.length; ++i) {
                this.module_slots[i].setColor(30, 30, 30, 78);
                this.ResetModuleSlotPos(i);
            }
        }
    }

    private void ResetModuleSlotPos(int i) {
        if (i < this.module_slots.length) {
            this.module_slots[i].setPosition(216, 96 + i * 22);
        }
    }

    @Override
    protected void func_146976_a(float partialTick, int x, int y) {
        super.func_146976_a(partialTick, x, y);
        ItemStack item = ((TileEntityWeaponStation)this.machine).func_70301_a(((TileEntityWeaponStation)this.machine).INPUT_SLOT);
        if (WeaponHelper.isWeapon(item) && ((ElementBaseGroup)this.pages.get(0)).isVisible()) {
            ScaledResolution res = new ScaledResolution(this.field_146297_k);
            GlStateManager.func_179126_j();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179129_p();
            WeaponRenderHandler weaponRenderHandler = ClientProxy.renderHandler.getWeaponRenderHandler();
            List<ItemStack> modules = MOInventoryHelper.getStacks(item);
            WeaponItemRenderer weaponItemRenderer = weaponRenderHandler.getWeaponModel(item);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.field_147003_i + 150), (float)(this.field_147009_r + 90), (float)200.0f);
            GlStateManager.func_179152_a((float)180.0f, (float)180.0f, (float)180.0f);
            GlStateManager.func_179114_b((float)-190.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)-140.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)10.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            if (weaponItemRenderer != null) {
                weaponRenderHandler.renderWeaponAndModules(modules, weaponItemRenderer, item, 0.0f);
            }
            GlStateManager.func_179121_F();
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        ItemStack item = ((TileEntityWeaponStation)this.machine).func_70301_a(((TileEntityWeaponStation)this.machine).INPUT_SLOT);
        if (WeaponHelper.isWeapon(item) && ((ElementBaseGroup)this.pages.get(0)).isVisible()) {
            GlStateManager.func_179090_x();
            GlStateManager.func_179094_E();
            GL11.glLineWidth((float)1.0f);
            GlStateManager.func_179131_c((float)Reference.COLOR_MATTER.getFloatR(), (float)Reference.COLOR_MATTER.getFloatG(), (float)Reference.COLOR_MATTER.getFloatB(), (float)1.0f);
            IWeapon weapon = (IWeapon)item.func_77973_b();
            for (int i = 0; i < this.module_slots.length; ++i) {
                if (!weapon.supportsModule(i, item)) continue;
                GL11.glBegin((int)1);
                Vector2f slotPos = weapon.getSlotPosition(i, item);
                Vector2f modulePos = weapon.getModuleScreenPosition(i, item);
                slotPos = this.getClosestOnSlot(slotPos, modulePos);
                GL11.glVertex3f((float)slotPos.x, (float)slotPos.y, (float)400.0f);
                GL11.glVertex3f((float)modulePos.x, (float)modulePos.y, (float)400.0f);
                GL11.glEnd();
            }
            GlStateManager.func_179121_F();
            GlStateManager.func_179098_w();
        }
    }

    Vector2f getClosestOnSlot(Vector2f slotPos, Vector2f modulePos) {
        int slotWidth = 18;
        int slotHeight = 18;
        Vector2f center = new Vector2f(slotPos.x + (float)(slotWidth / 2), slotPos.y + (float)(slotHeight / 2));
        Vector2f intersect = MOMathHelper.Intersects(slotPos, new Vector2f(slotPos.x + (float)slotWidth, slotPos.y), modulePos, center);
        if (intersect != null) {
            return intersect;
        }
        intersect = MOMathHelper.Intersects(slotPos, new Vector2f(slotPos.x, slotPos.y + (float)slotHeight), modulePos, center);
        if (intersect != null) {
            return intersect;
        }
        intersect = MOMathHelper.Intersects(new Vector2f(slotPos.x + (float)slotWidth, slotPos.y + (float)slotHeight), new Vector2f(slotPos.x, slotPos.y + (float)slotHeight), modulePos, center);
        if (intersect != null) {
            return intersect;
        }
        intersect = MOMathHelper.Intersects(new Vector2f(slotPos.x + (float)slotWidth, slotPos.y + (float)slotHeight), new Vector2f(slotPos.x + (float)slotWidth, slotPos.y), modulePos, center);
        if (intersect != null) {
            return intersect;
        }
        return center;
    }
}

