/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import matteroverdrive.MatterOverdrive;
import matteroverdrive.container.ContainerFactory;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.MOGuiMachine;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementIntegerField;
import matteroverdrive.gui.element.ElementMatterStored;
import matteroverdrive.gui.element.ElementTransportList;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.element.MOElementButtonScaled;
import matteroverdrive.gui.element.MOElementEnergy;
import matteroverdrive.gui.element.MOElementTextField;
import matteroverdrive.init.MatterOverdriveCapabilities;
import matteroverdrive.machines.transporter.TileEntityMachineTransporter;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.energy.IEnergyStorage;

public class GuiTransporter
extends MOGuiMachine<TileEntityMachineTransporter> {
    MOElementEnergy energy;
    ElementMatterStored matterStored;
    ElementIntegerField xs;
    ElementIntegerField ys;
    ElementIntegerField zs;
    MOElementButtonScaled importButton;
    MOElementButtonScaled newLocationButton;
    MOElementButtonScaled resetButton;
    MOElementTextField name;
    ElementTransportList list;
    MOElementButtonScaled removeLocation;

    public GuiTransporter(InventoryPlayer inventoryPlayer, TileEntityMachineTransporter machine) {
        super(ContainerFactory.createMachineContainer(machine, inventoryPlayer), machine, 225, 220);
        this.energy = new MOElementEnergy(this, this.field_146999_f - 35, 50, (IEnergyStorage)machine.getEnergyStorage());
        this.matterStored = new ElementMatterStored(this, this.field_146999_f - 35, 100, machine.getCapability(MatterOverdriveCapabilities.MATTER_HANDLER, null));
        this.xs = new ElementIntegerField(this, this, 32, 24, 80, 16);
        this.xs.setName("X");
        this.ys = new ElementIntegerField(this, this, 32, 42, 80, 16);
        this.ys.setName("Y");
        this.zs = new ElementIntegerField(this, this, 32, 60, 80, 16);
        this.zs.setName("Z");
        this.list = new ElementTransportList(this, this, 45, 30, 140, 100, machine);
        this.list.setName("Locations");
        this.name = new MOElementTextField((MOGuiBase)this, this, 38, 4, 74, 16);
        this.name.setTextOffset(6, 4);
        this.name.setBackground(MOElementButton.HOVER_TEXTURE_DARK);
        this.name.setName("LocationName");
        this.importButton = new MOElementButtonScaled(this, this, 22, 82, "Import", 50, 18);
        this.importButton.setNormalTexture(MOElementButton.NORMAL_TEXTURE);
        this.importButton.setOverTexture(MOElementButton.HOVER_TEXTURE);
        this.importButton.setDisabledTexture(MOElementButton.HOVER_TEXTURE_DARK);
        this.importButton.setText(MOStringHelper.translateToLocal("gui.label.button.import", new Object[0]));
        this.resetButton = new MOElementButtonScaled(this, this, 74, 82, "Reset", 50, 18);
        this.resetButton.setNormalTexture(MOElementButton.NORMAL_TEXTURE);
        this.resetButton.setOverTexture(MOElementButton.HOVER_TEXTURE);
        this.resetButton.setText(MOStringHelper.translateToLocal("gui.label.button.reset", new Object[0]));
        this.newLocationButton = new MOElementButtonScaled(this, this, 115, this.field_147000_g - 55, "New", 40, 18);
        this.newLocationButton.setNormalTexture(MOElementButton.NORMAL_TEXTURE);
        this.newLocationButton.setOverTexture(MOElementButton.HOVER_TEXTURE);
        this.newLocationButton.setText(MOStringHelper.translateToLocal("gui.label.button.new", new Object[0]));
        this.removeLocation = new MOElementButtonScaled(this, this, 50, this.field_147000_g - 55, "Remove", 60, 18);
        this.removeLocation.setNormalTexture(MOElementButton.NORMAL_TEXTURE);
        this.removeLocation.setText(MOStringHelper.translateToLocal("gui.label.button.remove", new Object[0]));
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.energy);
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.matterStored);
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.list);
        ((ElementBaseGroup)this.pages.get(1)).addElement(this.xs);
        ((ElementBaseGroup)this.pages.get(1)).addElement(this.ys);
        ((ElementBaseGroup)this.pages.get(1)).addElement(this.zs);
        ((ElementBaseGroup)this.pages.get(1)).addElement(this.importButton);
        ((ElementBaseGroup)this.pages.get(1)).addElement(this.name);
        ((ElementBaseGroup)this.pages.get(1)).addElement(this.resetButton);
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.removeLocation);
        ((ElementBaseGroup)this.pages.get(0)).addElement(this.newLocationButton);
        ((ElementBaseGroup)this.pages.get(1)).getElements().get(0).setPosition(32, 110);
        this.xs.init();
        this.ys.init();
        this.zs.init();
        this.updateInfo();
        this.AddHotbarPlayerSlots(this.field_147002_h, this);
    }

    private void updateInfo() {
        this.list.setSelectedIndex(((TileEntityMachineTransporter)this.machine).selectedLocation);
        this.name.setText(((TileEntityMachineTransporter)this.machine).getSelectedLocation().name);
        this.xs.setBounds(((TileEntityMachineTransporter)this.machine).func_174877_v().func_177958_n() - ((TileEntityMachineTransporter)this.machine).getTransportRange(), ((TileEntityMachineTransporter)this.machine).func_174877_v().func_177958_n() + ((TileEntityMachineTransporter)this.machine).getTransportRange());
        this.ys.setBounds(((TileEntityMachineTransporter)this.machine).func_174877_v().func_177956_o() - ((TileEntityMachineTransporter)this.machine).getTransportRange(), ((TileEntityMachineTransporter)this.machine).func_174877_v().func_177956_o() + ((TileEntityMachineTransporter)this.machine).getTransportRange());
        this.zs.setBounds(((TileEntityMachineTransporter)this.machine).func_174877_v().func_177952_p() - ((TileEntityMachineTransporter)this.machine).getTransportRange(), ((TileEntityMachineTransporter)this.machine).func_174877_v().func_177952_p() + ((TileEntityMachineTransporter)this.machine).getTransportRange());
        if (((TileEntityMachineTransporter)this.machine).getSelectedLocation() != null) {
            this.xs.setNumber(((TileEntityMachineTransporter)this.machine).getSelectedLocation().pos.func_177958_n());
            this.ys.setNumber(((TileEntityMachineTransporter)this.machine).getSelectedLocation().pos.func_177956_o());
            this.zs.setNumber(((TileEntityMachineTransporter)this.machine).getSelectedLocation().pos.func_177952_p());
        } else {
            this.xs.setNumber(0);
            this.ys.setNumber(0);
            this.zs.setNumber(0);
        }
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
        if (((ElementBaseGroup)this.pages.get(1)).isVisible()) {
            this.getFontRenderer().func_78276_b("X:", ((ElementBaseGroup)this.pages.get(1)).getPosX() + this.xs.getPosX() - 10, ((ElementBaseGroup)this.pages.get(1)).getPosY() + this.xs.getPosY() + 4, 0xFFFFFF);
            this.getFontRenderer().func_78276_b(Integer.toString(this.xs.getNumber() - ((TileEntityMachineTransporter)this.machine).func_174877_v().func_177958_n()), ((ElementBaseGroup)this.pages.get(1)).getPosX() + this.xs.getPosX() + this.xs.getWidth() + 4, ((ElementBaseGroup)this.pages.get(1)).getPosY() + this.xs.getPosY() + 4, 0xFFFFFF);
            this.getFontRenderer().func_78276_b("Y:", ((ElementBaseGroup)this.pages.get(1)).getPosX() + this.ys.getPosX() - 10, ((ElementBaseGroup)this.pages.get(1)).getPosY() + this.ys.getPosY() + 4, 0xFFFFFF);
            this.getFontRenderer().func_78276_b(Integer.toString(this.ys.getNumber() - ((TileEntityMachineTransporter)this.machine).func_174877_v().func_177956_o()), ((ElementBaseGroup)this.pages.get(1)).getPosX() + this.ys.getPosX() + this.ys.getWidth() + 4, ((ElementBaseGroup)this.pages.get(1)).getPosY() + this.ys.getPosY() + 4, 0xFFFFFF);
            this.getFontRenderer().func_78276_b("Z:", ((ElementBaseGroup)this.pages.get(1)).getPosX() + this.zs.getPosX() - 10, ((ElementBaseGroup)this.pages.get(1)).getPosY() + this.zs.getPosY() + 4, 0xFFFFFF);
            this.getFontRenderer().func_78276_b(Integer.toString(this.zs.getNumber() - ((TileEntityMachineTransporter)this.machine).func_174877_v().func_177952_p()), ((ElementBaseGroup)this.pages.get(1)).getPosX() + this.zs.getPosX() + this.zs.getWidth() + 4, ((ElementBaseGroup)this.pages.get(1)).getPosY() + this.zs.getPosY() + 4, 0xFFFFFF);
        }
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String buttonName, int mouseButton) {
        super.handleElementButtonClick(element, buttonName, mouseButton);
        if (buttonName.equals("Import")) {
            ItemStack usb = ((TileEntityMachineTransporter)this.machine).func_70301_a(((TileEntityMachineTransporter)this.machine).usbSlotID);
            if (usb != null && MatterOverdrive.ITEMS.transportFlashDrive.hasTarget(usb)) {
                ((TileEntityMachineTransporter)this.machine).setSelectedLocation(MatterOverdrive.ITEMS.transportFlashDrive.getTarget(usb).func_177982_a(0, 1, 0), this.name.getText());
                ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
                this.updateInfo();
            }
        } else if (buttonName.equals("New")) {
            ((TileEntityMachineTransporter)this.machine).addNewLocation(((TileEntityMachineTransporter)this.machine).func_174877_v(), this.name.getText());
            ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
            this.updateInfo();
            this.list.setSelectedIndex(this.list.getElementCount() - 1);
        } else if (buttonName.equals("Reset")) {
            ((TileEntityMachineTransporter)this.machine).setSelectedLocation(((TileEntityMachineTransporter)this.machine).func_174877_v(), ((TileEntityMachineTransporter)this.machine).getSelectedLocation().name);
            ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
            this.updateInfo();
        } else if (buttonName.equals("Remove")) {
            ((TileEntityMachineTransporter)this.machine).removeLocation(this.list.getSelectedIndex());
            ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
            this.updateInfo();
        } else if (buttonName.equals("X") || buttonName.equals("Y") || buttonName.equals("Z")) {
            ((TileEntityMachineTransporter)this.machine).setSelectedLocation(new BlockPos(this.xs.getNumber(), this.ys.getNumber(), this.zs.getNumber()), this.name.getText());
            ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
        }
    }

    @Override
    protected void updateElementInformation() {
        super.updateElementInformation();
        ItemStack usb = ((TileEntityMachineTransporter)this.machine).func_70301_a(((TileEntityMachineTransporter)this.machine).usbSlotID);
        if (usb != null) {
            BlockPos target = MatterOverdrive.ITEMS.transportFlashDrive.getTarget(usb);
            int targetDestination = target != null ? (int)Math.sqrt(target.func_177951_i((Vec3i)((TileEntityMachineTransporter)this.machine).func_174877_v())) : 0;
            int transportRange = ((TileEntityMachineTransporter)this.machine).getTransportRange();
            boolean hasTarget = MatterOverdrive.ITEMS.transportFlashDrive.hasTarget(usb);
            if (!hasTarget || targetDestination > transportRange) {
                this.importButton.setEnabled(false);
                this.importButton.setToolTip(MOStringHelper.translateToLocal("gui.label.button.import.too_far", new Object[0]));
            } else {
                this.importButton.setEnabled(true);
                this.importButton.setToolTip(null);
            }
        } else {
            this.importButton.setEnabled(false);
            this.importButton.setToolTip(null);
        }
    }

    @Override
    public void onPageChange(int newPage) {
        if (newPage == 1) {
            this.updateInfo();
        }
    }

    @Override
    public void ListSelectionChange(String name, int selected) {
        if (name.equals("Locations")) {
            this.updateInfo();
            ((TileEntityMachineTransporter)this.machine).selectedLocation = selected;
            ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
            this.list.setSelectedIndex(((TileEntityMachineTransporter)this.machine).selectedLocation);
        }
    }

    @Override
    public void textChanged(String elementName, String text, boolean typed) {
        if (typed && elementName.equals("LocationName")) {
            ((TileEntityMachineTransporter)this.machine).setSelectedLocation(new BlockPos(this.xs.getNumber(), this.ys.getNumber(), this.zs.getNumber()), this.name.getText());
            ((TileEntityMachineTransporter)this.machine).sendConfigsToServer(true);
        }
    }
}

