/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import java.util.ArrayList;
import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.Reference;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.container.ContainerFalse;
import matteroverdrive.data.quest.rewards.ItemStackReward;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.ElementBaseGroup;
import matteroverdrive.gui.element.ElementItemPreview;
import matteroverdrive.gui.element.ElementScrollGroup;
import matteroverdrive.gui.element.ElementTextList;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementButtonScaled;
import matteroverdrive.network.packet.server.PacketQuestActions;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.RenderUtils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GuiQuestPreview
extends MOGuiBase {
    public static final ResourceLocation backgroundTexture = new ResourceLocation("matteroverdrive:textures/gui/contract.png");
    ElementTextList questInfo;
    ElementScrollGroup questInfoGroup;
    QuestStack questStack;
    ElementBaseGroup questRewards;
    MOElementButtonScaled acceptButton;

    public GuiQuestPreview(QuestStack questStack) {
        super(new ContainerFalse(), 200, 225);
        this.background = null;
        this.questInfo = new ElementTextList(this, 0, 0, this.field_146999_f - 18 - 14, -11511976, false);
        this.questInfoGroup = new ElementScrollGroup(this, 18, 68, this.field_146999_f - 18 - 14, 120);
        this.questInfoGroup.setScrollerColor(-11511976);
        this.questRewards = new ElementBaseGroup(this, 8, 8, this.field_146294_l - 15, 24);
        this.questRewards.setName("Quest Rewards");
        this.questInfoGroup.addElement(this.questInfo);
        this.questInfoGroup.addElement(this.questRewards);
        this.acceptButton = new MOElementButtonScaled(this, this, 14, this.field_147000_g - 28, "accept_quest", 68, 12);
        this.acceptButton.setDownTexture(null);
        this.acceptButton.setOverTexture(null);
        this.acceptButton.setNormalTexture(null);
        this.acceptButton.setText(String.format("[ %s ]", MOStringHelper.translateToLocal("gui.label.accept", new Object[0])));
        this.acceptButton.setToolTip(MOStringHelper.translateToLocal("gui.tooltip.quest.accept", new Object[0]));
        this.acceptButton.setTextColor(0x5656FF);
        if (!questStack.canAccept((EntityPlayer)Minecraft.func_71410_x().field_71439_g, questStack)) {
            this.acceptButton.setEnabled(false);
            this.acceptButton.setTextColor(Reference.COLOR_HOLO_RED.getColor());
        }
        this.questStack = questStack;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.elements.remove(this.sidePannel);
        this.elements.remove(this.closeButton);
        this.addElement(this.questInfoGroup);
        this.addElement(this.acceptButton);
        this.loadQuestInfo(this.questStack);
    }

    @Override
    protected void func_146976_a(float partialTick, int x, int y) {
        this.bindTexture(backgroundTexture);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtils.drawPlane(this.field_147003_i, this.field_147009_r, 0.0, this.field_146999_f, this.field_147000_g);
        if (this.questStack != null) {
            String questName = this.questStack.getTitle((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
            int titleWidth = ClientProxy.moFontRender.func_78256_a(questName);
            float scale = Math.min(100.0f / (float)titleWidth, 1.8f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(this.field_147003_i + 24), (float)(this.field_147009_r + 30), (float)0.0f);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            ClientProxy.moFontRender.func_78276_b(TextFormatting.BOLD + questName, 0, 0, 2331875);
            GlStateManager.func_179121_F();
        }
        super.func_146976_a(partialTick, x, y);
    }

    private void loadQuestInfo(QuestStack questStack) {
        int width = 165;
        this.questInfo.clearLines();
        String info = questStack.getInfo((EntityPlayer)Minecraft.func_71410_x().field_71439_g).replace("/n/", "\n");
        List list = ClientProxy.moFontRender.func_78271_c(info, width);
        for (String s : list) {
            this.questInfo.addLine(s);
        }
        this.questInfo.addLine("");
        for (int i = 0; i < questStack.getObjectivesCount((EntityPlayer)Minecraft.func_71410_x().field_71439_g); ++i) {
            List<String> objectiveLines = MatterOverdrive.QUEST_FACTORY.getFormattedQuestObjective((EntityPlayer)Minecraft.func_71410_x().field_71439_g, questStack, i, width, TextFormatting.BLUE.toString(), TextFormatting.BLUE.toString());
            this.questInfo.addLines(objectiveLines);
        }
        this.questInfo.addLine("");
        this.questInfo.addLine(TextFormatting.DARK_PURPLE + "Rewards:");
        this.questInfo.addLine(String.format(TextFormatting.DARK_PURPLE + "   +%sxp", questStack.getXP((EntityPlayer)Minecraft.func_71410_x().field_71439_g)));
        ArrayList<IQuestReward> rewards = new ArrayList<IQuestReward>();
        questStack.addRewards(rewards, (EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        this.questRewards.getElements().clear();
        this.questRewards.setSize(this.questRewards.getWidth(), rewards.size() > 0 ? 20 : 0);
        for (int i = 0; i < rewards.size(); ++i) {
            if (!(rewards.get(i) instanceof ItemStackReward) || !((IQuestReward)rewards.get(i)).isVisible(questStack)) continue;
            ElementItemPreview itemPreview = new ElementItemPreview(this, i * 20, 1, ((ItemStackReward)rewards.get(i)).getItemStack());
            itemPreview.setItemSize(1.0f);
            itemPreview.setRenderOverlay(true);
            itemPreview.setSize(18, 18);
            itemPreview.setDrawTooltip(true);
            itemPreview.setBackground(null);
            this.questRewards.addElement(itemPreview);
        }
    }

    @Override
    public void ListSelectionChange(String name, int selected) {
    }

    @Override
    public void textChanged(String elementName, String text, boolean typed) {
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String elementName, int mouseButton) {
        super.handleElementButtonClick(element, elementName, mouseButton);
        if (element == this.acceptButton) {
            MatterOverdrive.NETWORK.sendToServer(new PacketQuestActions(2, this.field_146297_k.field_71439_g.field_71071_by.field_70461_c, (EntityPlayer)this.field_146297_k.field_71439_g));
            this.field_146297_k.field_71439_g.func_71053_j();
        }
    }
}

