/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.gui;

import java.util.List;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.container.ContainerFalse;
import matteroverdrive.data.matter_network.ItemPattern;
import matteroverdrive.gui.MOGuiBase;
import matteroverdrive.gui.element.MOElementBase;
import matteroverdrive.gui.element.MOElementButton;
import matteroverdrive.gui.pages.PageScanInfo;
import matteroverdrive.items.MatterScanner;
import matteroverdrive.network.packet.bi.PacketMatterScannerGetDatabase;
import matteroverdrive.network.packet.server.PacketMatterScannerUpdate;
import matteroverdrive.proxy.ClientProxy;
import matteroverdrive.util.MOStringHelper;
import matteroverdrive.util.TimeTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class GuiMatterScanner
extends MOGuiBase {
    public static final String QUIDE_ELEMENTS_NAME = "GUIDE_ENTRY";
    private static final int REFRESH_DEPLAY = 200;
    public ItemStack scanner;
    public int databaseSlot;
    int lastPage = 0;
    PageScanInfo pageScanInfo;
    TimeTracker refreshTimeTracker;
    ItemPattern lastSelected;
    MOElementButton infoPageButton;
    MOElementButton scanPageButton;

    public GuiMatterScanner(ItemStack scanner, int slot) {
        super(new ContainerFalse(), 300, 230);
        this.scanner = scanner;
        this.registerPages(this, scanner);
        this.refreshTimeTracker = new TimeTracker();
        this.databaseSlot = slot;
        this.lastPage = MatterScanner.getLastPage(scanner);
        MatterOverdrive.NETWORK.sendToServer(new PacketMatterScannerGetDatabase(MatterScanner.getLinkPosition(scanner)));
    }

    @Override
    public void func_73866_w_() {
        this.currentPage = MatterScanner.getLastPage(this.scanner);
        super.func_73866_w_();
        this.updateSelected(this.scanner);
    }

    private void registerPages(GuiMatterScanner gui, ItemStack matterScanner) {
        this.pageScanInfo = new PageScanInfo(this, 0, 0, "Scan Info", null, this.scanner);
        this.updateSelected(this.scanner);
        this.pageScanInfo.setSize(this.field_146999_f, this.field_147000_g);
        this.AddPage(this.pageScanInfo, ClientProxy.holoIcons.getIcon("page_icon_info"), MOStringHelper.translateToLocal("gui.tooltip.page.scan_info", new Object[0]));
    }

    @Override
    protected void updateElementInformation() {
        super.updateElementInformation();
        if (this.refreshTimeTracker.hasDelayPassed((World)Minecraft.func_71410_x().field_71441_e, 200)) {
            this.updateSelected(this.scanner);
        }
    }

    public void UpdatePatternList(List<ItemPattern> list) {
        this.pageScanInfo.updateList(list);
    }

    private ItemPattern getSelectedFromDatabase(ItemStack scanner) {
        return MatterScanner.getSelectedAsPattern(scanner);
    }

    private void updateSelected(ItemStack scanner) {
        this.lastSelected = this.getSelectedFromDatabase(scanner);
        this.pageScanInfo.setItemNBT(this.lastSelected);
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        this.drawElements(0.0f, true);
    }

    @Override
    public void handleElementButtonClick(MOElementBase element, String buttonName, int mouseButton) {
        super.handleElementButtonClick(element, buttonName, mouseButton);
        if (buttonName.equals("scroll_up")) {
            this.pageScanInfo.list.scrollUp();
        } else if (buttonName.equals("scroll_down")) {
            this.pageScanInfo.list.scrollDown();
        } else if (buttonName.equals("list")) {
            ItemPattern elementTag = (ItemPattern)this.pageScanInfo.list.getElement(mouseButton).getValue();
            this.SetSelected(elementTag);
        }
    }

    @Override
    public void handleListChange(String listName, int mouseButton, int element) {
        if (listName == QUIDE_ELEMENTS_NAME) {
            // empty if block
        }
    }

    @Override
    public void setPage(int page) {
        super.setPage(page);
        if (this.scanner.func_77942_o()) {
            this.scanner.func_77978_p().func_74777_a("page", (short)page);
        }
    }

    void SetSelected(ItemPattern tagCompound) {
        this.lastSelected = tagCompound;
        this.pageScanInfo.setItemNBT(tagCompound);
    }

    public void func_146281_b() {
        super.func_146281_b();
        if (MatterScanner.getSelectedAsPattern(this.scanner).equals(this.lastSelected)) {
            MatterOverdrive.NETWORK.sendToServer(new PacketMatterScannerUpdate(this.scanner, (short)this.databaseSlot));
        }
    }

    @Override
    public void textChanged(String elementName, String text, boolean typed) {
    }

    @Override
    public void ListSelectionChange(String name, int selected) {
    }
}

