/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.fx;

import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import matteroverdrive.Reference;
import matteroverdrive.fx.MOEntityFX;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Lightning
extends MOEntityFX {
    private float randomness;
    private Vector3d destination;
    private float length;
    private float speed;

    public Lightning(World worldIn, Vec3d start, Vec3d destination) {
        this(worldIn, start, destination, 1.0f, 1.0f);
        this.setColorRGBA(Reference.COLOR_HOLO.multiplyWithoutAlpha(0.5f));
    }

    public Lightning(World worldIn, Vec3d start, Vec3d destination, float randomness, float speed) {
        super(worldIn, start.field_72450_a, start.field_72448_b, start.field_72449_c);
        this.destination = new Vector3d(destination.field_72450_a, destination.field_72448_b, destination.field_72449_c);
        this.length = (float)destination.func_72438_d(new Vec3d(this.field_187126_f, this.field_187127_g, this.field_187128_h));
        this.field_70547_e = 10 + (int)(this.field_187136_p.nextFloat() * 10.0f);
        this.randomness = randomness;
        this.speed = speed;
        this.func_187108_a(new AxisAlignedBB(start.field_72450_a, start.field_72448_b, start.field_72449_c, destination.field_72450_a, destination.field_72448_b, destination.field_72449_c));
        this.renderDistanceWeight = (float)Minecraft.func_71410_x().field_71474_y.field_151451_c / 6.0f;
    }

    public void func_180434_a(BufferBuilder worldRendererIn, Entity entityIn, float partialTicks, float rotX, float rotXZ, float rotZ, float rotYZ, float rotXY) {
        this.field_187136_p.setSeed((long)((float)this.field_70546_d * this.speed) + (long)((Object)((Object)this)).hashCode());
        Vector3d lastPos = new Vector3d(this.field_187123_c, this.field_187124_d, this.field_187125_e);
        float i = 0.0f;
        while (i < this.length) {
            float time = 1.0f - i / this.length;
            float randMag = (float)Math.sin((double)time * Math.PI) * this.randomness;
            double tickX = (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an;
            double tickY = (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao;
            double tickZ = (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap;
            Vector3d randomDir = new Vector3d(this.field_187136_p.nextGaussian(), this.field_187136_p.nextGaussian(), this.field_187136_p.nextGaussian());
            randomDir.scale((double)randMag);
            Vector3d toDestDir = new Vector3d(this.destination);
            toDestDir.sub((Tuple3d)lastPos);
            toDestDir.normalize();
            Vector3d dir = new Vector3d(toDestDir);
            dir.add((Tuple3d)randomDir);
            dir.scale(0.1);
            Vector3d pos = new Vector3d(lastPos);
            pos.add((Tuple3d)dir);
            int b = this.func_189214_a(partialTicks);
            int j = b >> 16 & 0xFFFF;
            int k = b & 0xFFFF;
            worldRendererIn.func_181662_b(lastPos.x + tickX, lastPos.y + tickY, lastPos.z + tickZ).func_187315_a(0.0, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            worldRendererIn.func_181662_b(pos.x + tickX, pos.y + tickY, pos.z + tickZ).func_187315_a(0.0, 0.0).func_181666_a(this.field_70552_h, this.field_70553_i, this.field_70551_j, this.field_82339_as).func_187314_a(j, k).func_181675_d();
            lastPos = pos;
            i = (float)((double)i + 0.1);
        }
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        if (this.field_70546_d++ >= this.field_70547_e) {
            this.func_187112_i();
        }
    }
}

