/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity.monster;

import com.google.common.base.Predicate;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.entity.IRangedEnergyWeaponAttackMob;
import matteroverdrive.api.weapon.WeaponShot;
import matteroverdrive.entity.ai.AndroidTargetSelector;
import matteroverdrive.entity.ai.EntityAIMoveAlongPath;
import matteroverdrive.entity.ai.EntityAIPhaserBoltAttack;
import matteroverdrive.entity.ai.EntityAIRangedRunFromMelee;
import matteroverdrive.entity.monster.EntityRogueAndroid;
import matteroverdrive.entity.monster.EntityRougeAndroidMob;
import matteroverdrive.items.android.RougeAndroidParts;
import matteroverdrive.items.includes.EnergyContainer;
import matteroverdrive.items.weapon.EnergyWeapon;
import matteroverdrive.network.packet.bi.PacketFirePlasmaShot;
import matteroverdrive.util.AndroidPartsFactory;
import matteroverdrive.util.WeaponFactory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityRangedRogueAndroidMob
extends EntityRougeAndroidMob
implements IRangedEnergyWeaponAttackMob {
    public static boolean DROP_NORMAL_WEAPONS = true;
    public static boolean DROP_LEGENDARY_WEAPONS = true;
    public static boolean UNLIMITED_WEAPON_ENERGY = true;
    private final EntityAIPhaserBoltAttack aiBoltAttack = new EntityAIPhaserBoltAttack(this, 1.0, 60, 15.0f);
    private final EntityAIRangedRunFromMelee aiRangedRunFromMelee = new EntityAIRangedRunFromMelee((EntityCreature)this, 1.0);

    public EntityRangedRogueAndroidMob(World world) {
        super(world);
        this.init(world);
    }

    public EntityRangedRogueAndroidMob(World world, int level, boolean legendary) {
        super(world, level, legendary);
        this.init(world);
    }

    protected void init(World world) {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)this.aiRangedRunFromMelee);
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)this.aiBoltAttack);
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIMoveAlongPath(this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 8.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityLivingBase.class, 0, true, true, (Predicate)new AndroidTargetSelector(this)));
        if (world != null && !world.field_72995_K) {
            this.setCombatTask();
        }
    }

    protected void func_82160_b(boolean recentlyHit, int lootingLevel) {
        int j;
        if (EntityRogueAndroid.dropItems && this.field_70718_bc > 0 && DROP_NORMAL_WEAPONS && ((j = this.field_70146_Z.nextInt(400) - lootingLevel) < 5 || this.getIsLegendary())) {
            this.func_70099_a(this.func_184582_a(EntityEquipmentSlot.MAINHAND).func_77946_l(), 0.0f);
        }
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(24.0);
    }

    protected void func_70628_a(boolean recentlyHit, int lootingLevel) {
        if (EntityRogueAndroid.dropItems && (!this.hasTeam() || recentlyHit)) {
            int j = this.field_70146_Z.nextInt(2 + lootingLevel);
            for (int k = 0; k < j; ++k) {
                this.func_145779_a(MatterOverdrive.ITEMS.energyPack, 1);
            }
            float lootingModifier = (float)Math.min(lootingLevel, 10) / 10.0f;
            if (this.field_70146_Z.nextFloat() < 0.15f + lootingModifier || this.getIsLegendary()) {
                ItemStack part = MatterOverdrive.ANDROID_PARTS_FACTORY.generateRandomDecoratedPart(new AndroidPartsFactory.AndroidPartFactoryContext(this.getAndroidLevel(), (Entity)this, this.getIsLegendary()));
                if (part.func_77973_b() instanceof RougeAndroidParts) {
                    part.func_77982_d(new NBTTagCompound());
                    part.func_77978_p().func_74774_a("Type", (byte)1);
                }
                this.func_70099_a(part, 0.0f);
            }
        }
    }

    @Override
    public void addRandomArmor() {
        super.addRandomArmor();
        int androidLevel = this.getAndroidLevel();
        ItemStack gun = MatterOverdrive.WEAPON_FACTORY.getRandomDecoratedEnergyWeapon(new WeaponFactory.WeaponGenerationContext(androidLevel, (Entity)this, this.getIsLegendary()));
        this.func_184201_a(EntityEquipmentSlot.MAINHAND, gun);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a((double)(((EnergyWeapon)gun.func_77973_b()).getRange(gun) - 2));
    }

    public void setCombatTask() {
        ItemStack itemstack = this.func_184586_b(EnumHand.MAIN_HAND);
        if (itemstack != null && itemstack.func_77973_b() instanceof EnergyWeapon) {
            this.aiBoltAttack.setMaxChaseDistance(((EnergyWeapon)itemstack.func_77973_b()).getRange(itemstack) - 2);
            if (itemstack.func_77973_b() == MatterOverdrive.ITEMS.ionSniper) {
                this.aiRangedRunFromMelee.setMinDistance(16.0);
            } else if (itemstack.func_77973_b() != MatterOverdrive.ITEMS.plasmaShotgun) {
                this.aiRangedRunFromMelee.setMinDistance(3.0);
            }
        }
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        livingdata = super.func_180482_a(difficulty, livingdata);
        this.addRandomArmor();
        this.func_180483_b(difficulty);
        return livingdata;
    }

    @Override
    public void attackEntityWithRangedAttack(EntityLivingBase target, Vec3d lastSeenPosition, boolean canSee) {
        ItemStack weapon = this.func_184586_b(EnumHand.MAIN_HAND);
        if (!this.field_70170_p.field_72995_K) {
            if (lastSeenPosition == null) {
                lastSeenPosition = target.func_174791_d();
            }
            if (weapon.func_77973_b() instanceof EnergyWeapon) {
                EnergyWeapon energyWeapon = (EnergyWeapon)weapon.func_77973_b();
                Vec3d pos = new Vec3d(this.field_70165_t, this.field_70163_u + (double)this.func_70047_e(), this.field_70161_v);
                Vec3d dir = lastSeenPosition.func_178788_d(this.func_174791_d());
                WeaponShot shot = energyWeapon.createServerShot(weapon, (EntityLivingBase)this, true);
                float difficulty = MathHelper.func_76131_a((float)(0.2f * (float)this.field_70170_p.func_175659_aa().func_151525_a()), (float)0.0f, (float)0.6f) + (float)this.getAndroidLevel() * 0.13333334f + (this.getIsLegendary() ? 0.3f : 0.0f);
                shot.setDamage(shot.getDamage() * difficulty);
                difficulty = (float)(3 - this.field_70170_p.func_175659_aa().func_151525_a()) * 4.0f;
                shot.setAccuracy(shot.getAccuracy() + difficulty);
                energyWeapon.onServerFire(weapon, (EntityLivingBase)this, shot, pos, dir, 0);
                energyWeapon.setHeat(weapon, 0.0f);
                if (UNLIMITED_WEAPON_ENERGY) {
                    ((EnergyContainer)EnergyWeapon.getStorage(weapon)).setFull();
                }
                MatterOverdrive.NETWORK.sendToAllAround(new PacketFirePlasmaShot(this.func_145782_y(), pos, dir, shot), this.field_70170_p.field_73011_w.getDimension(), this.field_70165_t, this.field_70163_u, this.field_70161_v, 64.0);
                difficulty = 1.0f + (float)(3 - this.field_70170_p.func_175659_aa().func_151525_a()) * 0.5f;
                this.aiBoltAttack.setMaxRangedAttackDelay((int)((float)((EnergyWeapon)weapon.func_77973_b()).getShootCooldown(weapon) * difficulty));
            }
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.setCombatTask();
    }

    @Override
    public ItemStack getWeapon() {
        return this.func_184586_b(EnumHand.MAIN_HAND);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d1 = this.func_174813_aQ().func_72320_b();
        d1 *= 64.0 * Entity.func_184183_bd();
        return p_70112_1_ < (d1 += this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111126_e()) * d1;
    }
}

