/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.entity;

import com.google.common.base.Optional;
import java.util.UUID;
import matteroverdrive.entity.ai.EntityAIFollowCreator;
import matteroverdrive.entity.ai.PathNavigateFly;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.scoreboard.Team;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public class EntityDrone
extends EntityCreature
implements IEntityOwnable {
    protected static final DataParameter<Optional<UUID>> OWNER_UNIQUE_ID = EntityDataManager.func_187226_a(EntityDrone.class, (DataSerializer)DataSerializers.field_187203_m);
    private BlockPos targetPos;
    private EntityLivingBase owner;

    public EntityDrone(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.5f, 0.5f);
        this.field_70765_h = new DroneMoveHelper(this);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLivingBase.class, 8.0f));
        this.field_70714_bg.func_75776_a(3, new EntityAIFollowCreator<EntityDrone>(this, 0.2f, 5.0f, 3.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER_UNIQUE_ID, (Object)Optional.absent());
    }

    public PathNavigate func_70661_as() {
        return this.field_70699_by;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (this.func_184753_b() != null) {
            if (!this.field_70170_p.field_72995_K) {
                this.setOwnerId(player.func_110124_au());
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return true;
        }
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.targetPos != null) {
            // empty if block
        }
        if (!this.func_70661_as().func_75500_f()) {
            Vec3d vec3d = this.func_70661_as().func_75505_d().func_75878_a((Entity)this);
        }
        if (this.field_70170_p.field_72995_K && this.field_70173_aa % 2 == 0) {
            int motionSpeed = Math.min(6, (int)(Math.sqrt(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y) * 30.0));
            Vec3d look = this.func_70676_i(1.0f);
            for (int i = 0; i < motionSpeed; ++i) {
                this.field_70170_p.func_175688_a(EnumParticleTypes.CRIT_MAGIC, this.field_70165_t - look.field_72450_a * 0.25, this.field_70163_u + (double)this.func_70047_e() + 0.2 - look.field_72448_b * 0.2, this.field_70161_v - look.field_72449_c * 0.2, -this.field_70159_w * 2.0, -this.field_70181_x * 2.0, -this.field_70179_y * 2.0, new int[0]);
            }
        }
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        super.func_70014_b(tagCompound);
        tagCompound.func_74772_a("target", this.targetPos.func_177986_g());
        if (this.func_184753_b() == null) {
            tagCompound.func_74778_a("OwnerUUID", "");
        } else {
            tagCompound.func_74778_a("OwnerUUID", this.func_184753_b().toString());
        }
    }

    public void func_70037_a(NBTTagCompound tagCompound) {
        super.func_70037_a(tagCompound);
        if (tagCompound.func_74764_b("target")) {
            this.targetPos = BlockPos.func_177969_a((long)tagCompound.func_74763_f("target"));
        }
        String s = "";
        if (tagCompound.func_150297_b("OwnerUUID", 8)) {
            s = tagCompound.func_74779_i("OwnerUUID");
        } else {
            String s1 = tagCompound.func_74779_i("Owner");
            s = PreYggdrasilConverter.func_187473_a((MinecraftServer)this.func_184102_h(), (String)s1);
        }
        if (s.length() > 0) {
            this.setOwnerId(UUID.fromString(s));
        }
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected PathNavigate func_175447_b(World worldIn) {
        return new PathNavigateFly((EntityLiving)this, worldIn);
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, IBlockState state, BlockPos pos) {
    }

    public boolean func_70617_f_() {
        return false;
    }

    public boolean func_145773_az() {
        return true;
    }

    public float func_70047_e() {
        return this.field_70131_O / 2.0f;
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, IEntityLivingData livingdata) {
        this.targetPos = this.func_180425_c();
        return livingdata;
    }

    public UUID func_184753_b() {
        Optional uuid = (Optional)this.field_70180_af.func_187225_a(OWNER_UNIQUE_ID);
        return uuid.isPresent() ? (UUID)uuid.get() : null;
    }

    public void setOwnerId(UUID ownerUuid) {
        this.field_70180_af.func_187227_b(OWNER_UNIQUE_ID, (Object)Optional.of((Object)ownerUuid));
    }

    public EntityLivingBase getOwner() {
        try {
            UUID uuid = this.func_184753_b();
            return uuid == null ? null : this.field_70170_p.func_152378_a(uuid);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean isOwner(EntityLivingBase entityIn) {
        return entityIn == this.getOwner();
    }

    public Team func_96124_cp() {
        EntityLivingBase entitylivingbase = this.getOwner();
        if (entitylivingbase != null) {
            return entitylivingbase.func_96124_cp();
        }
        return super.func_96124_cp();
    }

    public boolean isOnSameTeam(EntityLivingBase otherEntity) {
        EntityLivingBase entitylivingbase = this.getOwner();
        if (otherEntity == entitylivingbase) {
            return true;
        }
        if (entitylivingbase != null) {
            return entitylivingbase.func_184191_r((Entity)otherEntity);
        }
        return super.func_184191_r((Entity)otherEntity);
    }

    static class DroneMoveHelper
    extends EntityMoveHelper {
        private EntityDrone parentEntity;
        private int courseChangeCooldown;

        public DroneMoveHelper(EntityDrone entityDrone) {
            super((EntityLiving)entityDrone);
            this.parentEntity = entityDrone;
        }

        public void func_75641_c() {
            if (this.field_188491_h == EntityMoveHelper.Action.MOVE_TO) {
                int i = MathHelper.func_76128_c((double)(this.field_75648_a.func_174813_aQ().field_72338_b + 0.5));
                double d0 = this.field_75646_b - this.parentEntity.field_70165_t;
                double d1 = this.field_75647_c - (double)i;
                double d2 = this.field_75644_d - this.parentEntity.field_70161_v;
                double d3 = d0 * d0 + d1 * d1 + d2 * d2;
                float f = MathHelper.func_76133_a((double)(this.field_75646_b * this.field_75646_b + this.field_75647_c * this.field_75647_c));
                this.parentEntity.field_70126_B = this.parentEntity.field_70177_z = (float)(MathHelper.func_181159_b((double)this.field_75646_b, (double)this.field_75644_d) * 180.0 / Math.PI);
                this.parentEntity.field_70127_C = this.parentEntity.field_70125_A = (float)(MathHelper.func_181159_b((double)this.field_75647_c, (double)f) * 180.0 / Math.PI);
                d3 = MathHelper.func_76133_a((double)d3);
                this.parentEntity.field_70159_w = d0 / d3 * this.field_75645_e;
                this.parentEntity.field_70181_x = d1 / d3 * this.field_75645_e;
                this.parentEntity.field_70179_y = d2 / d3 * this.field_75645_e;
                this.field_188491_h = EntityMoveHelper.Action.WAIT;
            }
        }
    }
}

