/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.transport;

import java.util.ArrayList;
import java.util.List;
import matteroverdrive.api.matter_network.IMatterNetworkClient;
import matteroverdrive.api.matter_network.IMatterNetworkConnection;
import matteroverdrive.api.transport.IGridNetwork;
import matteroverdrive.data.matter_network.IMatterNetworkEvent;
import matteroverdrive.data.transport.AbstractGridNetwork;
import matteroverdrive.handler.matter_network.MatterNetworkHandler;

public class MatterNetwork
extends AbstractGridNetwork<IMatterNetworkConnection> {
    List<IMatterNetworkClient> clients = new ArrayList<IMatterNetworkClient>();

    public MatterNetwork(MatterNetworkHandler handler) {
        super(handler, IMatterNetworkConnection.class);
    }

    @Override
    protected void onNodeAdded(IMatterNetworkConnection node) {
        if (node instanceof IMatterNetworkClient) {
            IMatterNetworkClient client = (IMatterNetworkClient)((Object)node);
            this.post(new IMatterNetworkEvent.ClientAdded(client));
            this.clients.add(client);
            client.getMatterNetworkComponent().onNetworkEvent(new IMatterNetworkEvent.AddedToNetwork());
        }
    }

    @Override
    protected void onNodeRemoved(IMatterNetworkConnection node) {
        if (node instanceof IMatterNetworkClient) {
            IMatterNetworkClient client = (IMatterNetworkClient)((Object)node);
            this.post(new IMatterNetworkEvent.ClientRemoved(client));
            this.clients.remove(client);
            client.getMatterNetworkComponent().onNetworkEvent(new IMatterNetworkEvent.RemovedFromNetwork());
        }
    }

    public void post(IMatterNetworkEvent event) {
        for (IMatterNetworkClient client : this.clients) {
            client.getMatterNetworkComponent().onNetworkEvent(event);
        }
    }

    public void post(IMatterNetworkClient poster, IMatterNetworkEvent event) {
        for (IMatterNetworkClient client : this.clients) {
            client.getMatterNetworkComponent().onNetworkEvent(event);
        }
    }

    @Override
    public void recycle() {
        this.clients.clear();
        super.recycle();
    }

    @Override
    public boolean canMerge(IGridNetwork network) {
        return true;
    }

    public List<IMatterNetworkClient> getClients() {
        return this.clients;
    }
}

