/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.rewards;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.quest.IQuest;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.entity.player.MOPlayerCapabilityProvider;
import matteroverdrive.entity.player.OverdriveExtendedProperties;
import matteroverdrive.util.MOJsonHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class QuestStackReward
implements IQuestReward {
    QuestStack questStack;
    String questName;
    NBTTagCompound questNbt;
    String[] copyNBT;
    boolean visible;

    public QuestStackReward() {
    }

    public QuestStackReward(QuestStack questStack) {
        this.questStack = questStack;
    }

    public QuestStackReward setCopyNBT(String ... copyNBT) {
        this.copyNBT = copyNBT;
        return this;
    }

    @Override
    public void loadFromJson(JsonObject object) {
        this.questName = MOJsonHelper.getString(object, "id");
        this.questNbt = MOJsonHelper.getNbt(object, "nbt", null);
        if (object.has("copy_nbt") && object.get("copy_nbt").isJsonArray()) {
            JsonArray array = object.get("copy_nbt").getAsJsonArray();
            String[] elements = new String[array.size()];
            for (int i = 0; i < elements.length; ++i) {
                elements[i] = array.get(i).getAsString();
            }
            this.copyNBT = elements;
        }
        this.visible = MOJsonHelper.getBool(object, "visible", true);
    }

    @Override
    public void giveReward(QuestStack completedQuest, EntityPlayer entityPlayer) {
        OverdriveExtendedProperties extendedProperties;
        QuestStack questStack = this.getQuestStack();
        if (questStack != null && questStack.canAccept(entityPlayer, questStack) && (extendedProperties = MOPlayerCapabilityProvider.GetExtendedCapability((Entity)entityPlayer)) != null) {
            QuestStack questStackCopy = questStack.copy();
            questStackCopy.getQuest().initQuestStack(entityPlayer.func_70681_au(), questStackCopy);
            if (this.copyNBT != null && this.copyNBT.length > 0 && completedQuest.getTagCompound() != null) {
                if (questStackCopy.getTagCompound() == null) {
                    questStackCopy.setTagCompound(new NBTTagCompound());
                }
                for (String aCopyNBT : this.copyNBT) {
                    NBTBase nbtBase = completedQuest.getTagCompound().func_74781_a(aCopyNBT);
                    if (nbtBase == null) continue;
                    questStackCopy.getTagCompound().func_74782_a(aCopyNBT, nbtBase.func_74737_b());
                }
            }
            extendedProperties.addQuest(questStackCopy);
        }
    }

    @Override
    public boolean isVisible(QuestStack questStack) {
        return this.visible;
    }

    public QuestStack getQuestStack() {
        if (this.questStack == null) {
            IQuest quest = MatterOverdrive.QUESTS.getQuestByName(this.questName);
            if (quest != null) {
                QuestStack questStack = new QuestStack(quest);
                if (this.questNbt != null) {
                    questStack.setTagCompound(this.questNbt);
                }
                return questStack;
            }
        } else {
            return this.questStack;
        }
        return null;
    }
}

