/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import matteroverdrive.MatterOverdrive;
import matteroverdrive.api.dialog.IDialogNpc;
import matteroverdrive.api.dialog.IDialogOption;
import matteroverdrive.api.events.MOEventDialogConstruct;
import matteroverdrive.api.events.MOEventDialogInteract;
import matteroverdrive.api.exceptions.MORuntimeException;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestLogicState;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.data.dialog.DialogMessage;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import matteroverdrive.util.MOJsonHelper;
import matteroverdrive.util.MOStringHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.eventhandler.Event;

public class QuestLogicConversation
extends AbstractQuestLogic {
    String regex;
    String npcType;
    IDialogOption[] given;
    IDialogOption targetOption;

    public QuestLogicConversation() {
    }

    public QuestLogicConversation(String npcType, DialogMessage targetOption, DialogMessage ... given) {
        this.npcType = npcType;
        this.targetOption = targetOption;
        this.given = given;
    }

    @Override
    public void loadFromJson(JsonObject jsonObject) {
        super.loadFromJson(jsonObject);
        this.npcType = MOJsonHelper.getString(jsonObject, "npc");
        if (jsonObject.has("given")) {
            JsonArray givenArray = jsonObject.getAsJsonArray("given");
            this.given = new IDialogOption[givenArray.size()];
            for (int i = 0; i < givenArray.size(); ++i) {
                this.given[i] = MatterOverdrive.DIALOG_ASSEMBLER.parseOption(givenArray.get(i), MatterOverdrive.DIALOG_REGISTRY);
            }
        }
        if (jsonObject.has("target")) {
            this.targetOption = MatterOverdrive.DIALOG_ASSEMBLER.parseOption(jsonObject.get("target"), MatterOverdrive.DIALOG_REGISTRY);
            if (this.targetOption == null) {
                throw new MORuntimeException("Conversation Quest Logic mush have a target dialog option");
            }
        }
        this.regex = MOJsonHelper.getString(jsonObject, "regex", null);
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        info = info.replace("$target", MOStringHelper.translateToLocal("entity." + this.npcType + ".name", new Object[0]));
        return info;
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        return this.hasTalked(questStack);
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        objective = objective.replace("$target", MOStringHelper.translateToLocal("entity." + this.npcType + ".name", new Object[0]));
        return objective;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
    }

    @Override
    public QuestLogicState onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (event instanceof MOEventDialogInteract) {
            if (this.isTarget(((MOEventDialogInteract)event).npc) && this.targetOption.equalsOption(((MOEventDialogInteract)event).dialogOption)) {
                this.setTalked(questStack, true);
                this.markComplete(questStack, entityPlayer);
                return new QuestLogicState(QuestState.Type.COMPLETE, true);
            }
        } else if (event instanceof MOEventDialogConstruct.Post && this.given != null && this.isTarget(((MOEventDialogConstruct)event).npc) && ((MOEventDialogConstruct)event).mainMessage instanceof DialogMessage) {
            for (IDialogOption option : this.given) {
                ((DialogMessage)((MOEventDialogConstruct)event).mainMessage).addOption(option);
            }
        }
        return null;
    }

    @Override
    public void onQuestTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void onQuestCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }

    public boolean isTarget(IDialogNpc npc) {
        EntityLiving entity = npc.getEntity();
        if (this.regex != null && !entity.func_145748_c_().func_150254_d().matches(this.regex)) {
            return false;
        }
        return this.npcType.equals(EntityList.func_75621_b((Entity)entity));
    }

    public boolean hasTalked(QuestStack questStack) {
        if (questStack.getTagCompound() != null) {
            return questStack.getTagCompound().func_74767_n("talked");
        }
        return false;
    }

    public void setTalked(QuestStack questStack, boolean talked) {
        if (questStack.getTagCompound() == null) {
            questStack.setTagCompound(new NBTTagCompound());
        }
        questStack.getTagCompound().func_74757_a("talked", talked);
    }
}

