/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonObject;
import java.util.List;
import java.util.Random;
import matteroverdrive.api.events.MOEventDialogInteract;
import matteroverdrive.api.quest.IQuestReward;
import matteroverdrive.api.quest.QuestLogicState;
import matteroverdrive.api.quest.QuestStack;
import matteroverdrive.api.quest.QuestState;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import matteroverdrive.entity.EntityVillagerMadScientist;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemSpade;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class QuestLogicCocktailOfAscension
extends AbstractQuestLogic {
    public static final int MAX_CREEPER_KILS = 5;
    public static final int MAX_GUNPOWDER_COUNT = 5;
    public static final int MAX_MUSHROOM_COUNT = 5;

    @Override
    public void loadFromJson(JsonObject jsonObject) {
    }

    @Override
    public String modifyInfo(QuestStack questStack, String info) {
        return String.format(info, "", 5, 5);
    }

    @Override
    public boolean isObjectiveCompleted(QuestStack questStack, EntityPlayer entityPlayer, int objectiveIndex) {
        if (objectiveIndex == 0) {
            return this.getCreeperKillCount(questStack) >= 5;
        }
        if (objectiveIndex == 1) {
            return this.getGunpowderCount(questStack) >= 5;
        }
        if (objectiveIndex == 2) {
            return this.getMushroomCount(questStack) >= 5;
        }
        if (objectiveIndex == 3) {
            return this.hasTalkedTo(questStack);
        }
        return false;
    }

    @Override
    public String modifyObjective(QuestStack questStack, EntityPlayer entityPlayer, String objective, int objectiveIndex) {
        if (objectiveIndex == 0) {
            return objective.replace("%2$s", Integer.toString(this.getCreeperKillCount(questStack))).replace("%3$s", Integer.toString(5));
        }
        if (objectiveIndex == 1) {
            return objective.replace("%2$s", Integer.toString(this.getGunpowderCount(questStack))).replace("%3$s", Integer.toString(5));
        }
        if (objectiveIndex == 2) {
            return objective.replace("%2$s", Integer.toString(this.getMushroomCount(questStack))).replace("%3$s", Integer.toString(5));
        }
        return objective;
    }

    @Override
    public int modifyObjectiveCount(QuestStack questStack, EntityPlayer entityPlayer, int count) {
        if (questStack.hasGiver() && this.getCreeperKillCount(questStack) >= 5 && this.getGunpowderCount(questStack) >= 5 && this.getMushroomCount(questStack) >= 5) {
            return 4;
        }
        return 3;
    }

    @Override
    public void initQuestStack(Random random, QuestStack questStack) {
    }

    public int getCreeperKillCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74771_c("CreeperKills");
        }
        return 0;
    }

    public int getMushroomCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74771_c("MushroomCount");
        }
        return 0;
    }

    public int getGunpowderCount(QuestStack questStack) {
        if (this.hasTag(questStack)) {
            return this.getTag(questStack).func_74771_c("GunpowderCount");
        }
        return 0;
    }

    public boolean hasTalkedTo(QuestStack questStack) {
        if (questStack.hasGiver()) {
            if (this.hasTag(questStack)) {
                return this.getTag(questStack).func_74767_n("TalkedToGiver");
            }
            return false;
        }
        return true;
    }

    @Override
    public QuestLogicState onEvent(QuestStack questStack, Event event, EntityPlayer entityPlayer) {
        if (this.getCreeperKillCount(questStack) < 5 && event instanceof LivingDeathEvent) {
            if (((LivingDeathEvent)event).getEntityLiving() instanceof EntityCreeper && !entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_190926_b() && entityPlayer.func_184586_b(EnumHand.MAIN_HAND).func_77973_b() instanceof ItemSpade) {
                this.initTag(questStack);
                byte currentCreeperKillCount = this.getTag(questStack).func_74771_c("CreeperKills");
                currentCreeperKillCount = (byte)(currentCreeperKillCount + 1);
                this.getTag(questStack).func_74774_a("CreeperKills", currentCreeperKillCount);
                return new QuestLogicState(QuestState.Type.UPDATE, true);
            }
        } else if (event instanceof EntityItemPickupEvent) {
            ItemStack itemStack = ((EntityItemPickupEvent)event).getItem().func_92059_d();
            if (!itemStack.func_190926_b()) {
                if (itemStack.func_77973_b() instanceof ItemBlock && ((ItemBlock)itemStack.func_77973_b()).func_179223_d() == Blocks.field_150337_Q && entityPlayer.field_70170_p.field_73011_w.getDimension() == -1) {
                    this.initTag(questStack);
                    byte mushroomCount = this.getTag(questStack).func_74771_c("MushroomCount");
                    if (mushroomCount < 5) {
                        int newMushroomCount = Math.min(mushroomCount + itemStack.func_190916_E(), 5);
                        int takenMushrooms = newMushroomCount - mushroomCount;
                        itemStack.func_190918_g(takenMushrooms);
                        this.getTag(questStack).func_74774_a("MushroomCount", (byte)newMushroomCount);
                        return new QuestLogicState(QuestState.Type.UPDATE, true);
                    }
                } else if (itemStack.func_77973_b() == Items.field_151016_H) {
                    this.initTag(questStack);
                    byte gunpowderCount = this.getTag(questStack).func_74771_c("GunpowderCount");
                    if (gunpowderCount < 5) {
                        int newGunpowderCount = Math.min(gunpowderCount + itemStack.func_190916_E(), 5);
                        int takenGunpowder = newGunpowderCount - gunpowderCount;
                        itemStack.func_190918_g(takenGunpowder);
                        this.getTag(questStack).func_74774_a("GunpowderCount", (byte)newGunpowderCount);
                        itemStack.func_190918_g(1);
                        return new QuestLogicState(QuestState.Type.UPDATE, true);
                    }
                }
            }
        } else if (event instanceof MOEventDialogInteract && ((MOEventDialogInteract)event).npc instanceof EntityVillagerMadScientist && ((MOEventDialogInteract)event).dialogOption == EntityVillagerMadScientist.cocktailOfAscensionComplete) {
            this.initTag(questStack);
            this.getTag(questStack).func_74757_a("TalkedToGiver", true);
            this.markComplete(questStack, entityPlayer);
            return new QuestLogicState(QuestState.Type.COMPLETE, true);
        }
        return null;
    }

    @Override
    public void onQuestTaken(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void onQuestCompleted(QuestStack questStack, EntityPlayer entityPlayer) {
    }

    @Override
    public void modifyRewards(QuestStack questStack, EntityPlayer entityPlayer, List<IQuestReward> rewards) {
    }
}

