/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.quest.logic;

import com.google.gson.JsonObject;
import matteroverdrive.data.quest.QuestBlock;
import matteroverdrive.data.quest.QuestItem;
import matteroverdrive.data.quest.logic.AbstractQuestLogic;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;

public abstract class AbstractQuestLogicBlock
extends AbstractQuestLogic {
    protected QuestBlock block;
    protected QuestItem blockStack;

    public AbstractQuestLogicBlock() {
    }

    public AbstractQuestLogicBlock(QuestBlock block) {
        this.block = block;
    }

    public AbstractQuestLogicBlock(QuestItem blockStack) {
        this.blockStack = blockStack;
    }

    @Override
    public void loadFromJson(JsonObject jsonObject) {
        if (jsonObject.has("block")) {
            this.block = new QuestBlock(jsonObject.getAsJsonObject("block"));
        } else {
            this.blockStack = new QuestItem(jsonObject.getAsJsonObject("item"));
        }
    }

    protected boolean areBlockStackTheSame(ItemStack stack) {
        return this.blockStack.getItemStack().func_77969_a(stack) && ItemStack.func_77970_a((ItemStack)this.blockStack.getItemStack(), (ItemStack)stack);
    }

    protected boolean areBlocksTheSame(IBlockState blockState) {
        return this.block.isTheSame(blockState);
    }

    protected String replaceBlockNameInText(String text) {
        text = this.blockStack != null ? text.replace("$block", this.blockStack.getItemStack().func_82833_r()) : text.replace("$block", this.block.getBlockState().func_177230_c().func_149732_F());
        return text;
    }
}

