/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.matter_network;

import io.netty.buffer.ByteBuf;
import matteroverdrive.data.matter_network.ItemPattern;
import net.minecraft.util.math.BlockPos;

public class ItemPatternMapping {
    private ItemPattern itemPattern;
    private BlockPos databaseId;
    private int storageId;
    private int patternId;

    public ItemPatternMapping(ByteBuf byteBuf) {
        this.itemPattern = ItemPattern.fromBuffer(byteBuf);
        this.databaseId = BlockPos.func_177969_a((long)byteBuf.readLong());
        this.storageId = byteBuf.readByte();
        this.patternId = byteBuf.readByte();
    }

    public ItemPatternMapping(ItemPattern itemPattern, BlockPos databaseId, int storageId, int patternId) {
        this.databaseId = databaseId;
        this.itemPattern = itemPattern;
        this.storageId = storageId;
        this.patternId = patternId;
    }

    public ItemPattern getItemPattern() {
        return this.itemPattern;
    }

    public BlockPos getDatabaseId() {
        return this.databaseId;
    }

    public void writeToBuffer(ByteBuf byteBuf) {
        ItemPattern.writeToBuffer(byteBuf, this.itemPattern);
        byteBuf.writeLong(this.databaseId.func_177986_g());
        byteBuf.writeByte(this.storageId);
        byteBuf.writeByte(this.patternId);
    }

    public int getStorageId() {
        return this.storageId;
    }

    public int getPatternId() {
        return this.patternId;
    }
}

