/*
 * Decompiled with CFR 0.152.
 */
package matteroverdrive.data.matter_network;

import io.netty.buffer.ByteBuf;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ItemPattern {
    private int itemID;
    private int damage;
    private int progress;

    public ItemPattern() {
    }

    public ItemPattern(ItemStack itemStack) {
        this(itemStack, 0);
    }

    public ItemPattern(ItemStack itemStack, int progress) {
        this(Item.func_150891_b((Item)itemStack.func_77973_b()), itemStack.func_77952_i(), progress);
    }

    public ItemPattern(int itemID) {
        this(itemID, 0, 0);
    }

    public ItemPattern(int itemID, int damage) {
        this(itemID, damage, 0);
    }

    public ItemPattern(int itemID, int damage, int progress) {
        this.itemID = itemID;
        this.damage = damage;
        this.progress = progress;
    }

    public ItemPattern(NBTTagCompound tagCompound) {
        this.readFromNBT(tagCompound);
    }

    public static ItemPattern fromBuffer(ByteBuf byteBuf) {
        short itemID = byteBuf.readShort();
        if (itemID < 0) {
            return null;
        }
        ItemPattern pattern = new ItemPattern(itemID);
        pattern.progress = byteBuf.readByte();
        pattern.damage = byteBuf.readShort();
        return pattern;
    }

    public static void writeToBuffer(ByteBuf byteBuf, ItemPattern itemPattern) {
        if (itemPattern == null) {
            byteBuf.writeShort(-1);
        } else {
            byteBuf.writeShort(itemPattern.itemID);
            byteBuf.writeByte(itemPattern.progress);
            byteBuf.writeShort(itemPattern.damage);
        }
    }

    public ItemStack toItemStack(boolean withInfo) {
        ItemStack itemStack = new ItemStack(Item.func_150899_d((int)this.itemID));
        itemStack.func_77964_b(this.damage);
        if (withInfo) {
            itemStack.func_77982_d(new NBTTagCompound());
            itemStack.func_77978_p().func_74774_a("scan_progress", (byte)this.progress);
        }
        return itemStack;
    }

    public void writeToNBT(NBTTagCompound nbtTagCompound) {
        nbtTagCompound.func_74777_a("id", (short)this.itemID);
        nbtTagCompound.func_74774_a("scan_progress", (byte)this.progress);
        nbtTagCompound.func_74777_a("Damage", (short)this.damage);
    }

    public void readFromNBT(NBTTagCompound nbtTagCompound) {
        this.itemID = nbtTagCompound.func_74765_d("id");
        this.progress = nbtTagCompound.func_74771_c("scan_progress");
        this.damage = nbtTagCompound.func_74765_d("Damage");
    }

    public int getItemID() {
        return this.itemID;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int progress) {
        this.progress = progress;
    }

    public float getProgressF() {
        return (float)this.progress / 100.0f;
    }

    public int getDamage() {
        return this.damage;
    }

    public void setDamage(int damage) {
        this.damage = damage;
    }

    public Item getItem() {
        return Item.func_150899_d((int)this.getItemID());
    }

    public boolean equals(ItemStack itemStack) {
        if (itemStack != null) {
            return this.getDamage() == itemStack.func_77952_i() && this.getItemID() == Item.func_150891_b((Item)itemStack.func_77973_b());
        }
        return false;
    }

    public boolean equals(ItemPattern pattern) {
        return this.getItemID() == pattern.getItemID() && this.getDamage() == pattern.getDamage();
    }

    public boolean equals(Object object) {
        if (super.equals(object)) {
            return true;
        }
        if (object instanceof ItemPattern) {
            return this.equals((ItemPattern)object);
        }
        return false;
    }

    public String getDisplayName() {
        return this.toItemStack(false).func_82833_r();
    }

    public ItemPattern copy() {
        ItemPattern pattern = new ItemPattern(this.itemID, this.damage, this.progress);
        return pattern;
    }

    public int hashCode() {
        return this.itemID + this.damage + this.progress;
    }
}

